/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.metadata.authentication;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.metadata.authentication.PackageDefinitions;
import com.vmware.vapi.metadata.authentication.PackageSyncProvider;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class PackageSyncApiInterface
extends ApiInterfaceSkeleton {
    private PackageSyncProvider impl;

    public PackageSyncApiInterface() {
        this((Class<? extends PackageSyncProvider>)null);
    }

    public PackageSyncApiInterface(Class<? extends PackageSyncProvider> implClass) {
        this((PackageSyncProvider)PackageSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.vapi.metadata.authentication.impl.PackageImpl", PackageSyncProvider.class));
    }

    public PackageSyncApiInterface(PackageSyncProvider impl) {
        super("com.vmware.vapi.metadata.authentication.package");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(PackageSyncApiInterface.this.getIdentifier(), "get", PackageDefinitions.__getInput, PackageDefinitions.__getOutput, PackageSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, PackageDefinitions.__getInput, PackageSyncApiInterface.this.getTypeConverter());
            String packageId = (String)extr.valueForField("package_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PackageSyncApiInterface.this.getTypeConverter().convertToVapi((Object)PackageSyncApiInterface.this.impl.get(packageId, invocationContext), PackageDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(PackageSyncApiInterface.this.getIdentifier(), "list", PackageDefinitions.__listInput, PackageDefinitions.__listOutput, PackageSyncApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(inStruct, PackageDefinitions.__listInput, PackageSyncApiInterface.this.getTypeConverter());
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PackageSyncApiInterface.this.getTypeConverter().convertToVapi(PackageSyncApiInterface.this.impl.list(invocationContext), PackageDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

