/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.metadata.authentication;

import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.metadata.authentication.SourceDefinitions;
import com.vmware.vapi.metadata.authentication.SourceProvider;
import com.vmware.vapi.metadata.authentication.SourceTypes;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class SourceApiInterface
extends ApiInterfaceSkeleton {
    private SourceProvider impl;

    public SourceApiInterface() {
        this((Class<? extends SourceProvider>)null);
    }

    public SourceApiInterface(Class<? extends SourceProvider> implClass) {
        this((SourceProvider)SourceApiInterface.createImplInstance(implClass, (String)"com.vmware.vapi.metadata.authentication.impl.SourceImpl", SourceProvider.class));
    }

    public SourceApiInterface(SourceProvider impl) {
        super("com.vmware.vapi.metadata.authentication.source");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new ReloadApiMethod());
        this.registerMethod((ApiMethod)new FingerprintApiMethod());
    }

    private class FingerprintApiMethod
    extends ApiMethodSkeleton {
        public FingerprintApiMethod() {
            super(SourceApiInterface.this.getIdentifier(), "fingerprint", SourceDefinitions.__fingerprintInput, SourceDefinitions.__fingerprintOutput, SourceApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SourceDefinitions.__fingerprintInput, SourceApiInterface.this.getTypeConverter());
            String sourceId = (String)extr.valueForField("source_id");
            SourceApiInterface.this.impl.fingerprint(sourceId, (AsyncContext<String>)new AsyncContextImpl(SourceApiInterface.this.getTypeConverter(), SourceDefinitions.__fingerprintOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ReloadApiMethod
    extends ApiMethodSkeleton {
        public ReloadApiMethod() {
            super(SourceApiInterface.this.getIdentifier(), "reload", SourceDefinitions.__reloadInput, SourceDefinitions.__reloadOutput, SourceApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SourceDefinitions.__reloadInput, SourceApiInterface.this.getTypeConverter());
            String sourceId = (String)extr.valueForField("source_id");
            SourceApiInterface.this.impl.reload(sourceId, (AsyncContext<Void>)new AsyncContextImpl(SourceApiInterface.this.getTypeConverter(), SourceDefinitions.__reloadOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(SourceApiInterface.this.getIdentifier(), "list", SourceDefinitions.__listInput, SourceDefinitions.__listOutput, SourceApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(inStruct, SourceDefinitions.__listInput, SourceApiInterface.this.getTypeConverter());
            SourceApiInterface.this.impl.list((AsyncContext<List<String>>)new AsyncContextImpl(SourceApiInterface.this.getTypeConverter(), SourceDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(SourceApiInterface.this.getIdentifier(), "get", SourceDefinitions.__getInput, SourceDefinitions.__getOutput, SourceApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SourceDefinitions.__getInput, SourceApiInterface.this.getTypeConverter());
            String sourceId = (String)extr.valueForField("source_id");
            SourceApiInterface.this.impl.get(sourceId, (AsyncContext<SourceTypes.Info>)new AsyncContextImpl(SourceApiInterface.this.getTypeConverter(), SourceDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(SourceApiInterface.this.getIdentifier(), "delete", SourceDefinitions.__deleteInput, SourceDefinitions.__deleteOutput, SourceApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SourceDefinitions.__deleteInput, SourceApiInterface.this.getTypeConverter());
            String sourceId = (String)extr.valueForField("source_id");
            SourceApiInterface.this.impl.delete(sourceId, (AsyncContext<Void>)new AsyncContextImpl(SourceApiInterface.this.getTypeConverter(), SourceDefinitions.__deleteOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(SourceApiInterface.this.getIdentifier(), "create", SourceDefinitions.__createInput, SourceDefinitions.__createOutput, SourceApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SourceDefinitions.__createInput, SourceApiInterface.this.getTypeConverter());
            String sourceId = (String)extr.valueForField("source_id");
            SourceTypes.CreateSpec spec = (SourceTypes.CreateSpec)extr.valueForField("spec");
            SourceApiInterface.this.impl.create(sourceId, spec, (AsyncContext<Void>)new AsyncContextImpl(SourceApiInterface.this.getTypeConverter(), SourceDefinitions.__createOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

