/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.metadata.routing.service;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.metadata.routing.service.OperationDefinitions;
import com.vmware.vapi.metadata.routing.service.OperationSyncProvider;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class OperationSyncApiInterface
extends ApiInterfaceSkeleton {
    private OperationSyncProvider impl;

    public OperationSyncApiInterface() {
        this((Class<? extends OperationSyncProvider>)null);
    }

    public OperationSyncApiInterface(Class<? extends OperationSyncProvider> implClass) {
        this((OperationSyncProvider)OperationSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.vapi.metadata.routing.service.impl.OperationImpl", OperationSyncProvider.class));
    }

    public OperationSyncApiInterface(OperationSyncProvider impl) {
        super("com.vmware.vapi.metadata.routing.service.operation");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(OperationSyncApiInterface.this.getIdentifier(), "get", OperationDefinitions.__getInput, OperationDefinitions.__getOutput, OperationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, OperationDefinitions.__getInput, OperationSyncApiInterface.this.getTypeConverter());
            String serviceId = (String)extr.valueForField("service_id");
            String operationId = (String)extr.valueForField("operation_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)OperationSyncApiInterface.this.getTypeConverter().convertToVapi((Object)OperationSyncApiInterface.this.impl.get(serviceId, operationId, invocationContext), OperationDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(OperationSyncApiInterface.this.getIdentifier(), "list", OperationDefinitions.__listInput, OperationDefinitions.__listOutput, OperationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, OperationDefinitions.__listInput, OperationSyncApiInterface.this.getTypeConverter());
            String serviceId = (String)extr.valueForField("service_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)OperationSyncApiInterface.this.getTypeConverter().convertToVapi(OperationSyncApiInterface.this.impl.list(serviceId, invocationContext), OperationDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

