/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.ActionMenuItem;
import com.vmware.vise.actionsfw.ActionMenusRequestSpec;
import com.vmware.vise.actionsfw.ActionToolbarRequestSpec;
import com.vmware.vise.actionsfw.ActionsRequestSpec;
import com.vmware.vise.actionsfw.ActionsService;
import com.vmware.vise.actionsfw.RequestPolicy;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/actionsService"})
public class ActionsServiceController
extends ExceptionHandler {
    private static final Log _logger = LogFactory.getLog(ActionsServiceController.class);
    private final ActionsService _actionsService;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public ActionsServiceController(ActionsService actionsService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._actionsService = actionsService;
        this._objectReferenceService = objectReferenceService;
    }

    @RequestMapping(value={"/toolbar"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActionMenuItem> getToolbarActions(@RequestParam(value="listViewId", required=true) String string, @RequestParam(value="targetUids", required=false) String[] stringArray) {
        ActionToolbarRequestSpec actionToolbarRequestSpec = new ActionToolbarRequestSpec();
        actionToolbarRequestSpec.listViewId = string;
        ActionContext actionContext = new ActionContext();
        List<Object> list = this.getObjectRefsForTargets(stringArray);
        actionContext.setTargetObjects(list);
        actionToolbarRequestSpec.context = actionContext;
        return this._actionsService.getToolbarActions(actionToolbarRequestSpec);
    }

    @RequestMapping(value={"/menu"}, method={RequestMethod.GET})
    @ResponseBody
    public ActionMenuItem getOrBuildMenu(@RequestParam(value="menuType", required=true) String string, @RequestParam(value="targetUids", required=false) String[] stringArray) {
        ActionMenusRequestSpec actionMenusRequestSpec = new ActionMenusRequestSpec();
        actionMenusRequestSpec.menuTypes = ArrayUtil.toArrayList((Object[])StringUtil.splitAndTrim((String)string, (String)","));
        ActionContext actionContext = new ActionContext();
        List<Object> list = this.getObjectRefsForTargets(stringArray);
        actionContext.setTargetObjects(list);
        actionMenusRequestSpec.context = actionContext;
        return this._actionsService.getOrBuildMenu(actionMenusRequestSpec);
    }

    @RequestMapping(value={"/actions/descriptions/{actionUid:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public Action getAction(@PathVariable(value="actionUid") String string) {
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("Action identifer must not be null or empty.");
        }
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.actionUids = ArrayUtil.toArrayList((Object[])new String[]{string});
        List list = this._actionsService.getActions(actionsRequestSpec, false);
        if (list.size() == 0) {
            throw new IllegalArgumentException("No Action registered with ID " + string + ".");
        }
        assert (list.size() == 1) : "Received more than one action with ID " + string + ".";
        return (Action)list.get(0);
    }

    @RequestMapping(value={"/actions/descriptions"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Action> getActions(@RequestParam(value="actionUids", required=false) String[] stringArray, @RequestParam(value="targetTypes", required=false) String string, @RequestParam(value="globalActions", required=false) String string2) {
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.actionUids = ArrayUtil.toArrayList((Object[])stringArray);
        actionsRequestSpec.targetTypes = ArrayUtil.toArrayList((Object[])StringUtil.splitAndTrim((String)string, (String)","));
        if (!StringUtil.isNullOrWhitespace((String)string2)) {
            actionsRequestSpec.globalActions = RequestPolicy.valueOf((String)string2.toUpperCase());
        }
        return this._actionsService.getActions(actionsRequestSpec, false);
    }

    @RequestMapping(value={"/actions/evaluations/{actionUid:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public ActionEvaluation getActionEvaluation(@PathVariable(value="actionUid") String string, @RequestParam(value="targetUids", required=false) String[] stringArray) throws Exception {
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("Action identifer must not be null or empty.");
        }
        ActionContext actionContext = new ActionContext();
        actionContext.setTargetObjects(this.getObjectRefsForTargets(stringArray));
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.context = actionContext;
        actionsRequestSpec.actionUids = ArrayUtil.toArrayList((Object[])new String[]{string});
        List list = this._actionsService.getEvaluatedActions(actionsRequestSpec, false);
        if (list.size() == 0) {
            throw new IllegalArgumentException("No Action registered with ID " + string + ".");
        }
        assert (list.size() == 1) : "Found more than one action with ID " + string + ".";
        return (ActionEvaluation)list.get(0);
    }

    @RequestMapping(value={"/actions/evaluations"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActionEvaluation> getActionEvaluations(@RequestParam(value="actionUids", required=false) String[] stringArray, @RequestParam(value="targetUids", required=false) String[] stringArray2, @RequestParam(value="globalActions", required=false) String string, @RequestParam(value="skipActionFilteringStage", required=false, defaultValue="false") boolean bl) throws Exception {
        ActionContext actionContext = new ActionContext();
        List<Object> list = this.getObjectRefsForTargets(stringArray2);
        actionContext.setTargetObjects(list);
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.context = actionContext;
        if (!ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            actionsRequestSpec.actionUids = ArrayUtil.toArrayList((Object[])stringArray);
        }
        if (!StringUtil.isNullOrEmpty((String)string)) {
            actionsRequestSpec.globalActions = RequestPolicy.valueOf((String)string.toUpperCase());
        }
        List list2 = this._actionsService.getEvaluatedActions(actionsRequestSpec, bl);
        return list2;
    }

    @RequestMapping(value={"/menus"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActionMenuItem> getMenus() {
        ActionMenusRequestSpec actionMenusRequestSpec = new ActionMenusRequestSpec();
        return this._actionsService.getMenus(actionMenusRequestSpec);
    }

    @RequestMapping(value={"/menus/{menuType:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActionMenuItem> getMenus(@PathVariable(value="menuType") String string, @RequestParam(value="targetUids", required=false) String[] stringArray) {
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("Menu type must not be null or empty.");
        }
        ActionMenusRequestSpec actionMenusRequestSpec = new ActionMenusRequestSpec();
        actionMenusRequestSpec.menuTypes = ArrayUtil.toArrayList((Object[])StringUtil.splitAndTrim((String)string, (String)","));
        if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            return this._actionsService.getMenus(actionMenusRequestSpec);
        }
        return this.getApplicableMenus(stringArray, actionMenusRequestSpec);
    }

    @RequestMapping(value={"/menus/{menuType:.*}/{menuUid:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public ActionMenuItem getMenu(@PathVariable(value="menuType") String string, @PathVariable(value="menuUid") String string2, @RequestParam(value="targetUids", required=false) String[] stringArray) {
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("Menu type must not be null or empty.");
        }
        if (StringUtil.isNullOrWhitespace((String)string2)) {
            throw new IllegalArgumentException("Menu uid must not be null or empty.");
        }
        ActionMenusRequestSpec actionMenusRequestSpec = new ActionMenusRequestSpec();
        actionMenusRequestSpec.menuTypes = ArrayUtil.toArrayList((Object[])new String[]{string});
        actionMenusRequestSpec.menuIds = ArrayUtil.toArrayList((Object[])new String[]{string2});
        List<ActionMenuItem> list = ArrayUtil.isNullOrEmpty((Object[])stringArray) ? this._actionsService.getMenus(actionMenusRequestSpec) : this.getApplicableMenus(stringArray, actionMenusRequestSpec);
        if (list.size() > 1) {
            _logger.warn((Object)("More than one menu registered with uid " + string2));
        }
        return list.get(0);
    }

    private List<ActionMenuItem> getApplicableMenus(String[] stringArray, ActionMenusRequestSpec actionMenusRequestSpec) {
        ActionContext actionContext = new ActionContext();
        List<Object> list = this.getObjectRefsForTargets(stringArray);
        actionContext.setTargetObjects(list);
        actionMenusRequestSpec.context = actionContext;
        return this._actionsService.getMenus(actionMenusRequestSpec);
    }

    private List<Object> getObjectRefsForTargets(String[] stringArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        for (String string : stringArray) {
            Object object = this._objectReferenceService.getReference(string, true);
            if (object == null) {
                _logger.warn((Object)("Object " + string + " could not be found."));
                continue;
            }
            arrayList.add(object);
        }
        return arrayList;
    }
}

