/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.google.gson.Gson;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginDependency;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.mvc.telemetry.DataCollectionConfigurator;
import com.vmware.vise.mvc.util.I18nServiceHelper;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AppStartController {
    private final ExtensionService _extensionService;
    private final I18nServiceHelper _i18nServiceHelper;
    private final ConfigurationService _configurationService;
    private static final boolean _isReleaseBuild = BuildProperties.isReleaseBuild();
    private static final String _xsrfCookieName = BuildProperties.getXsrfCookieName();
    private static final String _xsrfHeaderName = BuildProperties.getXsrfHeaderName();
    private Date _applicationStartedDate;
    private final DataCollectionConfigurator _dataCollectionConfigurator;

    @Autowired
    public AppStartController(ExtensionService extensionService, I18nServiceHelper i18nServiceHelper, ConfigurationService configurationService, DataCollectionConfigurator dataCollectionConfigurator) {
        this._extensionService = extensionService;
        this._i18nServiceHelper = i18nServiceHelper;
        this._configurationService = configurationService;
        this._applicationStartedDate = new Date();
        this._dataCollectionConfigurator = dataCollectionConfigurator;
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public final String getIndexPage(ModelMap modelMap, @RequestParam(value="debug", required=false, defaultValue="false") boolean bl, @RequestParam(value="stylesheet", required=false, defaultValue="clarity-preview") String string) throws Exception {
        void var8_11;
        ArrayList<PluginDependency> arrayList = new ArrayList<PluginDependency>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        PluginInfo[] pluginInfoArray = this._extensionService.getPluginInfos();
        FilenameHelper filenameHelper = new FilenameHelper(bl);
        for (PluginInfo pluginInfo : pluginInfoArray) {
            PluginDependency[] pluginDependencyArray;
            String string2 = pluginInfo.getType().trim();
            if ("angularjs".equalsIgnoreCase(string2)) {
                arrayList2.add(pluginInfo.getId().trim());
            }
            if ((pluginDependencyArray = pluginInfo.getDependencies()) == null) continue;
            arrayList.addAll(Arrays.asList(pluginDependencyArray));
        }
        String string3 = this._configurationService.getProperty("installation.id");
        if (string3 == null) {
            String string4 = "";
        }
        String string5 = this._configurationService.getProperty("browser.context.menu");
        int n = Boolean.parseBoolean(string5) ? 1 : 0;
        boolean bl2 = false;
        try {
            bl2 = this._dataCollectionConfigurator.isCeipEnabled();
        }
        catch (NotAuthenticatedError notAuthenticatedError) {
            // empty catch block
        }
        modelMap.addAttribute("angularModules", (Object)new Gson().toJson(arrayList2));
        modelMap.addAttribute("dependencies", arrayList);
        modelMap.addAttribute("installationId", (Object)var8_11);
        modelMap.addAttribute("filenameHelper", (Object)filenameHelper);
        modelMap.addAttribute("stylesheet", (Object)string);
        modelMap.addAttribute("isBrowserContextMenuEnabled", (Object)(n != 0));
        modelMap.addAttribute("isTelemetryEnabled", (Object)bl2);
        return "index";
    }

    @RequestMapping(value={"/cache/h5-namespace-init"}, method={RequestMethod.GET})
    public final String getH5NamespaceInitPage(ModelMap modelMap) throws Exception {
        Locale locale = ResourceUtil.getLocale();
        String string = this._i18nServiceHelper.getResources(locale.toString());
        modelMap.addAttribute("applicationStartedDate", (Object)this._applicationStartedDate);
        modelMap.addAttribute("languageResource", (Object)string);
        modelMap.addAttribute("xsrfCookieName", (Object)_xsrfCookieName);
        modelMap.addAttribute("xsrfHeaderName", (Object)_xsrfHeaderName);
        modelMap.addAttribute("isReleaseBuild", (Object)_isReleaseBuild);
        return "h5-namespace-init";
    }

    public class FilenameHelper {
        private Boolean _debug;

        public FilenameHelper(Boolean bl) {
            this._debug = bl;
        }

        public String getFilename(String string) {
            if (this._debug.booleanValue()) {
                return string.replace(".min", "");
            }
            return string;
        }
    }
}

