/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.model.data.MultiPropertyRequestSpec;
import com.vmware.vise.mvc.model.data.ParamSpec;
import com.vmware.vise.mvc.util.ParameterSpecHelper;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.service.ClassLoaderService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/data"}, method={RequestMethod.GET})
public class DataAccessController
extends ExceptionHandler {
    private static final String OBJECT_ID = "id";
    private static final Log _logger = LogFactory.getLog(DataAccessController.class);
    private final DataService _dataService;
    private final ObjectReferenceService _objectReferenceService;
    private final ClassLoaderService _classLoaderService;
    private final ObjectMapper _objectMapper;
    private final QueryBindingServiceFactory _queryBindingServiceFactory;
    private final QueryService _queryService;

    @Autowired
    public DataAccessController(DataService dataService, ObjectMapper objectMapper, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ClassLoaderService classLoaderService, QueryBindingServiceFactory queryBindingServiceFactory, QueryServiceFactory queryServiceFactory) {
        this._dataService = dataService;
        this._objectMapper = objectMapper;
        this._objectReferenceService = objectReferenceService;
        this._classLoaderService = classLoaderService;
        this._queryBindingServiceFactory = queryBindingServiceFactory;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @RequestMapping(value={"/{objectId}"})
    @ResponseBody
    public <T> T getData(@PathVariable(value="objectId") String string, @RequestParam(value="model", required=true) String string2) throws ClassNotFoundException {
        if (StringUtil.isNullOrEmpty((String)string2)) {
            return null;
        }
        Object object = this._objectReferenceService.getReference(string, true);
        Class clazz = this._classLoaderService.loadClass(string2);
        if (!clazz.isAnnotationPresent(QueryBinding.class)) {
            throw new UnsupportedOperationException("Not supported model class " + clazz);
        }
        QueryBindingService queryBindingService = this._queryBindingServiceFactory.getQueryBindingService();
        Object object2 = queryBindingService.prepare(clazz).fetch(object);
        return (T)object2;
    }

    @RequestMapping(value={"/properties/{objectId}"})
    @ResponseBody
    public Map<String, Object> getProperties(@PathVariable(value="objectId") String string, @RequestParam(value="properties", required=true) String string2) throws Exception {
        return this.getPropertiesWithParams(string, string2, null);
    }

    @RequestMapping(value={"/propertiesByRelation/{objectId}"})
    @ResponseBody
    public PropertyValue[] getPropertiesForRelatedObject(@PathVariable(value="objectId") String string, @RequestParam(value="relation", required=true) String string2, @RequestParam(value="targetType", required=true) String string3, @RequestParam(value="properties", required=true) String string4) throws Exception {
        Object object = this._objectReferenceService.getReference(string, true);
        String[] stringArray = string4.split(",");
        PropertyValue[] propertyValueArray = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)object, (String)string2, (String)string3, (String[])stringArray);
        return propertyValueArray;
    }

    @RequestMapping(value={"/propertiesWithParameters/{objectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getProperties(@PathVariable(value="objectId") String string, @RequestParam(value="properties", required=true) String string2, @RequestBody ParamSpec[] paramSpecArray) throws Exception {
        ParameterSpecHelper parameterSpecHelper = new ParameterSpecHelper(this._classLoaderService, this._objectMapper, paramSpecArray);
        Map<String, List<ParameterSpec>> map = parameterSpecHelper.getParameterSpecs();
        return this.getPropertiesWithParams(string, string2, map);
    }

    @RequestMapping(value={"/multipleProperties"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getProperties(@RequestBody MultiPropertyRequestSpec multiPropertyRequestSpec) throws Exception {
        if (multiPropertyRequestSpec.objectIds == null || multiPropertyRequestSpec.objectIds.length == 0) {
            return Collections.emptyMap();
        }
        int n = multiPropertyRequestSpec.objectIds.length;
        Object[] objectArray = new Object[n];
        String string = null;
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this._objectReferenceService.getReference(multiPropertyRequestSpec.objectIds[i], true);
            string = this._objectReferenceService.getResourceObjectType(objectArray[i]);
            if (string2 != null && !string2.equals(string)) {
                throw new IllegalArgumentException("Cannot retrieve properties for heterogeneous object set.");
            }
            string2 = string;
        }
        ParameterSpecHelper parameterSpecHelper = new ParameterSpecHelper(this._classLoaderService, this._objectMapper, multiPropertyRequestSpec.params);
        Map<String, List<ParameterSpec>> map = parameterSpecHelper.getParameterSpecs();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(multiPropertyRequestSpec.properties));
        arrayList.add("@modelKey");
        List<PropertyPredicate> list = this.buildFilterSpec(objectArray, map);
        ResultSet resultSet = this._queryService.select(arrayList).from(new String[]{string}).where(LogicalOperator.AND, list).fetch();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List list2 = resultSet.getItems();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object object = resourceItem.getKey();
            String string3 = this._objectReferenceService.getUid(object, true);
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap.put(string3, hashMap2);
            for (String string4 : multiPropertyRequestSpec.properties) {
                hashMap2.put(string4, resourceItem.get(string4));
            }
        }
        return hashMap;
    }

    private Map<String, Object> getPropertiesWithParams(String string, String string2, Map<String, List<ParameterSpec>> map) {
        Object object = this._objectReferenceService.getReference(string, true);
        String[] stringArray = !StringUtil.isNullOrWhitespace((String)string2) ? string2.split(",") : new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        arrayList.add("@modelKey");
        List<PropertyPredicate> list = this.buildFilterSpec(new Object[]{object}, map);
        String string3 = this._objectReferenceService.getResourceObjectType(object);
        ResultSet resultSet = this._queryService.select(arrayList).from(new String[]{string3}).where(LogicalOperator.AND, list).fetch();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List list2 = resultSet.getItems();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object object2 = resourceItem.getKey();
            hashMap.put(OBJECT_ID, this._objectReferenceService.getUid(object2, true));
            for (String string4 : stringArray) {
                hashMap.put(string4, resourceItem.get(string4));
            }
        }
        return hashMap;
    }

    private List<PropertyPredicate> buildFilterSpec(Object[] objectArray, Map<String, List<ParameterSpec>> map) {
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>();
        arrayList.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(objectArray)));
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, List<ParameterSpec>> entry : map.entrySet()) {
                for (ParameterSpec parameterSpec : entry.getValue()) {
                    PropertyPredicate propertyPredicate = new PropertyPredicate(entry.getKey() + "/@param", PropertyPredicate.ComparisonOperator.EQUAL, parameterSpec.parameter);
                    arrayList.add(propertyPredicate);
                }
            }
        }
        return arrayList;
    }
}

