/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.FileManager;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.host.DatastoreBrowser;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.datastorebrowser.model.DatastoreBrowserItem;
import com.vmware.vise.mvc.datastorebrowser.model.DatastoreData;
import com.vmware.vise.mvc.datastorebrowser.model.DatastoreItem;
import com.vmware.vise.mvc.datastorebrowser.model.FileItem;
import com.vmware.vise.mvc.datastorebrowser.model.FolderItem;
import com.vmware.vise.mvc.util.CommonUtils;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.storage.FileSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/datastoreBrowserTree"}, method={RequestMethod.GET})
public class DatastoreBrowserController
extends ExceptionHandler {
    private final DataService _dataService;
    private final ObjectReferenceService _objReferenceService;
    private final String HOST_DATASTORE_BROWSER_TYPE = "HostDatastoreBrowser";
    private final String SEARCHABLE_DATASTORES_PROP_NAME = "searchableDatastore";
    private final String FILE_PROP_NAME = "file";
    private static final int VM_DISK_TYPE = 1;
    private static final int FLOPPY_IMAGE_TYPE = 2;
    private static final int ISO_IMAGE_TYPE = 4;
    private static final int VM_CONFIG_FILES_TYPE = 8;
    private static final String ALL_FILES_TYPE_STR = "0x0010";
    private static final int ALL_FILES_TYPE = Integer.parseInt("0x0010".replaceAll("0x", ""), 16);
    private static final int FOLDERS_TYPE = 32;

    @Autowired
    public DatastoreBrowserController(DataService dataService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._dataService = dataService;
        this._objReferenceService = objectReferenceService;
    }

    @ResponseBody
    @RequestMapping(value={"/root/{objectId}"})
    public List<DatastoreBrowserItem> getRoot(@PathVariable(value="objectId") String string, @RequestParam(value="datastores", required=false) String[] stringArray, @RequestParam(value="showVmImagesFolder", required=false, defaultValue="false") boolean bl) throws Exception {
        List<DatastoreBrowserItem> list = null;
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)this._objReferenceService.getReference(string, true);
        if (managedObjectReference == null) {
            throw new IllegalArgumentException("Object id is invalid");
        }
        Object[] objectArray = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, (String)"HostDatastoreBrowser")) {
            if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
                return null;
            }
            objectArray = new ManagedObjectReference[stringArray.length];
            int n = 0;
            for (String string2 : stringArray) {
                ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)this._objReferenceService.getReference(string2, true);
                objectArray[n++] = managedObjectReference2;
            }
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, VirtualMachine.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, HostSystem.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, ComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, ClusterComputeResource.class)) {
            objectArray = (ManagedObjectReference[])QueryUtil.getProperty((DataService)this._dataService, (Object)managedObjectReference, (String)"searchableDatastore");
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, Datastore.class)) {
            objectArray = new ManagedObjectReference[]{managedObjectReference};
        }
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            throw new IllegalArgumentException("No datastores to request data for");
        }
        list = this.getDatastoreItems((ManagedObjectReference[])objectArray);
        if (bl) {
            list.add(this.createVmImagesFolderItem());
        }
        return list;
    }

    @ResponseBody
    @RequestMapping(value={"/children/{objectId}"})
    public List<DatastoreBrowserItem> getChildren(@PathVariable(value="objectId") String string, @RequestParam(value="datastorePath", required=true) String string2, @RequestParam(value="fileQueryType", required=false, defaultValue="0x0010") int n, @RequestParam(value="pattern", required=false) String string3, @RequestParam(value="searchInSubFolders", required=false, defaultValue="false") boolean bl) throws Exception {
        ArrayList<DatastoreBrowserItem> arrayList = new ArrayList<DatastoreBrowserItem>();
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)this._objReferenceService.getReference(string, true);
        if (managedObjectReference == null) {
            throw new IllegalArgumentException("Object id is invalid");
        }
        FileSpec fileSpec = this.createFileSpec(string2, n, string3, bl);
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.parameter = fileSpec;
        parameterSpec.propertyName = "file";
        ArrayList<ParameterSpec> arrayList2 = new ArrayList<ParameterSpec>(1);
        arrayList2.add(parameterSpec);
        HashMap<String, ArrayList<ParameterSpec>> hashMap = new HashMap<String, ArrayList<ParameterSpec>>();
        hashMap.put("file", arrayList2);
        PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object)managedObjectReference, (String[])new String[]{"file"}, hashMap);
        OperationResult operationResult = (OperationResult)propertyValueArray[0].value;
        if (operationResult.result == null) {
            return arrayList;
        }
        DatastoreBrowser.SearchResults[] searchResultsArray = null;
        if (operationResult.result instanceof DatastoreBrowser.SearchResults) {
            searchResultsArray = new DatastoreBrowser.SearchResults[]{(DatastoreBrowser.SearchResults)operationResult.result};
        } else if (operationResult.result.getClass().isArray()) {
            searchResultsArray = (DatastoreBrowser.SearchResults[])operationResult.result;
        } else {
            return arrayList;
        }
        FolderItem folderItem = null;
        for (DatastoreBrowser.SearchResults searchResults : searchResultsArray) {
            if (searchResults.file == null) continue;
            for (DatastoreBrowser.FileInfo fileInfo : searchResults.file) {
                if (fileInfo instanceof DatastoreBrowser.FolderInfo) {
                    folderItem = this.createFolderItem((DatastoreBrowser.FolderInfo)fileInfo, searchResults.folderPath);
                    arrayList.add(folderItem);
                } else if (fileInfo instanceof DatastoreBrowser.VmDiskInfo) {
                    folderItem = this.createFileItem(fileInfo, searchResults.folderPath);
                    DatastoreBrowser.VmDiskInfo vmDiskInfo = (DatastoreBrowser.VmDiskInfo)fileInfo;
                    folderItem.diskExtents = vmDiskInfo.diskExtents;
                    arrayList.add(folderItem);
                } else {
                    folderItem = this.createFileItem(fileInfo, searchResults.folderPath);
                    arrayList.add(folderItem);
                }
                folderItem.localizedType = this.getLocalizedFileType(fileInfo);
            }
        }
        this.sortDatastoreItems(arrayList);
        this.updateSortOrder(arrayList);
        return arrayList;
    }

    private void sortDatastoreItems(List<DatastoreBrowserItem> list) {
        Collections.sort(list, new Comparator<DatastoreBrowserItem>(){

            @Override
            public int compare(DatastoreBrowserItem datastoreBrowserItem, DatastoreBrowserItem datastoreBrowserItem2) {
                if (datastoreBrowserItem.getType() == null) {
                    if (datastoreBrowserItem2.getType() == null) {
                        return this.compareItemsByName(datastoreBrowserItem, datastoreBrowserItem2);
                    }
                    return -1;
                }
                if (datastoreBrowserItem2.getType() == null) {
                    return 1;
                }
                if (datastoreBrowserItem.getType().equals(datastoreBrowserItem2.getType())) {
                    return this.compareItemsByName(datastoreBrowserItem, datastoreBrowserItem2);
                }
                if (datastoreBrowserItem.getType().equals("folder")) {
                    return -1;
                }
                if (datastoreBrowserItem2.getType().equals("folder")) {
                    return 1;
                }
                return this.compareItemsByName(datastoreBrowserItem, datastoreBrowserItem2);
            }

            private int compareItemsByName(DatastoreBrowserItem datastoreBrowserItem, DatastoreBrowserItem datastoreBrowserItem2) {
                if (datastoreBrowserItem.name == null && datastoreBrowserItem2.name == null) {
                    return 0;
                }
                if (datastoreBrowserItem.name == null) {
                    return -1;
                }
                if (datastoreBrowserItem2.name == null) {
                    return 1;
                }
                return datastoreBrowserItem.name.compareToIgnoreCase(datastoreBrowserItem2.name);
            }
        });
    }

    private void updateSortOrder(List<DatastoreBrowserItem> list) {
        int n = 0;
        for (DatastoreBrowserItem datastoreBrowserItem : list) {
            datastoreBrowserItem.nameSortOrder = n++;
        }
    }

    private List<DatastoreBrowserItem> getDatastoreItems(ManagedObjectReference[] managedObjectReferenceArray) {
        ArrayList<DatastoreBrowserItem> arrayList = new ArrayList<DatastoreBrowserItem>();
        DataFetchCommand dataFetchCommand = DataFetchCommandFactory.getDataFetchCommand((DataService)this._dataService);
        Collection collection = dataFetchCommand.execute(DatastoreData.class, (Object[])managedObjectReferenceArray);
        if (collection == null) {
            return arrayList;
        }
        for (DatastoreData datastoreData : collection) {
            DatastoreItem datastoreItem = this.createDatastoreItem(datastoreData);
            arrayList.add(datastoreItem);
        }
        return arrayList;
    }

    private DatastoreItem createDatastoreItem(DatastoreData datastoreData) {
        DatastoreItem datastoreItem = new DatastoreItem();
        datastoreItem.name = datastoreData.name;
        datastoreItem.path = String.format("[%s]", datastoreData.name);
        datastoreItem.spriteCssClass = datastoreData.primaryIconId;
        datastoreItem.totalCapacity = FormatUtil.getStorageFormatted((Long)datastoreData.totalCapacity, (long)1L, (long)-1L);
        datastoreItem.availableCapacity = FormatUtil.getStorageFormatted((Long)datastoreData.availableCapacity, (long)1L, (long)-1L);
        return datastoreItem;
    }

    private FolderItem createVmImagesFolderItem() {
        return this.createFolderItem(null, null);
    }

    private FolderItem createFolderItem(DatastoreBrowser.FolderInfo folderInfo, String string) {
        FolderItem folderItem = new FolderItem();
        folderItem.spriteCssClass = "vsphere-icon-folder";
        if (folderInfo == null) {
            folderItem.name = CommonUtils.text("vmImagesFolder.name");
            folderItem.path = "<vmimages>";
        } else {
            folderItem.name = folderInfo.path;
            folderItem.path = this.getFilePath(folderItem.name, string);
            folderItem.lastModified = folderInfo.modification;
        }
        return folderItem;
    }

    private FileItem createFileItem(DatastoreBrowser.FileInfo fileInfo, String string) {
        FileItem fileItem = new FileItem();
        fileItem.name = fileInfo.path;
        fileItem.path = this.getFilePath(fileInfo.path, string);
        fileItem.fileType = this.getFileType(fileInfo);
        fileItem.spriteCssClass = this.getFileIcon(fileInfo);
        fileItem.lastModified = fileInfo.modification;
        fileItem.size = fileInfo.fileSize;
        return fileItem;
    }

    private String getFilePath(String string, String string2) {
        String string3 = null;
        String string4 = StringUtils.trim((String)string2);
        string3 = string4.endsWith("/") ? string4 + string : (string4.endsWith("]") ? String.format("%s %s", string4, string) : String.format("%s/%s", string4, string));
        return string3;
    }

    private String getFileIcon(DatastoreBrowser.FileInfo fileInfo) {
        if (fileInfo instanceof DatastoreBrowser.FloppyImageInfo) {
            return "icon-vSphere-dsFloppyImage";
        }
        if (fileInfo instanceof DatastoreBrowser.VmDiskInfo) {
            return "icon-vSphere-dsVmDisk";
        }
        if (fileInfo instanceof DatastoreBrowser.VmLogInfo) {
            return "icon-vSphere-dsVmLog";
        }
        if (fileInfo instanceof DatastoreBrowser.VmNvramInfo) {
            return "icon-vSphere-dsVmNvram";
        }
        if (fileInfo instanceof DatastoreBrowser.IsoImageInfo) {
            return "icon-vSphere-dsIsoImage";
        }
        if (fileInfo instanceof DatastoreBrowser.VmSnapshotInfo) {
            return "icon-vSphere-dsVmSnapshot";
        }
        if (fileInfo instanceof DatastoreBrowser.TemplateVmConfigInfo) {
            return "icon-vSphere-dsVmTemplate";
        }
        if (fileInfo instanceof DatastoreBrowser.VmConfigInfo) {
            return "vsphere-icon-vm";
        }
        return "icon-vSphere-dsFile";
    }

    private String getFileType(DatastoreBrowser.FileInfo fileInfo) {
        if (fileInfo instanceof DatastoreBrowser.VmDiskInfo) {
            return FileManager.FileType.VirtualDisk.toString();
        }
        return FileManager.FileType.File.toString();
    }

    public String getLocalizedFileType(DatastoreBrowser.FileInfo fileInfo) {
        String string = "";
        string = fileInfo instanceof DatastoreBrowser.FloppyImageInfo ? "dsExplorer.floppyImage" : (fileInfo instanceof DatastoreBrowser.IsoImageInfo ? "dsExplorer.isoImage" : (fileInfo instanceof DatastoreBrowser.VmDiskInfo ? "dsExplorer.vmDisk" : (fileInfo instanceof DatastoreBrowser.TemplateVmConfigInfo ? "dsExplorer.templateVMConfig" : (fileInfo instanceof DatastoreBrowser.VmConfigInfo ? "dsExplorer.vmConfig" : (fileInfo instanceof DatastoreBrowser.VmLogInfo ? "dsExplorer.vmLog" : (fileInfo instanceof DatastoreBrowser.VmNvramInfo ? "dsExplorer.vmNvram" : (fileInfo instanceof DatastoreBrowser.VmSnapshotInfo ? "dsExplorer.vmSnapshot" : (fileInfo instanceof DatastoreBrowser.FolderInfo ? "dsExplorer.folder" : "dsExplorer.file"))))))));
        return CommonUtils.text(string);
    }

    private FileSpec createFileSpec(String string, int n, String string2, boolean bl) {
        DatastoreBrowser.SearchSpec searchSpec = this.createSearchSpec(n, string2);
        FileSpec fileSpec = new FileSpec();
        fileSpec.datastorePath = string;
        fileSpec.searchSpec = searchSpec;
        fileSpec.subFolders = bl;
        return fileSpec;
    }

    private DatastoreBrowser.SearchSpec createSearchSpec(int n, String string) {
        DatastoreBrowser.SearchSpec searchSpec;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if ((n & 2) > 0) {
            arrayList.add(new DatastoreBrowser.FloppyImageQuery());
        }
        if ((n & 4) > 0) {
            arrayList.add(new DatastoreBrowser.IsoImageQuery());
        }
        if ((n & 1) > 0) {
            arrayList.add(new DatastoreBrowser.VmDiskQuery());
        }
        if ((n & 8) > 0) {
            arrayList.add(new DatastoreBrowser.VmConfigQuery());
        }
        if ((n & 0x20) > 0) {
            arrayList.add(new DatastoreBrowser.FolderQuery());
        }
        if ((n & ALL_FILES_TYPE) > 0) {
            arrayList.add(new DatastoreBrowser.FolderQuery());
            arrayList.add(new DatastoreBrowser.FloppyImageQuery());
            arrayList.add(new DatastoreBrowser.IsoImageQuery());
            arrayList.add(new DatastoreBrowser.VmConfigQuery());
            arrayList.add(new DatastoreBrowser.TemplateVmConfigQuery());
            arrayList.add(new DatastoreBrowser.VmLogQuery());
            arrayList.add(new DatastoreBrowser.VmNvramQuery());
            arrayList.add(new DatastoreBrowser.VmSnapshotQuery());
            searchSpec = new DatastoreBrowser.VmDiskQuery();
            searchSpec.details = new DatastoreBrowser.VmDiskQuery.Details();
            searchSpec.details.capacityKb = true;
            searchSpec.details.diskExtents = true;
            searchSpec.details.thin = true;
            arrayList.add(searchSpec);
            arrayList.add(new DatastoreBrowser.Query());
        }
        searchSpec = new DatastoreBrowser.SearchSpec();
        searchSpec.query = arrayList.toArray(new DatastoreBrowser.Query[0]);
        searchSpec.searchCaseInsensitive = true;
        searchSpec.sortFoldersFirst = true;
        searchSpec.details = new DatastoreBrowser.FileInfo.Details();
        searchSpec.details.fileOwner = true;
        searchSpec.details.fileSize = true;
        searchSpec.details.fileType = true;
        searchSpec.details.modification = true;
        if (!StringUtil.isNullOrEmpty((String)string)) {
            searchSpec.matchPattern = new String[]{string};
        }
        return searchSpec;
    }
}

