/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.events.EventFormatter;
import com.vmware.vise.mvc.events.model.EventListItemData;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class EventsViewController
extends ExceptionHandler {
    private final ObjectReferenceService _objectReferenceService;
    private final ObjectTypesManager _objectTypesManager;
    private final QuerySpecBuilder _querySpecBuilder;
    private final QueryExecutor _queryExecutor;
    private final EventFormatter _eventFormatter;
    private static final String EVENT_TYPE = Event.class.getSimpleName();

    @Autowired
    public EventsViewController(ObjectReferenceService objectReferenceService, DataService dataService, ObjectTypesManager objectTypesManager, QuerySpecBuilder querySpecBuilder, QueryExecutor queryExecutor) {
        this._objectReferenceService = objectReferenceService;
        this._objectTypesManager = objectTypesManager;
        this._querySpecBuilder = querySpecBuilder;
        this._queryExecutor = queryExecutor;
        this._eventFormatter = new EventFormatter(this._objectReferenceService, this._objectTypesManager);
    }

    @RequestMapping(value={"/events"})
    @ResponseBody
    public List<EventListItemData> getEvents(@RequestParam(value="objectId", required=false) String string, @RequestParam(value="requestedPage", defaultValue="0") int n, @RequestParam(value="requestingPrevPage", defaultValue="false") boolean bl, @RequestParam(value="serverGuid", required=false) String string2, @RequestParam(value="chainId", required=false) Integer n2) throws Exception {
        PropertyConstraint propertyConstraint;
        PropertyConstraint propertyConstraint2;
        PropertyConstraint propertyConstraint3;
        String[] stringArray;
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.AND;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PropertyConstraint propertyConstraint4 = this.createPropertyConstraint("info.currentPage", n);
        arrayList.add(propertyConstraint4);
        PropertyConstraint propertyConstraint5 = this.createPropertyConstraint("requestingPrevPage", bl);
        arrayList.add(propertyConstraint5);
        ManagedObjectReference managedObjectReference = null;
        if (string != null) {
            stringArray = this._objectReferenceService.getReference(string, true);
            propertyConstraint3 = this.createPropertyConstraint("info.entity", stringArray);
            arrayList.add(propertyConstraint3);
            propertyConstraint2 = this.createPropertyConstraint("info.recursion", "recursion.all");
            arrayList.add(propertyConstraint2);
            if (stringArray instanceof ManagedObjectReference) {
                managedObjectReference = (ManagedObjectReference)stringArray;
                propertyConstraint = this.createPropertyConstraint("info.serverGuid", managedObjectReference.getServerGuid());
                arrayList.add(propertyConstraint);
            }
        }
        if (string2 != null) {
            stringArray = this.createPropertyConstraint("info.serverGuid", string2);
            arrayList.add(stringArray);
        }
        if (n2 != null) {
            stringArray = this.createPropertyConstraint("info.eventChainId", n2);
            arrayList.add(stringArray);
        }
        compositeConstraint.nestedConstraints = arrayList.toArray(new Constraint[arrayList.size()]);
        stringArray = new String[]{"info", "taskInfoName", "contextSensitiveMessage"};
        propertyConstraint3 = this._querySpecBuilder.buildQuerySpec((Constraint)compositeConstraint, stringArray, Collections.singleton(EVENT_TYPE));
        propertyConstraint2 = new ParameterSpec();
        propertyConstraint2.propertyName = "contextObject";
        propertyConstraint2.parameter = managedObjectReference;
        propertyConstraint3.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{propertyConstraint2};
        propertyConstraint = this._queryExecutor.getData((QuerySpec)propertyConstraint3);
        if (propertyConstraint == null) {
            return null;
        }
        List<EventListItemData> list = this.formatResults((ResultSet)propertyConstraint, managedObjectReference, string2);
        return list;
    }

    private PropertyConstraint createPropertyConstraint(String string, Object object) {
        return QueryUtil.createPropertyConstraint((String)EVENT_TYPE, (String)string, (Comparator)Comparator.EQUALS, (Object)object);
    }

    private List<EventListItemData> formatResults(ResultSet resultSet, ManagedObjectReference managedObjectReference, String string) {
        ArrayList<EventListItemData> arrayList = new ArrayList<EventListItemData>();
        for (ResultItem resultItem : resultSet.items) {
            EventListItemData eventListItemData = new EventListItemData();
            for (PropertyValue propertyValue : resultItem.properties) {
                if (propertyValue.propertyName.equals("taskInfoName")) {
                    eventListItemData.taskInfoName = (String)propertyValue.value;
                    continue;
                }
                if (propertyValue.propertyName.equals("contextSensitiveMessage")) {
                    eventListItemData.contextSensitiveMessage = (String)propertyValue.value;
                    continue;
                }
                if (!propertyValue.propertyName.equals("info")) continue;
                this._eventFormatter.setEventListItemData(eventListItemData, (ClientEventInfo)propertyValue.value);
            }
            arrayList.add(eventListItemData);
        }
        return arrayList;
    }
}

