/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.google.gson.Gson;
import com.vmware.vise.data.query.DataException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseBody;

public class ExceptionHandler {
    private static final Log _logger = LogFactory.getLog(ExceptionHandler.class);

    @org.springframework.web.bind.annotation.ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Map<String, String> handleException(Exception exception, HttpServletResponse httpServletResponse) {
        String string;
        String[] stringArray;
        httpServletResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("message", exception.getMessage());
        Throwable throwable = null;
        if (exception.getCause() != null) {
            throwable = exception.getCause();
            if (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            hashMap.put("cause", throwable.toString());
        }
        if ((stringArray = ExceptionUtils.getRootCauseStackTrace((Throwable)exception)).length > 0) {
            string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string = string + '\n' + stringArray[i];
            }
            hashMap.put("stackTrace", string);
            _logger.error((Object)"Exception handled in a controller: ", (Throwable)exception);
        }
        if (exception instanceof DataException) {
            string = (DataException)exception;
            Gson gson = new Gson();
            if (((DataException)string).objects != null && ((DataException)string).objects.length > 0) {
                hashMap.put("de_objects", gson.toJson((Object)((DataException)string).objects));
            }
            if (((DataException)string).properties != null && ((DataException)string).properties.length > 0) {
                hashMap.put("de_properties", gson.toJson((Object)((DataException)string).properties));
            }
        }
        return hashMap;
    }
}

