/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.CombinedExtensionPointInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.controllers.ExtensionServiceUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ExtensionServiceController
extends ExceptionHandler {
    private final ExtensionService _extensionService;
    private final ObjectReferenceService _objRefService;

    @Autowired
    public ExtensionServiceController(ExtensionService extensionService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._extensionService = extensionService;
        this._objRefService = objectReferenceService;
    }

    @RequestMapping(value={"/extensions/{pointId}/{objectId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public <T> List<T> getExtensionObjects(@PathVariable(value="pointId") String string, @PathVariable(value="objectId") String string2) {
        Map<String, Object> map = ExtensionServiceUtil.getFilterContext(this._objRefService, string2);
        return this._extensionService.getExtensionObjects(string, map, true);
    }

    @RequestMapping(value={"/hostedextensions/{extensionId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public <T> List<T> getHostedExtensionObjectsByExtensionId(@PathVariable(value="extensionId") String string, @RequestParam(value="objectId", required=false) String string2) throws Exception {
        return ExtensionServiceUtil.getHostedExtensionObjectsByExtensionId(this._extensionService, string, this._objRefService, string2);
    }

    @RequestMapping(value={"/allExtensions"}, method={RequestMethod.GET})
    @ResponseBody
    public CombinedExtensionPointInfo[] getAllExtensionObjects() {
        CombinedExtensionPointInfo[] combinedExtensionPointInfoArray = this._extensionService.getAllCombinedExtensionPointInfos();
        Arrays.sort(combinedExtensionPointInfoArray, new Comparator<CombinedExtensionPointInfo>(){

            @Override
            public int compare(CombinedExtensionPointInfo combinedExtensionPointInfo, CombinedExtensionPointInfo combinedExtensionPointInfo2) {
                return combinedExtensionPointInfo.getPoint().getId().compareTo(combinedExtensionPointInfo2.getPoint().getId());
            }
        });
        return combinedExtensionPointInfoArray;
    }
}

