/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.ActionsRequestSpec;
import com.vmware.vise.actionsfw.ActionsService;
import com.vmware.vise.actionsfw.RequestPolicy;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.issues.model.IssueSummaryItem;
import com.vmware.vise.mvc.issues.model.IssueSummaryItemResultSet;
import com.vmware.vise.mvc.util.VmToolsUtil;
import com.vmware.vise.util.ArrayUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IssuesViewController
extends ExceptionHandler {
    private static final Log _logger = LogFactory.getLog(IssuesViewController.class);
    private final ObjectReferenceService _objectReferenceService;
    private final QuerySpecBuilder _querySpecBuilder;
    private final QueryExecutor _queryExecutor;
    private final ActionsService _actionsService;
    private static final String ISSUE_TYPE = "Issue";
    private static final String ISSUE_INFO_PROPERTY = "info";
    private static final String ISSUE_ENTITY_PROPERTY = "info.entity";

    @Autowired
    public IssuesViewController(ObjectReferenceService objectReferenceService, QuerySpecBuilder querySpecBuilder, QueryExecutor queryExecutor, ActionsService actionsService) {
        this._objectReferenceService = objectReferenceService;
        this._querySpecBuilder = querySpecBuilder;
        this._queryExecutor = queryExecutor;
        this._actionsService = actionsService;
    }

    @RequestMapping(value={"/issues"})
    @ResponseBody
    public final IssueSummaryItemResultSet getIssues(@RequestParam(value="objectId", required=true) String string, @RequestParam(value="count", defaultValue="-1") int n, @RequestParam(value="getActionEvaluations", required=false, defaultValue="false") boolean bl) throws Exception {
        PropertyConstraint propertyConstraint = null;
        Object object = null;
        String[] stringArray = new String[]{ISSUE_INFO_PROPERTY};
        ResultSpec resultSpec = new ResultSpec();
        if (string != null) {
            object = this._objectReferenceService.getReference(string, true);
            propertyConstraint = this.createPropertyConstraint(object);
        }
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(propertyConstraint, stringArray, Collections.singleton(ISSUE_TYPE));
        resultSpec.maxResultCount = n;
        querySpec.resultSpec = resultSpec;
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        IssueSummaryItemResultSet issueSummaryItemResultSet = this.formatResults(resultSet, object, bl);
        return issueSummaryItemResultSet;
    }

    private PropertyConstraint createPropertyConstraint(Object object) {
        return QueryUtil.createPropertyConstraint((String)ISSUE_TYPE, (String)ISSUE_ENTITY_PROPERTY, (Comparator)Comparator.EQUALS, (Object)object);
    }

    private IssueSummaryItemResultSet formatResults(ResultSet resultSet, Object object, boolean bl) {
        IssueSummaryItemResultSet issueSummaryItemResultSet = new IssueSummaryItemResultSet();
        ArrayList<IssueSummaryItem> arrayList = new ArrayList<IssueSummaryItem>();
        for (ResultItem resultItem : resultSet.items) {
            for (PropertyValue propertyValue : resultItem.properties) {
                IssueInfo issueInfo = (IssueInfo)propertyValue.value;
                IssueSummaryItem issueSummaryItem = new IssueSummaryItem();
                issueSummaryItem.issueUid = this._objectReferenceService.getUid(resultItem.resourceObject);
                issueSummaryItem.entity = issueInfo.entity;
                issueSummaryItem.entityId = this._objectReferenceService.getUid(issueInfo.entity);
                if (object != null && !object.equals(issueInfo.entity)) {
                    issueSummaryItem.entityName = issueInfo.entityName;
                }
                issueSummaryItem.description = issueInfo.description;
                issueSummaryItem.status = issueInfo.status;
                issueSummaryItem.issueType = issueInfo.typeDisplayName;
                issueSummaryItem.details = issueInfo.details;
                issueSummaryItem.dateText = issueInfo.timestamp != null ? new SimpleDateFormat("MM/dd/yyyy h:mm:ss a").format(issueInfo.timestamp) : "";
                if (bl) {
                    ActionsRequestSpec actionsRequestSpec = IssuesViewController.createActionsSpec(resultItem.resourceObject);
                    try {
                        List<Action> list = this._actionsService.getActions(actionsRequestSpec, false);
                        list = this.filterIssueActions(list, issueInfo.details, resultItem.resourceObject, object);
                        issueSummaryItem.actionEvaluations = this.evaluateActions(list, object);
                    }
                    catch (Exception exception) {
                        _logger.error((Object)("Error while evaluating available actions for: " + resultItem.resourceObject), (Throwable)exception);
                    }
                }
                arrayList.add(issueSummaryItem);
            }
        }
        issueSummaryItemResultSet.totalMatchedObjectCount = resultSet.totalMatchedObjectCount;
        issueSummaryItemResultSet.summaryItemSpecs = arrayList;
        return issueSummaryItemResultSet;
    }

    private List<Action> filterIssueActions(List<Action> list, Object object, Object object2, Object object3) {
        if (object == null || object3 == null || object2 == null) {
            return list;
        }
        String string = this._objectReferenceService.getResourceObjectType(object2);
        String string2 = this._objectReferenceService.getResourceObjectType(object3);
        String string3 = object.getClass().getSimpleName();
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (Action action : list) {
            List list2 = action.getApplicableTargetTypes();
            if (VmToolsUtil.isVmIssueActionInapplicable(action, object).booleanValue() || list2.size() == 3 && list2.contains(string) && list2.contains(string2) && !list2.contains(string3)) continue;
            arrayList.add(action);
        }
        return arrayList;
    }

    private List<ActionEvaluation> evaluateActions(List<Action> list, Object object) throws Exception {
        if (ArrayUtil.isNullOrEmpty(list)) {
            return null;
        }
        ActionsRequestSpec actionsRequestSpec = IssuesViewController.createActionsSpec(object);
        actionsRequestSpec.actionUids = new ArrayList(list.size());
        for (Action action : list) {
            actionsRequestSpec.actionUids.add(action.getUid());
        }
        return this._actionsService.getEvaluatedActions(actionsRequestSpec, false);
    }

    private static ActionsRequestSpec createActionsSpec(Object object) {
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.context = new ActionContext();
        actionsRequestSpec.globalActions = RequestPolicy.EXCLUDE;
        actionsRequestSpec.context.setTargetObjects(Arrays.asList(object));
        return actionsRequestSpec;
    }
}

