/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.common.api.filters.QueryFilterRegistry;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.relateditems.RelatedItemsManager;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/list"})
public class ListViewController
extends ExceptionHandler {
    private static final Log _logger = LogFactory.getLog(ListViewController.class);
    private static final String RELATED_ITEMS_LIST_FILTER_ID = "relatedItemsListFilterId";
    private static final String SIMPLE_SEARCH_LIST_FILTER_ID = "simpleSearchListFilterId";
    private final ObjectReferenceService _objectReferenceService;
    private final ExtensionService _extensionService;
    private final DataService _dataService;
    private final QueryServiceFactory _queryServiceFactory;
    private final QueryFilterRegistry _queryFilterRegistry;
    private final RelatedItemsManager _relatedItemsManager;
    private static final String OBJECT_ID = "id";

    @Autowired
    public ListViewController(@Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ExtensionService extensionService, DataService dataService, QueryServiceFactory queryServiceFactory, QueryFilterRegistry queryFilterRegistry, RelatedItemsManager relatedItemsManager) {
        this._objectReferenceService = objectReferenceService;
        this._extensionService = extensionService;
        this._dataService = dataService;
        this._queryServiceFactory = queryServiceFactory;
        this._queryFilterRegistry = queryFilterRegistry;
        this._relatedItemsManager = relatedItemsManager;
    }

    @RequestMapping(value={"/ex/"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getListDataEx(@RequestParam(value="constraintObjectId", required=false) String string, @RequestParam(value="queryFilterId", required=false) String string2, @RequestParam(value="filterParams[]", required=false) String[] stringArray, @RequestParam(value="dataModels[]", required=false) String[] stringArray2, @RequestParam(value="requestedProperties[]") String[] stringArray3, @RequestParam(value="skip", defaultValue="0") int n, @RequestParam(value="take", defaultValue="-1") int n2, @RequestParam Map<String, String> map) throws Exception {
        if (StringUtil.isNullOrEmpty((String)string2)) {
            throw new IllegalArgumentException("Need a filterId to retrieve the list data.");
        }
        Constraint constraint = null;
        if (RELATED_ITEMS_LIST_FILTER_ID.equals(string2)) {
            constraint = this.createConstraintForRelatedItems(string, stringArray);
        } else if (SIMPLE_SEARCH_LIST_FILTER_ID.equals(string2)) {
            constraint = this.createConstraintForSimpleSearch(stringArray);
        }
        if (constraint != null) {
            Constraint constraint2 = this.createFilterConstraint(map, constraint.targetType);
            if (constraint2 != null) {
                constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{constraint, constraint2}, (Conjoiner)Conjoiner.AND);
            }
            return this.getListDataUsingConstraint(constraint, stringArray3, n, n2, map);
        }
        Filter filter = this.createFilter(string, string2, stringArray);
        if (filter != null) {
            if (ArrayUtil.isNullOrEmpty((Object[])stringArray2)) {
                throw new IllegalArgumentException("Data model(s) are required when filterId is specified.");
            }
            return this.getListDataUsingFilter(filter, stringArray2, stringArray3, n, n2, map);
        }
        return null;
    }

    private Constraint createConstraintForRelatedItems(String string, String[] stringArray) {
        Object object;
        if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            throw new IllegalArgumentException("Filter parameters expected.");
        }
        String string2 = stringArray[0];
        if (string != null) {
            object = this._objectReferenceService.getReference(string, true);
        } else {
            String string3 = stringArray[1];
            object = DefaultUriSchemeUtil.createUri((String)string3, (String)string3);
        }
        return this._relatedItemsManager.getConstraintByRelationId(object, string2);
    }

    private Constraint createConstraintForSimpleSearch(String[] stringArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            throw new IllegalArgumentException("Filter parameters expected.");
        }
        Constraint[] constraintArray = new Constraint[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string = stringArray[i];
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = object = this._objectReferenceService.getReference(string, true);
            objectIdentityConstraint.targetType = this._objectReferenceService.getResourceObjectType(object);
            constraintArray[i] = objectIdentityConstraint;
        }
        return QueryUtil.combineIntoSingleConstraint((Constraint[])constraintArray, (Conjoiner)Conjoiner.OR);
    }

    private Filter createFilter(String string, String string2, String[] stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("Need a constraint object id to retrieve the list data.");
        }
        return ArrayUtil.isNullOrEmpty((Object[])stringArray) ? this._queryFilterRegistry.get(string2, new Object[]{string}) : this._queryFilterRegistry.get(string2, new Object[]{string, stringArray});
    }

    private Map<String, Object> getListDataUsingConstraint(Constraint constraint, String[] stringArray, int n, int n2, Map<String, String> map) {
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])stringArray);
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.offset = n;
        resultSpec.maxResultCount = n2;
        resultSpec.order = this.createOrderingCriteria(map, constraint.targetType);
        querySpec.resultSpec = resultSpec;
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        if (response == null || response.resultSet == null) {
            return null;
        }
        return this.transformRelationDataToMap(response);
    }

    private Map<String, Object> getListDataUsingFilter(Filter filter, String[] stringArray, String[] stringArray2, int n, int n2, Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("@modelKey");
        arrayList.addAll(Arrays.asList(stringArray2));
        QueryService queryService = this._queryServiceFactory.getQueryService();
        List<SortCriterion> list = this.createSortCriteria(map);
        if (list.isEmpty()) {
            list.add(new SortCriterion("@modelKey"));
        }
        ResultSet resultSet = queryService.select(arrayList).from(stringArray).where(filter).orderBy(list).offset(n).limit(n2).fetch();
        return this.transformRelationDataToMap(resultSet, stringArray2);
    }

    private List<SortCriterion> createSortCriteria(Map<String, String> map) {
        ArrayList<SortCriterion> arrayList = new ArrayList<SortCriterion>();
        int n = 0;
        String string = map.get("sort[" + n + "][field]");
        while (string != null) {
            string = string.replace("['", "");
            string = string.replace("']", "");
            String string2 = map.get("sort[" + n + "][dir]");
            SortCriterion.SortDirection sortDirection = SortCriterion.SortDirection.ASCENDING;
            if ("desc".equalsIgnoreCase(string2)) {
                sortDirection = SortCriterion.SortDirection.DESCENDING;
            }
            SortCriterion sortCriterion = new SortCriterion(string, sortDirection);
            arrayList.add(sortCriterion);
            string = map.get("sort[" + ++n + "][field]");
        }
        return arrayList;
    }

    private Constraint createFilterConstraint(Map<String, String> map, String string) {
        String string2;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        String string3 = map.get("filter[filters][" + n + "][field]");
        while (string3 != null) {
            string3 = string3.replace("['", "");
            string3 = string3.replace("']", "");
            object = map.get("filter[filters][" + n + "][value]");
            string2 = QueryUtil.createPropertyConstraint((String)string, (String)string3, (Comparator)Comparator.TEXTUALLY_MATCHES, (Object)object);
            arrayList.add(string2);
            string3 = map.get("filter[filters][" + ++n + "][field]");
        }
        if (arrayList.size() == 0) {
            return null;
        }
        object = (Constraint)arrayList.get(0);
        if (arrayList.size() > 1) {
            string2 = map.get("filter[logic]");
            Conjoiner conjoiner = string2.equalsIgnoreCase("and") ? Conjoiner.AND : Conjoiner.OR;
            object = QueryUtil.createCompositeConstraint((Constraint[])arrayList.toArray(new Constraint[0]), (Conjoiner)conjoiner);
        }
        return object;
    }

    private OrderingCriteria createOrderingCriteria(Map<String, String> map, String string) {
        OrderingCriteria orderingCriteria = new OrderingCriteria();
        ArrayList<OrderingPropertySpec> arrayList = new ArrayList<OrderingPropertySpec>();
        int n = 0;
        String string2 = map.get("sort[" + n + "][field]");
        while (string2 != null) {
            string2 = string2.replace("['", "");
            string2 = string2.replace("']", "");
            String string3 = map.get("sort[" + n + "][dir]");
            OrderingPropertySpec orderingPropertySpec = new OrderingPropertySpec();
            orderingPropertySpec.type = string;
            orderingPropertySpec.propertyNames = new String[]{string2};
            orderingPropertySpec.orderingType = SortType.ASCENDING;
            if ("desc".equalsIgnoreCase(string3)) {
                orderingPropertySpec.orderingType = SortType.DESCENDING;
            }
            arrayList.add(orderingPropertySpec);
            string2 = map.get("sort[" + ++n + "][field]");
        }
        orderingCriteria.orderingProperties = arrayList.toArray(new OrderingPropertySpec[0]);
        return orderingCriteria;
    }

    private Map<String, Object> transformRelationDataToMap(Response response) {
        ArrayList arrayList = new ArrayList();
        com.vmware.vise.data.query.ResultSet resultSet = response.resultSet[0];
        for (ResultItem resultItem : resultSet.items) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (PropertyValue propertyValue : resultItem.properties) {
                if (propertyValue.value != null && this._objectReferenceService.getResourceObjectType(propertyValue.value) != null) {
                    String string = this._objectReferenceService.getUid(propertyValue.value, true);
                    hashMap.put(propertyValue.propertyName, string);
                    continue;
                }
                hashMap.put(propertyValue.propertyName, propertyValue.value);
            }
            hashMap.put(OBJECT_ID, this._objectReferenceService.getUid(resultItem.resourceObject, true));
            arrayList.add(hashMap);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("data", arrayList);
        hashMap.put("totalResultCount", resultSet.totalMatchedObjectCount);
        return hashMap;
    }

    private Map<String, Object> transformRelationDataToMap(ResultSet resultSet, String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        List list = resultSet.getItems();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                Object object = resourceItem.get(string);
                if (object != null && this._objectReferenceService.getResourceObjectType(object) != null) {
                    hashMap.put(string, this._objectReferenceService.getUid(object));
                    continue;
                }
                hashMap.put(string, object);
            }
            hashMap.put(OBJECT_ID, this._objectReferenceService.getUid(resourceItem.get("@modelKey")));
            arrayList.add(hashMap);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("data", arrayList);
        hashMap.put("totalResultCount", list.size());
        return hashMap;
    }
}

