/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.util.ObjectConvertUtils;
import com.vmware.vise.util.service.ClassLoaderService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mutation"})
public class MutationServiceController
extends ExceptionHandler {
    private final MutationService _mutationService;
    private final ObjectReferenceService _objRefService;
    private final ClassLoaderService _classLoaderService;
    private final ObjectMapper _objectMapper;
    private static final Log _logger = LogFactory.getLog(MutationServiceController.class);

    @Autowired
    public MutationServiceController(MutationService mutationService, ClassLoaderService classLoaderService, ObjectMapper objectMapper, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._mutationService = mutationService;
        this._classLoaderService = classLoaderService;
        this._objectMapper = objectMapper;
        this._objRefService = objectReferenceService;
    }

    @RequestMapping(value={"/{objectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult apply(@PathVariable(value="objectId") String string, @RequestParam(value="propertyName", required=true) String string2, @RequestBody Map<String, Object> map) {
        ResourceSpec resourceSpec = new ResourceSpec();
        Object object = this._objRefService.getReference(string);
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        resourceSpec.constraint = objectIdentityConstraint;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{string2};
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.parameter = map;
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        OperationResult[] operationResultArray = this._mutationService.applyData(resourceSpec);
        return operationResultArray[0];
    }

    @RequestMapping(value={"/apply/{objectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult apply(@PathVariable(value="objectId") String string, @RequestParam(value="propertyObjectType", required=true) String string2, @RequestBody String string3) {
        Object object;
        OperationResult operationResult = new OperationResult();
        Object object2 = null;
        try {
            object = this._classLoaderService.loadClass(string2);
            object2 = ObjectConvertUtils.fromJson(this._objectMapper, object, string3);
        }
        catch (Exception exception) {
            operationResult.error = exception;
            return operationResult;
        }
        object = this._objRefService.getReference(string);
        operationResult = this._mutationService.apply(object, object2);
        return operationResult;
    }

    @RequestMapping(value={"/applyMultiSpec/{objectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult applyMultiSpec(@PathVariable(value="objectId") String string, @RequestParam(value="propertyObjectType") String string2, @RequestBody List<Map<String, Object>> list) {
        Object[] objectArray = new Object[list.size()];
        try {
            Class clazz = this._classLoaderService.loadClass(string2);
            for (int i = 0; i < list.size(); ++i) {
                JSONObject jSONObject = new JSONObject();
                for (Map.Entry<String, Object> entry : list.get(i).entrySet()) {
                    jSONObject.put(entry.getKey(), entry.getValue());
                }
                objectArray[i] = this._objectMapper.readValue(jSONObject.toString(), clazz);
            }
        }
        catch (Exception exception) {
            OperationResult operationResult = new OperationResult();
            operationResult.error = exception;
            return operationResult;
        }
        return this._mutationService.applyMultiSpec(this._objRefService.getReference(string), objectArray);
    }

    @RequestMapping(value={"/applyOnMultiEntity"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult[] applyOnMultiEntity(@RequestParam(value="objectIds", required=true) String[] stringArray, @RequestParam(value="propertyObjectType", required=true) String string, @RequestBody String string2) {
        OperationResult operationResult = new OperationResult();
        Object object = null;
        try {
            Class clazz = this._classLoaderService.loadClass(string);
            object = ObjectConvertUtils.fromJson(this._objectMapper, clazz, string2);
        }
        catch (Exception exception) {
            operationResult.error = exception;
            return new OperationResult[]{operationResult};
        }
        int n = stringArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this._objRefService.getReference(stringArray[i]);
        }
        return this._mutationService.applyOnMultiEntity(objectArray, object);
    }

    @RequestMapping(value={"/validateOnMultiEntity"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult[] validateOnMultiEntity(@RequestParam(value="objectIds", required=true) String[] stringArray, @RequestParam(value="propertyObjectType", required=true) String string, @RequestBody String string2) {
        ValidationResult validationResult = new ValidationResult();
        Object object = null;
        try {
            Class clazz = this._classLoaderService.loadClass(string);
            object = ObjectConvertUtils.fromJson(this._objectMapper, clazz, string2);
        }
        catch (Exception exception) {
            validationResult.error = exception;
            return new ValidationResult[]{validationResult};
        }
        int n = stringArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this._objRefService.getReference(stringArray[i]);
        }
        return this._mutationService.validateOnMultiEntity(objectArray, object);
    }

    @RequestMapping(value={"/validate/{objectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult validate(@PathVariable(value="objectId") String string, @RequestParam(value="propertyObjectType", required=true) String string2, @RequestBody String string3) {
        Object object;
        ValidationResult validationResult = new ValidationResult();
        Object object2 = null;
        try {
            object = this._classLoaderService.loadClass(string2);
            object2 = ObjectConvertUtils.fromJson(this._objectMapper, object, string3);
        }
        catch (Exception exception) {
            validationResult.error = exception;
            return validationResult;
        }
        object = this._objRefService.getReference(string);
        validationResult = this._mutationService.validate(object, object2);
        return validationResult;
    }

    @RequestMapping(value={"/validateSpec"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult validate(@RequestParam(value="propertyObjectType", required=true) String string, @RequestBody String string2) {
        ValidationResult validationResult = new ValidationResult();
        Object object = null;
        try {
            Class clazz = this._classLoaderService.loadClass(string);
            object = ObjectConvertUtils.fromJson(this._objectMapper, clazz, string2);
        }
        catch (Exception exception) {
            validationResult.error = exception;
            return validationResult;
        }
        validationResult = this._mutationService.validate(null, object);
        return validationResult;
    }

    @RequestMapping(value={"/validateMultiSpec"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult[] validateMultiSpec(@RequestParam(value="propertyObjectType", required=true) String string, @RequestBody List<Map<String, Object>> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Object[] objectArray = new Object[list.size()];
        try {
            Class clazz = this._classLoaderService.loadClass(string);
            for (int i = 0; i < list.size(); ++i) {
                JSONObject jSONObject = new JSONObject();
                for (Map.Entry<String, Object> entry : list.get(i).entrySet()) {
                    jSONObject.put(entry.getKey(), entry.getValue());
                }
                objectArray[i] = ObjectConvertUtils.fromJson(this._objectMapper, clazz, jSONObject.toString());
            }
        }
        catch (Exception exception) {
            return null;
        }
        return this._mutationService.validateMultiSpec(null, objectArray);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult add(@RequestParam(value="propertyObjectType", required=true) String string, @RequestBody String string2) {
        OperationResult operationResult = new OperationResult();
        Object object = null;
        try {
            Class clazz = this._classLoaderService.loadClass(string);
            object = ObjectConvertUtils.fromJson(this._objectMapper, clazz, string2);
        }
        catch (Exception exception) {
            operationResult.error = exception;
            return operationResult;
        }
        operationResult = this._mutationService.add(object);
        return operationResult;
    }

    @RequestMapping(value={"/remove/{objectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult remove(@PathVariable(value="objectId") String string, @RequestParam(value="propertyObjectType", required=false) String string2, @RequestBody String string3) {
        Object object;
        OperationResult operationResult = new OperationResult();
        try {
            object = this.loadPropertyObject(string2, string3);
        }
        catch (Exception exception) {
            operationResult.error = exception;
            _logger.error((Object)String.format("Failed to load property object: %s", string2), (Throwable)exception);
            return operationResult;
        }
        Object object2 = this._objRefService.getReference(string);
        operationResult = this._mutationService.remove(object2, object);
        return operationResult;
    }

    private Object loadPropertyObject(String string, String string2) throws IOException, ClassNotFoundException {
        Object object = null;
        if (string == null) {
            return object;
        }
        Class clazz = this._classLoaderService.loadClass(string);
        object = ObjectConvertUtils.fromJson(this._objectMapper, clazz, string2);
        return object;
    }
}

