/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.controllers.ExtensionServiceUtil;
import com.vmware.vise.mvc.navigation.NavigationNode;
import com.vmware.vise.util.IUID;
import com.vmware.vise.util.ValidationUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class NavigationServiceController
extends ExceptionHandler {
    private static final Log _logger = LogFactory.getLog(NavigationServiceController.class);
    private final ExtensionService _extensionService;
    private final ObjectReferenceService _objRefService;
    private final QueryServiceFactory _queryServiceFactory;

    @Autowired
    public NavigationServiceController(QueryServiceFactory queryServiceFactory, ExtensionService extensionService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._queryServiceFactory = queryServiceFactory;
        this._extensionService = extensionService;
        this._objRefService = objectReferenceService;
    }

    @RequestMapping(value={"/navigation/data/{extensionId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public NavigationNode getNavigationData(@PathVariable(value="extensionId") String string, @RequestParam(value="objectId", required=false) String string2) throws Exception {
        Object object;
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        if (string2 != null && !this.objectExists(object = this._objRefService.getReference(string2, true))) {
            NavigationNode navigationNode = new NavigationNode();
            navigationNode.error = NavigationNode.ErrorType.OBJECT_NOT_FOUND;
            return navigationNode;
        }
        object = this._extensionService.getExtensionHosts(string);
        if (object == null || ((ExtensionInfo[][])object).length == 0) {
            _logger.warn((Object)("No navigation path found for: " + string));
            return null;
        }
        NavigationNode navigationNode = null;
        Object object2 = null;
        Object object3 = object;
        int n = ((ExtensionInfo[][])object3).length;
        for (int i = 0; i < n; ++i) {
            ExtensionInfo[] extensionInfoArray = object3[i];
            if (extensionInfoArray[0].getExtendedPointIds().length > 1) continue;
            Map<String, Object> map = ExtensionServiceUtil.getFilterContext(this._objRefService, string2);
            navigationNode = new NavigationNode();
            navigationNode.extensionObject = this._extensionService.getExtensionObject(extensionInfoArray[0], map, false);
            object2 = navigationNode;
            PathResult pathResult = this.probeExtensionPath(string2, (NavigationNode)object2, extensionInfoArray);
            if (!pathResult.isDesiredExtension) continue;
            object2 = pathResult.navigationNode;
            break;
        }
        if (object2 == null) {
            return navigationNode;
        }
        do {
            if (object2.extensionObject instanceof IUID) continue;
            _logger.warn((Object)"Can't explore the navigation path any further as extension object is not an IUID.");
            return navigationNode;
        } while ((object2 = (object3 = this.processNavigationNode((NavigationNode)object2, string2, null))) != null);
        return navigationNode;
    }

    private boolean objectExists(Object object) {
        QueryService queryService = this._queryServiceFactory.getQueryService();
        String string = this._objRefService.getResourceObjectType(object);
        ResultSet resultSet = queryService.select(new String[0]).withTotalCount().from(new String[]{string}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, object).fetch();
        return resultSet.getTotalCount() != 0;
    }

    private PathResult probeExtensionPath(String string, NavigationNode navigationNode, ExtensionInfo[] extensionInfoArray) throws Exception {
        for (int i = 0; i < extensionInfoArray.length; ++i) {
            NavigationNode navigationNode2;
            String string2 = null;
            if (i + 1 < extensionInfoArray.length) {
                string2 = extensionInfoArray[i + 1].getId();
            }
            if ((navigationNode2 = this.processNavigationNode(navigationNode, string, string2)) == null && i != extensionInfoArray.length - 1) {
                return new PathResult(false, null);
            }
            navigationNode = navigationNode2;
        }
        return new PathResult(true, navigationNode);
    }

    private NavigationNode processNavigationNode(NavigationNode navigationNode, String string, String string2) throws Exception {
        if (!(navigationNode.extensionObject instanceof IUID)) {
            _logger.warn((Object)"Cant explore the navigation path any further as extension object is not an IUID.");
            return null;
        }
        IUID iUID = (IUID)navigationNode.extensionObject;
        List<Object> list = ExtensionServiceUtil.getHostedExtensionObjectsByExtensionId(this._extensionService, iUID.getUid(), this._objRefService, string);
        NavigationNode navigationNode2 = this.processChildren(navigationNode, list, string2);
        return navigationNode2;
    }

    private NavigationNode processChildren(NavigationNode navigationNode, List<Object> list, String string) {
        NavigationNode navigationNode2 = null;
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            NavigationNode navigationNode3 = new NavigationNode();
            navigationNode3.extensionObject = object;
            navigationNode.children.add(navigationNode3);
            if (navigationNode2 != null || !(object instanceof IUID)) continue;
            IUID iUID = (IUID)object;
            if (string == null) {
                string = iUID.getUid();
            }
            if (!string.equals(iUID.getUid())) continue;
            navigationNode.childIndexToActivate = i;
            navigationNode2 = navigationNode3;
        }
        return navigationNode2;
    }

    private static class PathResult {
        public boolean isDesiredExtension;
        public NavigationNode navigationNode;

        public PathResult(boolean bl, NavigationNode navigationNode) {
            this.isDesiredExtension = bl;
            this.navigationNode = navigationNode;
        }
    }
}

