/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorManager;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorNavigationManager;
import com.vmware.vise.mvc.objectnavigator.model.CategoryNode;
import com.vmware.vise.mvc.objectnavigator.model.NavigationResponse;
import com.vmware.vise.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/navigator"})
public class ObjectNavigatorController
extends ExceptionHandler {
    private final ObjectNavigatorManager _objectNavigatorManager;
    private final ObjectNavigatorNavigationManager _objectNavigatorNavigationManager;

    @Autowired
    public ObjectNavigatorController(ObjectNavigatorManager objectNavigatorManager, ObjectNavigatorNavigationManager objectNavigatorNavigationManager) {
        this._objectNavigatorManager = objectNavigatorManager;
        this._objectNavigatorNavigationManager = objectNavigatorNavigationManager;
    }

    @RequestMapping(value={"/root"}, method={RequestMethod.GET})
    @ResponseBody
    public CategoryNode getRootElement() throws Exception {
        return this._objectNavigatorManager.getRoot();
    }

    @RequestMapping(value={"/node"}, method={RequestMethod.GET})
    @ResponseBody
    public CategoryNode getCategoryNode(@RequestParam(value="nodeId", required=false) String string) throws Exception {
        if (string == null || StringUtil.isNullOrEmpty((String)string)) {
            string = this._objectNavigatorManager.getRoot().uid;
        }
        return this._objectNavigatorManager.getCategoryNode(string);
    }

    @RequestMapping(value={"/navigate/{targetViewId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public NavigationResponse handleNavigation(@PathVariable(value="targetViewId") String string, @RequestParam(value="context", required=false) String string2, @RequestParam(value="navigator", required=false) String string3, @RequestParam(value="prevNavigator", required=false) String string4) throws Exception {
        return this._objectNavigatorNavigationManager.handleNavigationRequest(string, string2, string3, string4);
    }
}

