/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.store.OperationResult;
import com.vmware.vise.store.PersistenceException;
import com.vmware.vise.store.PersistenceService;
import com.vmware.vise.store.SearchCondition;
import com.vmware.vise.store.SearchCriteria;
import com.vmware.vise.store.UserData;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/persistence"}, method={RequestMethod.GET})
public class PersistenceServiceController
extends ExceptionHandler {
    private static final Log _logger = LogFactory.getLog(PersistenceServiceController.class);
    private final PersistenceService _persistenceService;

    @Autowired
    public PersistenceServiceController(PersistenceService persistenceService) {
        this._persistenceService = persistenceService;
    }

    @RequestMapping(value={"/metadata"})
    @ResponseBody
    public Object getMetaData(@RequestParam(value="key") String string, @RequestParam(value="value") String string2, @RequestParam(value="op") String string3, @RequestParam(value="path") String string4) throws Exception {
        String string5 = this.getValidatedPath(string4);
        SearchCondition searchCondition = this.createSearchCondition(string, string2, string3);
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.conditions = new SearchCondition[]{searchCondition};
        OperationResult operationResult = this._persistenceService.queryMetadata(string5, searchCriteria, null);
        Object object = this.getResultfromOperationResult(operationResult);
        return object;
    }

    @RequestMapping(value={"/data"})
    @ResponseBody
    public Object getData(@RequestParam(value="key") String string, @RequestParam(value="value") String string2, @RequestParam(value="op") String string3, @RequestParam(value="path") String string4) throws Exception {
        String string5 = this.getValidatedPath(string4);
        SearchCondition searchCondition = this.createSearchCondition(string, string2, string3);
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.conditions = new SearchCondition[]{searchCondition};
        OperationResult operationResult = this._persistenceService.queryUserData(string5, searchCriteria, null);
        Object object = this.getResultfromOperationResult(operationResult);
        return object;
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public Object saveData(@RequestBody UserData userData) throws Exception {
        this.validateUserData(userData);
        OperationResult operationResult = this._persistenceService.setUserData(userData, false, null);
        Object object = this.getResultfromOperationResult(operationResult);
        return object;
    }

    @RequestMapping(value={"/remove"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeData(@RequestParam(value="uid") String[] stringArray) throws Exception {
        if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            throw new IllegalArgumentException("uids cannot be empty null when removing the data.");
        }
        OperationResult[] operationResultArray = this._persistenceService.removeUserData(stringArray, null, null);
        for (int i = 0; i < operationResultArray.length; ++i) {
            this.getResultfromOperationResult(operationResultArray[i]);
        }
    }

    @RequestMapping(value={"/reset"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Object reset() throws Exception {
        OperationResult operationResult = this._persistenceService.reset();
        Object object = this.getResultfromOperationResult(operationResult);
        return object;
    }

    private SearchCondition createSearchCondition(String string, String string2, String string3) throws Exception {
        if (StringUtil.isNullOrEmpty((String)string) || StringUtil.isNullOrEmpty((String)string2) || StringUtil.isNullOrEmpty((String)string3)) {
            throw new IllegalArgumentException("SearchCondition attribute cannot have null values. Key: " + string + ", value: " + string2 + ", op: " + string3);
        }
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.key = string;
        searchCondition.value = string2;
        searchCondition.op = string3;
        return searchCondition;
    }

    private Object getResultfromOperationResult(OperationResult operationResult) throws Exception {
        if (operationResult == null) {
            throw new PersistenceException("Operation result obtained is null");
        }
        if (operationResult.error != null) {
            throw new PersistenceException("Operation result has error." + operationResult.error);
        }
        return operationResult.result;
    }

    private String getValidatedPath(String string) {
        if (StringUtil.isNullOrEmpty((String)string) || string.equals("undefined")) {
            return null;
        }
        return string;
    }

    private void validateUserData(UserData userData) {
        if (userData == null || userData.value == null) {
            throw new IllegalArgumentException("Userdata and userdata.value cannot be null.");
        }
        if (userData.metadata == null || StringUtil.isNullOrEmpty((String)userData.metadata.uid)) {
            throw new IllegalArgumentException("Userdata and userdata.value cannot be null.");
        }
    }
}

