/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.relateditems.RelatedItemsManager;
import com.vmware.vise.mvc.relateditems.model.RelatedItemSummary;
import com.vmware.vise.mvc.relateditems.model.SimpleRelatedItemResult;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/relateditems"})
public class RelatedItemsController
extends ExceptionHandler {
    private final RelatedItemsManager _relatedItemsManager;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public RelatedItemsController(RelatedItemsManager relatedItemsManager, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._relatedItemsManager = relatedItemsManager;
        this._objectReferenceService = objectReferenceService;
    }

    @RequestMapping(value={"/summary/{objectId:.*}"})
    @ResponseBody
    public RelatedItemSummary[] getRelatedItemsSummary(@PathVariable(value="objectId") String string, @RequestParam(value="relationId", required=false) String string2, @RequestParam(value="onlyFavorites", defaultValue="true") boolean bl, @RequestParam(value="fetchCount", defaultValue="true") boolean bl2) throws Exception {
        Object object = this._objectReferenceService.getReference(string, true);
        return this.getRelatedItemsFromManager(object, string2, bl, bl2);
    }

    @RequestMapping(value={"/summary"})
    @ResponseBody
    public RelatedItemSummary[] getRelatedItemsSummaryByType(@RequestParam(value="objectType", required=true) String string, @RequestParam(value="relationId", required=false) String string2, @RequestParam(value="onlyFavorites", defaultValue="true") boolean bl, @RequestParam(value="fetchCount", defaultValue="true") boolean bl2) throws Exception {
        URI uRI = DefaultUriSchemeUtil.createUri((String)string, (String)string);
        return this.getRelatedItemsFromManager(uRI, string2, bl, bl2);
    }

    @RequestMapping(value={"/list/{objectId:.*}"})
    @ResponseBody
    public RelatedItemSummary[] getRelatedItemsList(@PathVariable(value="objectId") String string, @RequestParam(value="relationsViewId", defaultValue="null") String string2, @RequestParam(value="onlyFavorites", defaultValue="false") boolean bl) throws Exception {
        Object object = this._objectReferenceService.getReference(string, true);
        return this._relatedItemsManager.getRelatedItemsSummary(object, null, bl, false, string2);
    }

    @RequestMapping(value={"/listspec/{objectType:.*}"})
    @ResponseBody
    public RelatedItemSummary[] getRelatedItemsListSpecByType(@PathVariable(value="objectType") String string, @RequestParam(value="relationsViewId", required=true) String string2, @RequestParam(value="onlyFavorites", defaultValue="false") boolean bl) throws Exception {
        URI uRI = DefaultUriSchemeUtil.createUri((String)string, (String)string);
        return this._relatedItemsManager.getRelatedItemsSummary(uRI, null, bl, false, string2);
    }

    @RequestMapping(value={"/{relationId}/{objectId:.*}"})
    @ResponseBody
    public List<Map<String, Object>> getRelatedItemsByRelationId(@PathVariable(value="relationId") String string, @PathVariable(value="objectId") String string2, @RequestParam(value="defaultProperties", defaultValue="false") boolean bl) throws Exception {
        Object object = this._objectReferenceService.getReference(string2, true);
        return this.getRelatedItemsByRelationIdFromManager(object, string, bl);
    }

    @RequestMapping(value={"/{relationId}"})
    @ResponseBody
    public List<Map<String, Object>> getRelatedItemsByRelationIdAndType(@PathVariable(value="relationId") String string, @RequestParam(value="objectType", required=true) String string2, @RequestParam(value="defaultProperties", defaultValue="false") boolean bl) throws Exception {
        URI uRI = DefaultUriSchemeUtil.createUri((String)string2, (String)string2);
        return this.getRelatedItemsByRelationIdFromManager(uRI, string, bl);
    }

    @RequestMapping(value={"/simple/{objectId:.*}"})
    @ResponseBody
    public List<SimpleRelatedItemResult> getSimpleRelatedItems(@PathVariable(value="objectId") String string) throws Exception {
        Object object = this._objectReferenceService.getReference(string, true);
        return this._relatedItemsManager.getSimpleRelatedItems(object);
    }

    @RequestMapping(value={"/relateditem/{objectId}"})
    @ResponseBody
    public RelatedItemSummary getRelatedItemSummary(@PathVariable(value="objectId") String string, @RequestParam(value="listViewId", required=true) String string2, @RequestParam(value="targetType", required=true) String string3) throws Exception {
        Object object = this._objectReferenceService.getReference(string, true);
        return this._relatedItemsManager.getRelatedItemSummary(object, string2, string3);
    }

    private List<Map<String, Object>> getRelatedItemsByRelationIdFromManager(Object object, String string, boolean bl) {
        if (bl) {
            return this._relatedItemsManager.getRelatedItems(object, string, RelatedItemsManager.DEFAULT_PROPERTIES);
        }
        return this._relatedItemsManager.getRelatedItems(object, string, null);
    }

    private RelatedItemSummary[] getRelatedItemsFromManager(Object object, String string, boolean bl, boolean bl2) throws Exception {
        return this._relatedItemsManager.getRelatedItemsSummary(object, string, bl, bl2, null);
    }
}

