/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.search.SearchManager;
import com.vmware.vise.mvc.search.model.QuickSearchResult;
import com.vmware.vise.mvc.search.model.SearchTypeData;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/search"}, method={RequestMethod.GET})
public class SearchController
extends ExceptionHandler {
    private static final Log _logger = LogFactory.getLog(SearchController.class);
    private final SearchManager _searchManager;

    @Autowired
    public SearchController(SearchManager searchManager) {
        this._searchManager = searchManager;
    }

    @RequestMapping(value={"/quicksearch"})
    @ResponseBody
    public List<QuickSearchResult> getQuickSearchResults(@RequestParam(value="query") String string) throws Exception {
        string = string.trim();
        List<QuickSearchResult> list = this._searchManager.getQuickSearchResults(string);
        return list;
    }

    @RequestMapping(value={"/simplesearch/summary"})
    @ResponseBody
    public List<SearchTypeData> getSimpleSearchTypeSummary(@RequestParam(value="query") String string) throws Exception {
        string = string.trim();
        List<SearchTypeData> list = this._searchManager.getSimpleSearchTypes(string);
        return list;
    }
}

