/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.mvc.tree.TreeManager;
import com.vmware.vise.mvc.tree.TreeNodeItem;
import com.vmware.vise.mvc.tree.TreePath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tree"})
public class TreeController
extends ExceptionHandler {
    private static final Log _logger = LogFactory.getLog(TreeController.class);
    private final TreeManager _treeManager;

    @Autowired
    public TreeController(TreeManager treeManager) {
        this._treeManager = treeManager;
    }

    @ResponseBody
    @RequestMapping(value={"/root"})
    public List<TreeNodeItem> getRoot(@RequestParam(value="treeId") String string, @RequestParam(value="objRef", required=false) String string2) {
        return this._treeManager.getRoot(string, string2);
    }

    @RequestMapping(value={"/children"})
    @ResponseBody
    public List<TreeNodeItem> getChildren(@RequestParam(value="treeId") String string, @RequestParam(value="nodeTypeId") String string2, @RequestParam(value="objRef") String string3) {
        return this._treeManager.getChildren(string, string2, string3);
    }

    @RequestMapping(value={"/path"})
    @ResponseBody
    public TreePath getPath(@RequestParam(value="treeId") String string, @RequestParam(value="rootRef", required=false) String string2, @RequestParam(value="objRef") String string3, @RequestParam(value="options", required=false) String string4) {
        return this._treeManager.getPath(string, string2, string3, string4);
    }

    @RequestMapping(value={"/propertiesByObjectIds"}, method={RequestMethod.POST})
    public Map<String, Map<String, Object>> getPropertiesByObjectIds(@RequestBody Map<String, ArrayList<String>> map) throws Exception {
        List list = map.get("objectIds");
        if (list == null) {
            throw new IllegalArgumentException("ObjectIds are required.");
        }
        return this._treeManager.getPropertiesByObjectIds(list);
    }

    @RequestMapping(value={"/supportedTypes"})
    @ResponseBody
    public List<String> getSupportedTypes(@RequestParam(value="treeId") String string) {
        return this._treeManager.getSupportedTypes(string);
    }
}

