/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.controllers.ExceptionHandler;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.util.service.ServiceRegistry;
import com.vmware.vsphere.client.security.util.Util;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/usersession"}, method={RequestMethod.GET})
public class UserSessionController
extends ExceptionHandler {
    private final AtomicReference<UserSessionService> _userSessionServiceRef = new AtomicReference();
    private final ServiceRegistry _serviceRegistry;
    private static final Log _logger = LogFactory.getLog(UserSessionController.class);

    @Autowired
    public UserSessionController(ServiceRegistry serviceRegistry) {
        this._serviceRegistry = serviceRegistry;
    }

    @RequestMapping
    @ResponseBody
    public UserSession getUserSession() {
        UserSessionService userSessionService = this.getUserSessionService();
        if (userSessionService == null) {
            return Util.getUserSession();
        }
        return this.getUserSessionService().getUserSession();
    }

    @RequestMapping(value={"/ping"})
    @ResponseBody
    public void ping() {
        UserSessionService userSessionService = this.getUserSessionService();
        if (userSessionService != null) {
            userSessionService.ping();
        } else {
            _logger.warn((Object)"No-op on ping operation, since userSessionService is un-available.");
        }
    }

    @RequestMapping(value={"/checkUserSession"}, produces={"application/javascript"}, method={RequestMethod.GET})
    @ResponseBody
    public String checkUserSession(@RequestParam(value="callback") String string, HttpServletResponse httpServletResponse) {
        UserSession userSession;
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        if (string != null) {
            string = string.replaceAll("(?:\\r\\n|\\n\\r|\\n|\\r)", "");
        }
        boolean bl = (userSession = this.getUserSession()) != null;
        return "\n" + string + "(" + bl + ")";
    }

    private UserSessionService getUserSessionService() {
        UserSessionService userSessionService = this._userSessionServiceRef.get();
        if (userSessionService == null) {
            UserSessionService userSessionService2 = null;
            try {
                userSessionService2 = (UserSessionService)this._serviceRegistry.getService(UserSessionService.class.getName());
            }
            catch (Exception exception) {
                _logger.error((Object)("Error when getting service of UserSessionService interface" + exception.getMessage()));
                return null;
            }
            boolean bl = this._userSessionServiceRef.compareAndSet(null, userSessionService2);
            if (bl) {
                return userSessionService2;
            }
            userSessionService = this._userSessionServiceRef.get();
        }
        return userSessionService;
    }
}

