/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.events;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.events.LinkableEntityParser;
import com.vmware.vise.mvc.events.model.EventCause;
import com.vmware.vise.mvc.events.model.EventListItemData;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import com.vmware.vise.util.DocumentBuilderFactorySource;
import com.vmware.vise.util.StringUtil;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EventFormatter {
    private ObjectReferenceService _objectReferenceService;
    private ObjectTypesManager _objectTypesManager;
    private DocumentBuilderFactory dbFactory = DocumentBuilderFactorySource.INSTANCE.createDocumentBuilderFactory();
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("M/d/yyyy h:mm:ss a");
    private static final Log _logger = LogFactory.getLog(EventFormatter.class);

    public EventFormatter(ObjectReferenceService objectReferenceService, ObjectTypesManager objectTypesManager) {
        this._objectReferenceService = objectReferenceService;
        this._objectTypesManager = objectTypesManager;
    }

    private void parseLongDescription(EventListItemData eventListItemData, ClientEventInfo clientEventInfo) {
        if (StringUtil.isNullOrEmpty((String)clientEventInfo.longDescription)) {
            return;
        }
        try {
            DocumentBuilder documentBuilder = this.dbFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(clientEventInfo.longDescription));
            Document document = documentBuilder.parse(inputSource);
            NodeList nodeList = document.getElementsByTagName("description");
            for (int i = 0; i < nodeList.getLength() && i < 1; ++i) {
                eventListItemData.longDescription = nodeList.item(i).getTextContent();
            }
            NodeList nodeList2 = document.getElementsByTagName("cause");
            EventCause[] eventCauseArray = new EventCause[nodeList2.getLength()];
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                NodeList nodeList3 = nodeList2.item(i).getChildNodes();
                eventCauseArray[i] = new EventCause();
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    String string = nodeList3.item(j).getNodeName();
                    String string2 = nodeList3.item(j).getTextContent();
                    if (string.equals("description")) {
                        eventCauseArray[i].description = string2;
                        continue;
                    }
                    if (!string.equals("action")) continue;
                    eventCauseArray[i].action = string2;
                }
            }
            eventListItemData.causes = eventCauseArray;
        }
        catch (SAXException sAXException) {
        }
        catch (Exception exception) {
            _logger.warn((Object)("Failed to deserialize event long description XML for eventTypeId: " + clientEventInfo.eventTypeId));
        }
    }

    public void setEventListItemData(EventListItemData eventListItemData, ClientEventInfo clientEventInfo) {
        LinkableEntityParser linkableEntityParser = new LinkableEntityParser();
        eventListItemData.associatedEntities = clientEventInfo.associatedEntities;
        eventListItemData.linkableEntities = linkableEntityParser.getLinkableEntities(clientEventInfo);
        eventListItemData.linkableFormattedMessage = clientEventInfo.linkableFormattedMessage;
        eventListItemData.fullFormattedMessage = clientEventInfo.fullFormattedMessage;
        eventListItemData.categoryKey = clientEventInfo.categoryKey;
        eventListItemData.categoryName = clientEventInfo.categoryName;
        eventListItemData.createdTime = clientEventInfo.createdTime.getTime();
        eventListItemData.createdTimeText = this.dateFormatter.format(clientEventInfo.createdTime);
        eventListItemData.userName = clientEventInfo.userName;
        eventListItemData.nativeEventType = clientEventInfo.eventTypeId;
        eventListItemData.serverGuid = clientEventInfo.serverGuid;
        eventListItemData.key = clientEventInfo.key;
        eventListItemData.chainId = clientEventInfo.chainId;
        this.parseLongDescription(eventListItemData, clientEventInfo);
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)clientEventInfo.targetEntityMor;
        if (managedObjectReference != null) {
            eventListItemData.targetEntityId = this._objectReferenceService.getUid((Object)managedObjectReference);
            eventListItemData.targetEntityName = clientEventInfo.targetEntityName;
            eventListItemData.labelIds = clientEventInfo.labelIds;
            ObjectTypeSpec objectTypeSpec = this._objectTypesManager.getObjectTypeSpec(managedObjectReference.getType());
            if (objectTypeSpec != null) {
                eventListItemData.targetIcon = objectTypeSpec.icon;
            } else {
                _logger.warn((Object)("No ObjectTypeSpec registered for: " + managedObjectReference.getType()));
            }
        }
    }
}

