/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.FeatureUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FeatureStateFilter
implements ExtensionObjectFilter {
    private static final Log _logger = LogFactory.getLog(FeatureStateFilter.class);
    private static final String FEATURE_METADATA_TAG = "feature";
    private final PropertyInfo[] _filterProperties;
    private final FeatureStateService _featureStateService;

    @Autowired
    public FeatureStateFilter(FeatureStateService featureStateService) {
        this._featureStateService = featureStateService;
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = FEATURE_METADATA_TAG;
        propertyInfo.type = String.class.getName();
        propertyInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{propertyInfo};
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : list) {
            String string = (String)extensionInfo.getMetadata().get(FEATURE_METADATA_TAG);
            boolean bl = FeatureUtil.evaluateFeatureExpression((FeatureStateService)this._featureStateService, (String)string);
            if (!bl) {
                arrayList.add(extensionInfo);
                continue;
            }
            _logger.info((Object)(extensionInfo.getId() + " has been filtered out. " + "Either feature is disabled or feature does not exist. Feature Expression: " + string));
        }
        return arrayList;
    }
}

