/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.util.PropertyConstraintCompUtil;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ObjectPropertyFilter
implements ExtensionObjectFilter {
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;
    private final QueryService _queryService;
    private final ObjectReferenceService _objRefService;
    private static final Log _logger = LogFactory.getLog(ObjectPropertyFilter.class);
    private static final String PROPERTY_CONDITIONS = "propertyConditions";
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final String TYPE = "/@type";

    @Autowired
    public ObjectPropertyFilter(QueryServiceFactory queryServiceFactory, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._objRefService = objectReferenceService;
        this._queryService = queryServiceFactory.getQueryService();
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = PROPERTY_CONDITIONS;
        propertyInfo.type = CompositeConstraint.class.getName();
        propertyInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{propertyInfo};
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = CONTEXT_OBJECTS;
        propertyInfo2.type = Object[].class.getName();
        propertyInfo2.optional = false;
        this._contextProperties = new PropertyInfo[]{propertyInfo2};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        if (map == null) {
            return list;
        }
        Object[] objectArray = this.getContextObjects(map);
        if (objectArray.length == 0 || objectArray[0] == null) {
            return list;
        }
        Set<String> set = this.getProperties(list);
        if (set.size() == 0) {
            return list;
        }
        set.add("@modelKey");
        String[] stringArray = this.extractPropertiesToFetch(objectArray, set);
        if (stringArray.length == 0) {
            return list;
        }
        String string = this._objRefService.getResourceObjectType(objectArray[0]);
        List<ExtensionInfo> list2 = null;
        try {
            ResultSet resultSet = this._queryService.select(stringArray).from(new String[]{string}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(objectArray)).fetch();
            Collection<ObjectRefPropertyValueHolder> collection = this.createObjectPropertyValueList(resultSet, objectArray);
            list2 = this.applyObjectData(list, collection);
        }
        catch (Exception exception) {
            list2 = list;
            _logger.error((Object)"Error when doing filter based on object properties ", (Throwable)exception);
        }
        return list2;
    }

    private Object[] getContextObjects(Map<String, Object> map) {
        Object object = map.get(CONTEXT_OBJECTS);
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        return objectArray;
    }

    private Set<String> getProperties(List<ExtensionInfo> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ExtensionInfo extensionInfo : list) {
            List<PropertyConstraint> list2 = this.extractPropertyConstraints(extensionInfo);
            if (list2 == null) {
                _logger.error((Object)("Invalid metadata for extension info:" + extensionInfo.getId()));
                continue;
            }
            hashSet.addAll(this.extractPropertyNames(list2));
        }
        return hashSet;
    }

    private Collection<ObjectRefPropertyValueHolder> createObjectPropertyValueList(ResultSet resultSet, Object[] objectArray) {
        ArrayList<ObjectRefPropertyValueHolder> arrayList = new ArrayList<ObjectRefPropertyValueHolder>();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object object = resourceItem.getKey();
            ObjectRefPropertyValueHolder objectRefPropertyValueHolder = new ObjectRefPropertyValueHolder(object);
            arrayList.add(objectRefPropertyValueHolder);
            for (String string : resultSet.getProperties()) {
                objectRefPropertyValueHolder.addPropertyValue(string, resourceItem.get(string));
            }
        }
        return arrayList;
    }

    private Set<String> extractPropertyNames(List<PropertyConstraint> list) {
        if (list == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(list.size());
        for (PropertyConstraint propertyConstraint : list) {
            String string = propertyConstraint.propertyName;
            if (StringUtil.isNullOrEmpty((String)string)) continue;
            int n = string.indexOf(TYPE);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    private List<PropertyConstraint> extractPropertyConstraints(ExtensionInfo extensionInfo) {
        ArrayList<PropertyConstraint> arrayList = null;
        CompositeConstraint compositeConstraint = this.extractCompositeConstraint(extensionInfo);
        if (compositeConstraint == null || compositeConstraint.nestedConstraints == null) {
            return arrayList;
        }
        arrayList = new ArrayList<PropertyConstraint>(compositeConstraint.nestedConstraints.length);
        for (Constraint constraint : compositeConstraint.nestedConstraints) {
            if (!(constraint instanceof PropertyConstraint)) continue;
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            if (StringUtil.isNullOrEmpty((String)propertyConstraint.propertyName)) continue;
            arrayList.add(propertyConstraint);
        }
        return arrayList;
    }

    private CompositeConstraint extractCompositeConstraint(ExtensionInfo extensionInfo) {
        if (extensionInfo.getMetadata() == null) {
            return null;
        }
        return (CompositeConstraint)extensionInfo.getMetadata().get(PROPERTY_CONDITIONS);
    }

    private Conjoiner extractComparisonConjoiner(ExtensionInfo extensionInfo) {
        CompositeConstraint compositeConstraint = this.extractCompositeConstraint(extensionInfo);
        if (compositeConstraint == null || compositeConstraint.conjoiner == null) {
            return Conjoiner.AND;
        }
        return compositeConstraint.conjoiner;
    }

    private String[] extractPropertiesToFetch(Object[] objectArray, Set<String> set) {
        String[] stringArray = new String[]{};
        Object object = objectArray[0];
        if (object == null) {
            return stringArray;
        }
        stringArray = new String[set.size()];
        int n = 0;
        for (String string : set) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    private List<ExtensionInfo> applyObjectData(List<ExtensionInfo> list, Collection<ObjectRefPropertyValueHolder> collection) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : list) {
            Conjoiner conjoiner;
            List<PropertyConstraint> list2 = this.extractPropertyConstraints(extensionInfo);
            boolean bl = this.computeComparisonsForObjects(collection, list2, conjoiner = this.extractComparisonConjoiner(extensionInfo));
            if (!bl) continue;
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }

    private boolean computeANDedComparisons(ObjectRefPropertyValueHolder objectRefPropertyValueHolder, List<PropertyConstraint> list) {
        boolean bl = true;
        for (PropertyConstraint propertyConstraint : list) {
            if (bl &= this.computeComparisonForObject(objectRefPropertyValueHolder, propertyConstraint)) continue;
            return false;
        }
        return true;
    }

    private boolean computeORedComparisons(ObjectRefPropertyValueHolder objectRefPropertyValueHolder, List<PropertyConstraint> list) {
        boolean bl = false;
        for (PropertyConstraint propertyConstraint : list) {
            if (!(bl |= this.computeComparisonForObject(objectRefPropertyValueHolder, propertyConstraint))) continue;
            return true;
        }
        return false;
    }

    private boolean computeComparisonsForObjects(Collection<ObjectRefPropertyValueHolder> collection, List<PropertyConstraint> list, Conjoiner conjoiner) {
        for (ObjectRefPropertyValueHolder objectRefPropertyValueHolder : collection) {
            boolean bl = this.computeComparisonsForObject(objectRefPropertyValueHolder, list, conjoiner);
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean computeComparisonsForObject(ObjectRefPropertyValueHolder objectRefPropertyValueHolder, List<PropertyConstraint> list, Conjoiner conjoiner) {
        if (conjoiner == Conjoiner.AND) {
            return this.computeANDedComparisons(objectRefPropertyValueHolder, list);
        }
        if (conjoiner == Conjoiner.OR) {
            return this.computeORedComparisons(objectRefPropertyValueHolder, list);
        }
        return false;
    }

    private boolean computeComparisonForObject(ObjectRefPropertyValueHolder objectRefPropertyValueHolder, PropertyConstraint propertyConstraint) {
        String string = propertyConstraint.propertyName;
        if (StringUtil.isNullOrEmpty((String)string)) {
            return false;
        }
        Object object = this.extractPropertyValue(objectRefPropertyValueHolder, string);
        return PropertyConstraintCompUtil.matchValues((Object)object, (Object)propertyConstraint.comparableValue, (Comparator)propertyConstraint.comparator);
    }

    private Object extractPropertyValue(ObjectRefPropertyValueHolder objectRefPropertyValueHolder, String string) {
        Object object = objectRefPropertyValueHolder.getSourceObject();
        Object object2 = null;
        if (object == null) {
            return object2;
        }
        Map map = objectRefPropertyValueHolder.getPropertyValueMap();
        if (map == null) {
            return object2;
        }
        int n = string.indexOf(TYPE);
        if (n >= 0) {
            Object v = map.get(string = string.substring(0, n));
            if (v != null) {
                object2 = this._objRefService.getResourceObjectType(v);
            }
        } else {
            Object object3 = object2 = map.get(string) != null ? (Object)map.get(string) : null;
        }
        if (object2 != null && object2.getClass().isEnum()) {
            object2 = ((Enum)object2).name();
        }
        return object2;
    }

    private static class ObjectRefPropertyValueHolder {
        final Object _sourceObject;
        Map<String, Object> _propertyValueMap;

        private ObjectRefPropertyValueHolder(Object object) {
            this._sourceObject = object;
        }

        private Object getSourceObject() {
            return this._sourceObject;
        }

        private Map<String, Object> getPropertyValueMap() {
            return this._propertyValueMap;
        }

        private void addPropertyValue(String string, Object object) {
            if (this._propertyValueMap == null) {
                this._propertyValueMap = new HashMap<String, Object>();
            }
            this._propertyValueMap.put(string, object);
        }
    }
}

