/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.mvc.relateditems.RelatedItemsManager;
import com.vmware.vise.mvc.relateditems.model.RelatedItemSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RelatedItemsExtensionFilter
implements ExtensionObjectFilter {
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final String RELATED_OBJECTS_VIEWID_SUFFIX = "related";
    private final PropertyInfo[] _contextProperties;
    private final RelatedItemsManager _relatedItemsManager;
    private static final Log _logger = LogFactory.getLog(RelatedItemsExtensionFilter.class);

    public RelatedItemsExtensionFilter(RelatedItemsManager relatedItemsManager) {
        this._relatedItemsManager = relatedItemsManager;
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = CONTEXT_OBJECTS;
        propertyInfo.type = Object[].class.getName();
        propertyInfo.optional = false;
        this._contextProperties = new PropertyInfo[]{propertyInfo};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return null;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        Object[] objectArray = this.getContextObjects(map);
        if (objectArray.length != 1) {
            return list;
        }
        Object object = objectArray[0];
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : list) {
            if (!extensionInfo.getId().endsWith(RELATED_OBJECTS_VIEWID_SUFFIX)) {
                arrayList.add(extensionInfo);
                continue;
            }
            try {
                RelatedItemSummary[] relatedItemSummaryArray = this._relatedItemsManager.getRelatedItemsSummary(object, null, false, false, extensionInfo.getId());
                if (relatedItemSummaryArray.length <= 0) continue;
                arrayList.add(extensionInfo);
            }
            catch (Exception exception) {
                _logger.error((Object)("Error while retrieving RelationSpecs for viewId: " + extensionInfo.getId()), (Throwable)exception);
            }
        }
        return arrayList;
    }

    private Object[] getContextObjects(Map<String, Object> map) {
        Object object = map.get(CONTEXT_OBJECTS);
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        return objectArray;
    }
}

