/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.objectnavigator;

import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorManager;
import com.vmware.vise.mvc.objectnavigator.model.CategoryNode;
import com.vmware.vise.mvc.objectnavigator.model.ObjectNavigatorNodeSpec;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class ObjectNavigatorManagerImpl
implements ObjectNavigatorManager,
ExtensionListener {
    private static final Log _logger = LogFactory.getLog(ObjectNavigatorManagerImpl.class);
    private final ExtensionService _extensionService;
    private static final String OBJECT_NAVIGATOR_EXT_POINT = "vise.navigator.nodespecs";
    private static final int MAX_LEVELS = 2;
    @GuardedBy(value="_readWriteLock")
    private ObjectNavigatorNodeSpec _rootNode = null;
    @GuardedBy(value="_readWriteLock")
    private final Map<String, ObjectNavigatorNodeSpec> _nodeSpecById;
    @GuardedBy(value="_readWriteLock")
    private final Map<String, List<ObjectNavigatorNodeSpec>> _childrenNodeSpecsByParentId;
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._readWriteLock.readLock();
    private final Lock _writeLock = this._readWriteLock.writeLock();

    @Autowired
    public ObjectNavigatorManagerImpl(ExtensionService extensionService) throws Exception {
        this._extensionService = extensionService;
        this._nodeSpecById = new HashMap<String, ObjectNavigatorNodeSpec>();
        this._childrenNodeSpecsByParentId = new HashMap<String, List<ObjectNavigatorNodeSpec>>();
        if (this._extensionService.getExtensionPointInfo(OBJECT_NAVIGATOR_EXT_POINT) != null) {
            this.loadNodeSpecs();
        }
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        this.loadNodeSpecs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CategoryNode getCategoryNode(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.warn((Object)"getCategoryNode(): nodeId is empty");
            return null;
        }
        try {
            this._readLock.lock();
            ObjectNavigatorNodeSpec objectNavigatorNodeSpec = this._nodeSpecById.get(string);
            if (objectNavigatorNodeSpec == null) {
                _logger.warn((Object)("getCategoryNode(): ObjectNavigatorSpec not found for nodeId=" + string));
                CategoryNode categoryNode = null;
                return categoryNode;
            }
            CategoryNode categoryNode = this.transformObjectSpecsToCategoryNode(objectNavigatorNodeSpec);
            this.populateCategoryNode(categoryNode);
            CategoryNode categoryNode2 = categoryNode;
            return categoryNode2;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CategoryNode getRoot() {
        try {
            this._readLock.lock();
            CategoryNode categoryNode = this.transformObjectSpecsToCategoryNode(this._rootNode);
            return categoryNode;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectNavigatorNodeSpec getNodeByNavigationTargetUid(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.warn((Object)"getNodeByNavigationTargetUid(): navigationTargetUid is null");
            return null;
        }
        try {
            this._readLock.lock();
            for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : this._nodeSpecById.values()) {
                if (!string.equals(objectNavigatorNodeSpec.navigationTargetUid)) continue;
                ObjectNavigatorNodeSpec objectNavigatorNodeSpec2 = objectNavigatorNodeSpec;
                return objectNavigatorNodeSpec2;
            }
            Iterator<ObjectNavigatorNodeSpec> iterator = null;
            return iterator;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectNavigatorNodeSpec getClosestAncestorNodeThatCanBeFocused(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.warn((Object)"getClosestAncestorNodeThatCanBeFocused(): id is not set");
            return null;
        }
        try {
            this._readLock.lock();
            ObjectNavigatorNodeSpec objectNavigatorNodeSpec = this._nodeSpecById.get(string);
            if (objectNavigatorNodeSpec != null && objectNavigatorNodeSpec.isFocusable.booleanValue()) {
                ObjectNavigatorNodeSpec objectNavigatorNodeSpec2 = objectNavigatorNodeSpec;
                return objectNavigatorNodeSpec2;
            }
            if (objectNavigatorNodeSpec == null) {
                ObjectNavigatorNodeSpec objectNavigatorNodeSpec3 = null;
                return objectNavigatorNodeSpec3;
            }
            ObjectNavigatorNodeSpec objectNavigatorNodeSpec4 = this._nodeSpecById.get(objectNavigatorNodeSpec.parentUid);
            while (objectNavigatorNodeSpec4 != null) {
                if (objectNavigatorNodeSpec4.isFocusable.booleanValue()) {
                    ObjectNavigatorNodeSpec objectNavigatorNodeSpec5 = objectNavigatorNodeSpec4;
                    return objectNavigatorNodeSpec5;
                }
                objectNavigatorNodeSpec4 = this._nodeSpecById.get(objectNavigatorNodeSpec4.parentUid);
            }
            ObjectNavigatorNodeSpec objectNavigatorNodeSpec6 = null;
            return objectNavigatorNodeSpec6;
        }
        finally {
            this._readLock.unlock();
        }
    }

    private void populateCategoryNode(CategoryNode categoryNode) {
        ArrayList<CategoryNode> arrayList = new ArrayList<CategoryNode>();
        arrayList.add(categoryNode);
        int n = 2;
        for (int i = 0; i != n; ++i) {
            ArrayList<CategoryNode> arrayList2 = new ArrayList<CategoryNode>();
            for (CategoryNode categoryNode2 : arrayList) {
                this.retrieveAndAddChildren(categoryNode2, arrayList2);
            }
            arrayList = arrayList2;
        }
    }

    private void retrieveAndAddChildren(CategoryNode categoryNode, List<CategoryNode> list) {
        List<ObjectNavigatorNodeSpec> list2 = this._childrenNodeSpecsByParentId.get(categoryNode.uid);
        if (list2 == null || list2.size() == 0) {
            return;
        }
        if (categoryNode.children == null) {
            categoryNode.children = new ArrayList<CategoryNode>();
        }
        for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list2) {
            CategoryNode categoryNode2 = this.transformObjectSpecsToCategoryNode(objectNavigatorNodeSpec);
            categoryNode.children.add(categoryNode2);
            list.add(categoryNode2);
        }
    }

    private CategoryNode transformObjectSpecsToCategoryNode(ObjectNavigatorNodeSpec objectNavigatorNodeSpec) {
        CategoryNode categoryNode = null;
        if (objectNavigatorNodeSpec != null) {
            categoryNode = new CategoryNode(objectNavigatorNodeSpec.getUid());
            categoryNode.title = objectNavigatorNodeSpec.title;
            categoryNode.icon = objectNavigatorNodeSpec.icon;
            categoryNode.viewOpenedUponFocus = objectNavigatorNodeSpec.getViewOpenedUponFocus();
            if (categoryNode.viewOpenedUponFocus != null) {
                categoryNode.viewOpenedUponFocus.setUid(objectNavigatorNodeSpec.getUid());
            }
            categoryNode.navigationTargetUid = objectNavigatorNodeSpec.navigationTargetUid;
            categoryNode.nodeObjectType = objectNavigatorNodeSpec.nodeObjectType;
        }
        return categoryNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNodeSpecs() {
        try {
            this._writeLock.lock();
            this._nodeSpecById.clear();
            this._childrenNodeSpecsByParentId.clear();
            this._rootNode = null;
            List list = this._extensionService.getExtensionObjects(OBJECT_NAVIGATOR_EXT_POINT, new HashMap(), false);
            for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list) {
                this._nodeSpecById.put(objectNavigatorNodeSpec.getUid(), objectNavigatorNodeSpec);
                String string = objectNavigatorNodeSpec.parentUid;
                if (string == null) {
                    this._rootNode = objectNavigatorNodeSpec;
                    continue;
                }
                List<ObjectNavigatorNodeSpec> list2 = this._childrenNodeSpecsByParentId.get(string);
                if (list2 == null) {
                    list2 = new ArrayList<ObjectNavigatorNodeSpec>();
                    this._childrenNodeSpecsByParentId.put(string, list2);
                }
                list2.add(objectNavigatorNodeSpec);
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }
}

