/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.search;

import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.metadata.MetadataService;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.mvc.model.ComponentSpec;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.model.ResourceObject;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import com.vmware.vise.mvc.search.SearchManager;
import com.vmware.vise.mvc.search.formatter.ISearchableTypeFormatter;
import com.vmware.vise.mvc.search.model.QuickSearchResult;
import com.vmware.vise.mvc.search.model.SearchTypeData;
import com.vmware.vise.mvc.search.util.QuickSearchConstraintBuilder;
import com.vmware.vise.mvc.search.util.SearchConstraintBuilder;
import com.vmware.vise.mvc.search.util.SearchUtil;
import com.vmware.vise.mvc.search.util.SimpleSearchConstraintBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class SearchManagerImpl
implements ExtensionListener,
SearchManager {
    private static final Log _logger = LogFactory.getLog(SearchManager.class);
    private final ObjectReferenceService _objRefService;
    private final DataService _dataService;
    private final MetadataService _metadataService;
    private final ObjectTypesManager _objectTypesManager;
    private final ExtensionService _extensionService;
    private final HashMap<String, ISearchableTypeFormatter> _typeFormatters;
    private Map<String, List<String>> _searchableProperties;
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._readWriteLock.readLock();
    private final Lock _writeLock = this._readWriteLock.writeLock();

    @Autowired
    public SearchManagerImpl(@Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, DataService dataService, MetadataService metadataService, ObjectTypesManager objectTypesManager, ExtensionService extensionService) {
        this._objRefService = objectReferenceService;
        this._dataService = dataService;
        this._metadataService = metadataService;
        this._objectTypesManager = objectTypesManager;
        this._extensionService = extensionService;
        this._searchableProperties = new HashMap<String, List<String>>();
        this._typeFormatters = new HashMap();
        this.loadSearchableProperties();
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        this.loadSearchableProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QuickSearchResult> getQuickSearchResults(String string) throws Exception {
        try {
            this._readLock.lock();
            ArrayList<String> arrayList = new ArrayList<String>(this._searchableProperties.keySet());
            QuickSearchConstraintBuilder quickSearchConstraintBuilder = new QuickSearchConstraintBuilder(string, arrayList, this._typeFormatters);
            QuerySpec querySpec = this.buildQuerySpec(quickSearchConstraintBuilder);
            ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
            if (resultSet.items == null) {
                List<QuickSearchResult> list = null;
                return list;
            }
            List<QuickSearchResult> list = this.formatQuickSearchResults(resultSet);
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SearchTypeData> getSimpleSearchTypes(String string) throws Exception {
        try {
            List<SearchTypeData> list;
            this._readLock.lock();
            SimpleSearchConstraintBuilder simpleSearchConstraintBuilder = new SimpleSearchConstraintBuilder(string, this._searchableProperties);
            QuerySpec querySpec = this.buildQuerySpec(simpleSearchConstraintBuilder);
            ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
            List<SearchTypeData> list2 = list = this.formatSimpleSearchResults(resultSet);
            return list2;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSearchableTypeFormatter(ISearchableTypeFormatter iSearchableTypeFormatter) {
        try {
            this._writeLock.lock();
            if (iSearchableTypeFormatter == null || iSearchableTypeFormatter.getObjectType() == null) {
                throw new IllegalArgumentException("Invalid ISearchableTypeFormatter.");
            }
            this._typeFormatters.put(iSearchableTypeFormatter.getObjectType(), iSearchableTypeFormatter);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    private QuerySpec buildQuerySpec(SearchConstraintBuilder searchConstraintBuilder) {
        QuerySpec querySpec = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = searchConstraintBuilder.getConstraint();
        resourceSpec.propertySpecs = searchConstraintBuilder.getPropertySpecs();
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = searchConstraintBuilder.getMaxResultsCount();
        resultSpec.facets = searchConstraintBuilder.getFacets();
        querySpec.resourceSpec = resourceSpec;
        querySpec.resultSpec = resultSpec;
        return querySpec;
    }

    private List<QuickSearchResult> formatQuickSearchResults(ResultSet resultSet) {
        Object object;
        Object object2;
        Object object3;
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<QuickSearchResult> arrayList = new ArrayList<QuickSearchResult>();
        for (Object object4 : resultSet.items) {
            if (object4.properties.length == 0 || this._objectTypesManager.getObjectTypeSpec(string = this._objRefService.getResourceObjectType(object4.resourceObject)) == null) continue;
            object3 = new ResourceObject();
            object2 = this._typeFormatters.get(string);
            if (object2 != null) {
                ((ResourceObject)object3).name = object2.getName((ResultItem)object4);
                ((ResourceObject)object3).type = object2.getRuntimeType((ResultItem)object4);
                ((ResourceObject)object3).id = this._objRefService.getUid(object2.getNavigationEntity((ResultItem)object4));
            } else {
                ((ResourceObject)object3).name = (String)object4.properties[0].value;
                ((ResourceObject)object3).type = string;
                ((ResourceObject)object3).id = this._objRefService.getUid(object4.resourceObject);
            }
            object = hashMap.containsKey(((ResourceObject)object3).type) ? (List)hashMap.get(((ResourceObject)object3).type) : new ArrayList();
            object.add(object3);
            hashMap.put(((ResourceObject)object3).type, object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object4;
            String string2 = (String)entry.getKey();
            object4 = "";
            string = string2;
            object3 = string2;
            object2 = this._objectTypesManager.getObjectTypeSpec(string2);
            if (object2 != null) {
                string = ((ObjectTypeSpec)object2).labelPlural;
                object3 = ((ObjectTypeSpec)object2).label;
                object4 = ((ObjectTypeSpec)object2).icon;
            }
            object = new QuickSearchResult();
            ((QuickSearchResult)object).icon = object4;
            ((QuickSearchResult)object).labelPlural = string;
            ((QuickSearchResult)object).label = object3;
            ((QuickSearchResult)object).results = (List)entry.getValue();
            arrayList.add((QuickSearchResult)object);
        }
        return arrayList;
    }

    private List<SearchTypeData> formatSimpleSearchResults(ResultSet resultSet) throws Exception {
        String string;
        Object object;
        ArrayList<SearchTypeData> arrayList = new ArrayList<SearchTypeData>();
        if (resultSet == null || resultSet.items == null) {
            return arrayList;
        }
        HashMap hashMap = new HashMap();
        for (Object object2 : resultSet.items) {
            object = object2.resourceObject;
            if (object == null) continue;
            string = this._objRefService.getResourceObjectType(object);
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new HashSet());
            }
            ((Set)hashMap.get(string)).add(this._objRefService.getUid(object, true));
        }
        for (String string2 : hashMap.keySet()) {
            Object object2;
            ObjectTypeSpec objectTypeSpec = this._objectTypesManager.getObjectTypeSpec(string2);
            if (objectTypeSpec == null) continue;
            object2 = objectTypeSpec.labelPlural;
            object = objectTypeSpec.icon;
            string = objectTypeSpec.listViewId;
            ExtensionInfo extensionInfo = this._extensionService.getExtensionInfo(string);
            ComponentSpec componentSpec = (ComponentSpec)this._extensionService.getExtensionObject(extensionInfo, null, true);
            SearchTypeData searchTypeData = new SearchTypeData();
            searchTypeData.type = string2;
            searchTypeData.icon = object;
            searchTypeData.labelPlural = object2;
            searchTypeData.listUrl = componentSpec.contentSpec.url;
            searchTypeData.listUid = componentSpec.getUid();
            searchTypeData.objectUids = ((Set)hashMap.get(string2)).toArray(new String[0]);
            arrayList.add(searchTypeData);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSearchableProperties() {
        try {
            this._writeLock.lock();
            List<TypeDescriptor> list = Arrays.asList(this._metadataService.getTypeMetadata(null));
            List<PropertyDescriptor> list2 = Arrays.asList(this._metadataService.getPropertyMetadata(null));
            this._searchableProperties = SearchUtil.getSearchableProperties(list, list2);
        }
        finally {
            this._writeLock.unlock();
        }
    }
}

