/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.search.formatter;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.mvc.search.SearchManager;
import com.vmware.vise.mvc.search.formatter.ISearchableTypeFormatter;
import com.vmware.vise.mvc.util.CommonUtils;

public class VmFormatter
implements ISearchableTypeFormatter {
    private static final String NAME_PROP = "name";
    private static final String IS_TEMPLATE_PROP = "config.template";
    private static final String FT_PRIMARY_PROP = "primaryVM";
    private static final String VM_TEMPLATE_TYPE = "VirtualMachineTemplate";
    private static final String VM_TYPE = VirtualMachine.class.getSimpleName();
    private PropertySpec[] _quickProperties;

    public VmFormatter(SearchManager searchManager) {
        if (searchManager != null) {
            searchManager.registerSearchableTypeFormatter(this);
        }
    }

    @Override
    public String getObjectType() {
        return VM_TYPE;
    }

    @Override
    public PropertySpec[] getQuickProperties() {
        if (this._quickProperties == null) {
            PropertySpec propertySpec = new PropertySpec();
            propertySpec.type = VirtualMachine.class.getSimpleName();
            propertySpec.propertyNames = new String[]{NAME_PROP, IS_TEMPLATE_PROP, FT_PRIMARY_PROP};
            this._quickProperties = new PropertySpec[]{propertySpec};
        }
        return this._quickProperties;
    }

    @Override
    public String getName(ResultItem resultItem) {
        String string = (String)VmFormatter.getProperty(resultItem, NAME_PROP);
        Object t = VmFormatter.getProperty(resultItem, FT_PRIMARY_PROP);
        if (t != null) {
            string = CommonUtils.text("secondaryVmFormat", string);
        }
        return string;
    }

    @Override
    public String getRuntimeType(ResultItem resultItem) {
        Boolean bl = (Boolean)VmFormatter.getProperty(resultItem, IS_TEMPLATE_PROP);
        if (bl != null && bl.booleanValue()) {
            return VM_TEMPLATE_TYPE;
        }
        return VM_TYPE;
    }

    @Override
    public Object getNavigationEntity(ResultItem resultItem) {
        if (resultItem == null) {
            return null;
        }
        Object t = VmFormatter.getProperty(resultItem, FT_PRIMARY_PROP);
        if (t != null) {
            return t;
        }
        return resultItem.resourceObject;
    }

    private static <T> T getProperty(ResultItem resultItem, String string) {
        if (resultItem == null || resultItem.properties == null || string == null) {
            return null;
        }
        for (PropertyValue propertyValue : resultItem.properties) {
            if (!string.equals(propertyValue.propertyName)) continue;
            return (T)propertyValue.value;
        }
        return null;
    }
}

