/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.search.util;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.FacetSpec;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SearchUtil {
    private static final String USER_SEARCHABLE_OPTION = "userSearchable";
    private static final String DEFAULT_SEARCH_PROPERTY = "name";
    private static final String TEXT_SEARCH_TARGET_OPTION = "textSearchTarget";
    private static final String MANAGED_ENTITY = "ManagedEntity";
    private static final String TAG_PROP = "inventoryservice:tag";
    private static final String TAG_TYPE = "inventoryservice:InventoryServiceTag";
    private static final String TAG_NAME_PROP = "name";
    private static final String EXTENSIBLE_MANAGED_OBJECT = "ExtensibleManagedObject";
    private static final String TYPE = "@type";

    public static boolean isUserSearchableDescriptor(Descriptor descriptor) {
        return descriptor.tags != null && descriptor.tags.containsKey(USER_SEARCHABLE_OPTION) && ((String)descriptor.tags.get(USER_SEARCHABLE_OPTION)).equalsIgnoreCase("true");
    }

    public static Constraint createSearchConstraintForDefaultProperty(List<String> list, Comparator comparator, String string) {
        String string22;
        ArrayList<PropertyConstraint> arrayList = new ArrayList<PropertyConstraint>();
        for (String string22 : list) {
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)string22, (String)"name", (Comparator)comparator, (Object)string);
            arrayList.add(propertyConstraint);
        }
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])arrayList.toArray(new Constraint[arrayList.size()]), (Conjoiner)Conjoiner.OR);
        string22 = SearchUtil.createSystemEntitiesFilterConstraint();
        return QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{constraint, string22}, (Conjoiner)Conjoiner.EXCEPT);
    }

    public static Constraint createSearchConstraintForProperties(Map<String, List<String>> map, Comparator comparator, String string) {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        for (Map.Entry<String, List<String>> constraint2 : map.entrySet()) {
            String string2 = constraint2.getKey();
            List<String> list = constraint2.getValue();
            Constraint constraint = SearchUtil.createConstraintForSingleType(string2, list, comparator, string);
            arrayList.add(constraint);
        }
        if (comparator != Comparator.NOT_EQUALS) {
            arrayList.add(SearchUtil.getObjectsByTagName(string, comparator));
        }
        Constraint constraint4 = QueryUtil.combineIntoSingleConstraint((Constraint[])arrayList.toArray(new Constraint[arrayList.size()]), (Conjoiner)Conjoiner.OR);
        Constraint constraint = SearchUtil.createSystemEntitiesFilterConstraint();
        return QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{constraint4, constraint}, (Conjoiner)Conjoiner.EXCEPT);
    }

    public static Constraint createSearchConstraintForType(String string, List<String> list, Comparator comparator, String string2) {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        Constraint constraint = SearchUtil.createConstraintForSingleType(string, list, comparator, string2);
        arrayList.add(constraint);
        if (comparator != Comparator.NOT_EQUALS) {
            arrayList.add(SearchUtil.getObjectsByTagName(string2, comparator));
        }
        Constraint constraint2 = QueryUtil.combineIntoSingleConstraint((Constraint[])arrayList.toArray(new Constraint[arrayList.size()]), (Conjoiner)Conjoiner.OR);
        Constraint constraint3 = SearchUtil.createSystemEntitiesFilterConstraint();
        return QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{constraint2, constraint3}, (Conjoiner)Conjoiner.EXCEPT);
    }

    public static PropertySpec[] createPropSpecsForDefaultProperty(List<String> list) {
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        for (String string : list) {
            PropertySpec propertySpec = new PropertySpec();
            propertySpec.type = string;
            propertySpec.propertyNames = new String[]{"name"};
            arrayList.add(propertySpec);
        }
        return arrayList.toArray(new PropertySpec[arrayList.size()]);
    }

    public static String generateRandomConstraintId() {
        return UUID.randomUUID().toString();
    }

    public static Map<String, List<String>> getSearchableProperties(List<TypeDescriptor> list, List<PropertyDescriptor> list2) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (TypeDescriptor typeDescriptor : list) {
            if (!SearchUtil.isUserSearchableDescriptor((Descriptor)typeDescriptor)) continue;
            hashMap.put(typeDescriptor.name, new ArrayList());
        }
        for (PropertyDescriptor propertyDescriptor : list2) {
            if (!SearchUtil.isUserSearchableDescriptor((Descriptor)propertyDescriptor) || !propertyDescriptor.valueTypeName.equalsIgnoreCase("string") || !SearchUtil.isTextSearchTargetProperty(propertyDescriptor) || !hashMap.containsKey(propertyDescriptor.providerName)) continue;
            ((List)hashMap.get(propertyDescriptor.providerName)).add(propertyDescriptor.name);
        }
        return hashMap;
    }

    public static boolean isTextSearchTargetProperty(PropertyDescriptor propertyDescriptor) {
        boolean bl = propertyDescriptor.tags == null || !propertyDescriptor.tags.containsKey(TEXT_SEARCH_TARGET_OPTION) || ((String)propertyDescriptor.tags.get(TEXT_SEARCH_TARGET_OPTION)).equalsIgnoreCase("true");
        return bl;
    }

    public static FacetSpec createFacetSpecRequestType() {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.type = EXTENSIBLE_MANAGED_OBJECT;
        propertySpec.propertyNames = new String[]{TYPE};
        FacetSpec facetSpec = new FacetSpec();
        facetSpec.propSpec = propertySpec;
        return facetSpec;
    }

    private static Constraint createConstraintForSingleType(String string, List<String> list, Comparator comparator, String string2) {
        ArrayList<PropertyConstraint> arrayList = new ArrayList<PropertyConstraint>();
        if (!list.contains("name")) {
            arrayList.add(QueryUtil.createPropertyConstraint((String)string, (String)"name", (Comparator)comparator, (Object)string2));
        }
        for (String string3 : list) {
            arrayList.add(QueryUtil.createPropertyConstraint((String)string, (String)string3, (Comparator)comparator, (Object)string2));
        }
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])arrayList.toArray(new Constraint[arrayList.size()]), (Conjoiner)Conjoiner.OR);
        return constraint;
    }

    private static Constraint createSystemEntitiesFilterConstraint() {
        PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)"Folder", (String)"isSystemFolder", (Comparator)Comparator.EQUALS, (Object)"true");
        PropertyConstraint propertyConstraint2 = QueryUtil.createPropertyConstraint((String)"ResourcePool", (String)"isRootRP", (Comparator)Comparator.EQUALS, (Object)"true");
        return QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{propertyConstraint, propertyConstraint2}, (Conjoiner)Conjoiner.OR);
    }

    private static Constraint getObjectsByTagName(String string, Comparator comparator) {
        if (comparator == null) {
            comparator = Comparator.CONTAINS;
        }
        PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TAG_TYPE, (String)"name", (Comparator)comparator, (Object)string);
        RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)TAG_PROP, (Constraint)propertyConstraint, (Boolean)false, (String)MANAGED_ENTITY);
        return relationalConstraint;
    }
}

