/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.services;

import com.google.common.collect.Lists;
import com.vmware.vim.binding.dataservice.QName;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.mvc.model.simple.Category;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoriesService {
    private DataService _dataService;
    private QuerySpecBuilder _querySpecBuilder;
    private static final Map<String, String> entityTypeNames = new HashMap<String, String>(){
        {
            this.put("com.vmware.content.library.Item", "LibraryItem");
            this.put("com.vmware.content.Library", "Library");
        }
    };

    @Autowired
    public CategoriesService(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
    }

    public List<Category> getCategories() {
        ResultItem[] resultItemArray;
        RequestSpec requestSpec = new RequestSpec();
        Constraint constraint = new Constraint();
        constraint.targetType = "inventoryservice:InventoryServiceCategory";
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(constraint, new String[]{"name", "description", "multipleCardinality", "associableEntityType"});
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        ArrayList arrayList = Lists.newArrayList();
        for (ResultItem resultItem : resultItemArray = response.resultSet[0].items) {
            PropertyValue[] propertyValueArray = resultItem.properties;
            String string = "";
            String string2 = "";
            boolean bl = false;
            String[] stringArray = new String[]{};
            for (PropertyValue propertyValue : propertyValueArray) {
                if (propertyValue.propertyName.equals("name")) {
                    string = propertyValue.value.toString();
                }
                if (propertyValue.propertyName.equals("description")) {
                    string2 = propertyValue.value.toString();
                }
                if (propertyValue.propertyName.equals("multipleCardinality")) {
                    bl = (Boolean)propertyValue.value;
                }
                stringArray = this.extractAssociableEntityTypes(stringArray, propertyValue);
            }
            arrayList.add(new Category(string, string2, bl, stringArray));
        }
        return arrayList;
    }

    private String[] extractAssociableEntityTypes(String[] stringArray, PropertyValue propertyValue) {
        if (propertyValue.propertyName.equals("associableEntityType") && propertyValue.value != null) {
            QName[] qNameArray = (QName[])propertyValue.value;
            stringArray = new String[qNameArray.length];
            for (int i = 0; i < qNameArray.length; ++i) {
                String string = qNameArray[i].getLocalPart();
                stringArray[i] = this.normalizeName(string);
            }
        }
        return stringArray;
    }

    private String normalizeName(String string) {
        if (entityTypeNames.containsKey(string)) {
            return entityTypeNames.get(string);
        }
        return string;
    }
}

