/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.services;

import com.google.common.collect.Lists;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.mvc.model.simple.Tag;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaggingService {
    private DataService dataService;
    private QuerySpecBuilder querySpecBuilder;
    public static final String TAG_TYPE = "inventoryservice:InventoryServiceTag";

    @Autowired
    public TaggingService(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this.dataService = dataService;
        this.querySpecBuilder = querySpecBuilder;
    }

    public List<Tag> getTags() {
        ResultItem[] resultItemArray;
        Constraint constraint = new Constraint();
        constraint.targetType = TAG_TYPE;
        QuerySpec querySpec = this.querySpecBuilder.buildQuerySpec(constraint, new String[]{"name", "description", "categoryName", "resourceObject"});
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        ArrayList arrayList = Lists.newArrayList();
        Response response = this.dataService.getData(requestSpec);
        for (ResultItem resultItem : resultItemArray = response.resultSet[0].items) {
            PropertyValue[] propertyValueArray = resultItem.properties;
            String string = "";
            String string2 = "";
            String string3 = "";
            for (PropertyValue propertyValue : propertyValueArray) {
                if (propertyValue.propertyName.equals("name")) {
                    string = propertyValue.value.toString();
                }
                if (propertyValue.propertyName.equals("description")) {
                    string2 = propertyValue.value.toString();
                }
                if (!propertyValue.propertyName.equals("categoryName")) continue;
                string3 = propertyValue.value.toString();
            }
            arrayList.add(new Tag(string, string2, string3, (ManagedObjectReference)resultItem.resourceObject));
        }
        return arrayList;
    }
}

