/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.telemetry;

import com.vmware.vim.binding.vim.fault.InvalidName;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vise.mvc.telemetry.DataCollectionConfigurator;
import com.vmware.vise.util.serialization.JsonObjectMapper;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class DataCollectionConfiguratorImpl
implements DataCollectionConfigurator {
    private static final Log _logger = LogFactory.getLog(DataCollectionConfiguratorImpl.class);
    private static final String COLLECTION_ENABLED_KEY = "VirtualCenter.DataCollector.ConsentData";
    private final ObjectMapper _objectMapper = new JsonObjectMapper();
    private final boolean _shouldSkipVcCheck = Boolean.parseBoolean(System.getProperty("isFling"));

    @Override
    public boolean isCeipEnabled() {
        if (this._shouldSkipVcCheck) {
            return true;
        }
        VcService vcService = this.getVcService();
        if (vcService == null) {
            return false;
        }
        String string = this.getConsentData(vcService);
        if (string == null) {
            return false;
        }
        boolean bl = this.parseConsentData(string);
        return bl;
    }

    private VcService getVcService() {
        List<VcService> list = this.getSessionVcServices();
        VcService vcService = this.getFirstCompatibleVc(list);
        return vcService;
    }

    private List<VcService> getSessionVcServices() {
        ArrayList<VcService> arrayList = new ArrayList<VcService>();
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (linkedVcGroupRegistry == null) {
            return arrayList;
        }
        LinkedVcGroup[] linkedVcGroupArray = linkedVcGroupRegistry.getLinkedVcGroups();
        if (linkedVcGroupArray == null) {
            return arrayList;
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray) {
            arrayList.addAll(linkedVcGroup.getVcServices());
        }
        return arrayList;
    }

    private VcService getFirstCompatibleVc(List<VcService> list) {
        for (VcService vcService : list) {
            if (!VcServiceUtil.is60VcOrLaterByVersion((String)vcService.getServiceVersion())) continue;
            return vcService;
        }
        return null;
    }

    private String getConsentData(VcService vcService) {
        OptionValue[] optionValueArray;
        OptionManager optionManager = this.getOptionManager(vcService);
        try {
            optionValueArray = optionManager.queryView(COLLECTION_ENABLED_KEY);
        }
        catch (InvalidName invalidName) {
            _logger.error((Object)"Wrong option name. There is no option called VirtualCenter.DataCollector.ConsentData");
            return null;
        }
        catch (RuntimeFault runtimeFault) {
            _logger.error((Object)"Could not retrieve information for setting VirtualCenter.DataCollector.ConsentData");
            return null;
        }
        String string = optionValueArray.length > 0 ? (String)optionValueArray[0].getValue() : null;
        return string;
    }

    private OptionManager getOptionManager(VcService vcService) {
        ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().getSetting();
        OptionManager optionManager = (OptionManager)vcService.getManagedObject(managedObjectReference);
        return optionManager;
    }

    private boolean parseConsentData(String string) {
        boolean bl = false;
        try {
            JsonNode jsonNode = this._objectMapper.readTree(string);
            JsonNode jsonNode2 = jsonNode.findValue("consentAccepted");
            bl = jsonNode2.getBooleanValue();
        }
        catch (IOException iOException) {
            _logger.error((Object)"Could not parse consent data. Unexpected data format.Disabling telemetry as a fallback option.");
        }
        return bl;
    }
}

