/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.mvc.tree.Tree;
import com.vmware.vise.mvc.tree.TreeList;
import com.vmware.vise.mvc.tree.TreeManager;
import com.vmware.vise.mvc.tree.TreeNodeItem;
import com.vmware.vise.mvc.tree.TreeNodeList;
import com.vmware.vise.mvc.tree.TreeNodeSpec;
import com.vmware.vise.mvc.tree.TreePath;
import com.vmware.vise.mvc.tree.TreePathHelper;
import com.vmware.vise.mvc.util.CommonUtils;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.I18nManager;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TreeManagerImpl
implements TreeManager {
    private static final Log _logger = LogFactory.getLog(TreeManagerImpl.class);
    private static final List<String> OBJECT_PROPERTIES = new ArrayList<String>(){
        {
            this.add("name");
            this.add("labelIds");
            this.add("primaryIconId");
            this.add("@modelKey");
        }
    };
    private final ObjectReferenceService _objRefService;
    private final DataService _dataService;
    private final I18nManager _i18nManager;
    private final TreeList _treeList;
    private final TreeNodeList _treeNodeList;
    private final TreePathHelper _treePathHelper;
    private final QueryService _queryService;

    @Autowired
    public TreeManagerImpl(ObjectReferenceService objectReferenceService, DataService dataService, I18nManager i18nManager, TreeList treeList, TreeNodeList treeNodeList, TreePathHelper treePathHelper, QueryServiceFactory queryServiceFactory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService, dataService, i18nManager, treeList, treeNodeList, treePathHelper});
        this._objRefService = objectReferenceService;
        this._dataService = dataService;
        this._i18nManager = i18nManager;
        this._treeList = treeList;
        this._treeNodeList = treeNodeList;
        this._treePathHelper = treePathHelper;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @Override
    public List<TreeNodeItem> getRoot(String string, String string2) {
        Tree tree = this._treeList.getTree(string);
        if (tree == null) {
            throw new IllegalStateException("No such tree declared: " + string);
        }
        TreeNodeSpec treeNodeSpec = this._treeNodeList.getTreeNodeSpec(tree.getRoot());
        if (treeNodeSpec == null) {
            throw new IllegalStateException("No such treeNodeSpec declared");
        }
        Object object = null;
        if (!StringUtil.isNullOrEmpty((String)string2) && (object = this._objRefService.getReference(string2, true)) == null) {
            _logger.warn((Object)String.format("No root reference found: [treeId=%s, objectId=%s]", string, string2));
        }
        QuerySpec[] querySpecArray = new QuerySpec[]{treeNodeSpec.getQuerySpec(object)};
        Response response = this.retrieveDataFromDs(querySpecArray);
        List<TreeNodeItem> list = this.formatResult(tree, response);
        return list;
    }

    @Override
    public List<TreeNodeItem> getChildren(String string, String string2, String string3) {
        Tree tree = this._treeList.getTree(string);
        if (tree == null) {
            throw new IllegalStateException("No such tree declared");
        }
        String[] stringArray = tree.getChildren(string2);
        if (stringArray == null) {
            _logger.info((Object)String.format("No childer for tree:[$s] and nodeType:[%s]", string, string2));
            return new ArrayList<TreeNodeItem>();
        }
        ArrayList<QuerySpec> arrayList = new ArrayList<QuerySpec>();
        Object object = this._objRefService.getReference(string3, true);
        if (object == null) {
            _logger.warn((Object)String.format("Possibly unexpected null MOR of the parent: [treeId=%s, nodeId=%s, parentRef=%s]", string, string2, string3));
        }
        for (String string4 : stringArray) {
            TreeNodeSpec treeNodeSpec = this._treeNodeList.getTreeNodeSpec(string4);
            if (treeNodeSpec == null) {
                throw new IllegalStateException("No such treeNodeSpec declared");
            }
            arrayList.add(treeNodeSpec.getQuerySpec(object));
        }
        String[] stringArray2 = arrayList.toArray(new QuerySpec[arrayList.size()]);
        Response response = this.retrieveDataFromDs((QuerySpec[])stringArray2);
        List<TreeNodeItem> list = this.formatResult(tree, response);
        return list;
    }

    @Override
    public TreePath getPath(String string, String string2, String string3, String string4) {
        Object object;
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, string3});
        Object object2 = this._objRefService.getReference(string3, true);
        Object object3 = null;
        if (string2 == null) {
            object = this.getRoot(string, null);
            String string5 = this._objRefService.getServerGuid(object2);
            Object object4 = object.iterator();
            while (object4.hasNext()) {
                TreeNodeItem treeNodeItem = object4.next();
                Object object5 = this._objRefService.getReference(treeNodeItem.objRef, true);
                if (string5 == null || !string5.equals(this._objRefService.getServerGuid(object5))) continue;
                object3 = object5;
                break;
            }
            if (object3 == null) {
                _logger.info((Object)String.format("No root items for tree:[$s]", string));
                object4 = new TreePath();
                ((TreePath)object4).options = string4;
                ((TreePath)object4).paths = new ArrayList<List<String>>();
                return object4;
            }
        } else {
            object3 = this._objRefService.getReference(string2, true);
        }
        object = this._treePathHelper.findPaths(string, object3, object2, string4);
        return object;
    }

    @Override
    public Map<String, Map<String, Object>> getPropertiesByObjectIds(List<String> list) {
        Object object;
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        if (ArrayUtil.isNullOrEmpty(list)) {
            return hashMap;
        }
        HashMap hashMap2 = new HashMap(list.size());
        for (String string : list) {
            Object object2;
            object = this._objRefService.getReference(string, true);
            if (object == null || (object2 = this._objRefService.getResourceObjectType(object)) == null) continue;
            if (!hashMap2.containsKey(object2)) {
                hashMap2.put((String)object2, new ArrayList());
            }
            ((List)hashMap2.get(object2)).add(object);
        }
        for (String string : hashMap2.keySet()) {
            object = this._queryService.select(OBJECT_PROPERTIES).from(new String[]{string}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, hashMap2.get(string))}).fetch();
            for (ResourceItem resourceItem : object.getItems()) {
                String string2;
                Object object3 = resourceItem.getKey();
                if (object3 == null || (string2 = this._objRefService.getUid(object3, true)) == null) continue;
                HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
                for (String string3 : OBJECT_PROPERTIES) {
                    if (string3.equals("@modelKey")) continue;
                    hashMap3.put(string3, resourceItem.get(string3));
                }
                hashMap.put(string2, hashMap3);
            }
        }
        return hashMap;
    }

    @Override
    public List<String> getSupportedTypes(String string) {
        return this._treeList.getSupportedTypes(string);
    }

    private Response retrieveDataFromDs(QuerySpec[] querySpecArray) {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecArray;
        Response response = this._dataService.getData(requestSpec);
        return response;
    }

    private List<TreeNodeItem> formatResult(Tree tree, Response response) {
        ArrayList<TreeNodeItem> arrayList = new ArrayList<TreeNodeItem>();
        if (response == null) {
            return arrayList;
        }
        ResultSet[] resultSetArray = response.resultSet;
        if (resultSetArray == null) {
            return arrayList;
        }
        Locale locale = ResourceUtil.getLocale();
        Map map = this._i18nManager.getResourceMap(locale);
        for (ResultSet resultSet : resultSetArray) {
            arrayList.addAll(this.formatResult(tree, resultSet, map));
        }
        return arrayList;
    }

    private List<TreeNodeItem> formatResult(Tree tree, ResultSet resultSet, Map<String, Map<String, String>> map) {
        ResultItem[] resultItemArray;
        ArrayList<TreeNodeItem> arrayList = new ArrayList<TreeNodeItem>();
        if (resultSet.error != null) {
            _logger.error((Object)String.format("Error when getting data from dataservice [treeId=%s]: %s", tree.getId(), resultSet.error.getMessage()), resultSet.error.getCause());
        }
        if ((resultItemArray = resultSet.items) == null || resultItemArray.length == 0) {
            return arrayList;
        }
        arrayList.ensureCapacity(resultItemArray.length);
        for (ResultItem resultItem : resultItemArray) {
            TreeNodeItem treeNodeItem = new TreeNodeItem();
            String string = this._objRefService.getUid(resultItem.resourceObject, true);
            if (string == null) {
                _logger.warn((Object)String.format("Possibly unexpected null uid: [treeId=%s, nodeId=%s]", tree.getId(), resultSet.queryName));
            }
            treeNodeItem.objRef = string;
            treeNodeItem.nodeTypeId = resultSet.queryName;
            if (tree.hasChildren(resultSet.queryName)) {
                treeNodeItem.hasChildren = Boolean.TRUE;
            }
            String string2 = null;
            for (PropertyValue propertyValue : resultItem.properties) {
                String string3 = propertyValue.propertyName;
                if (StringUtil.isNullOrEmpty((String)string3)) {
                    _logger.error((Object)String.format("Found a null or empty propertyName for: [treeId=%s, nodeId=%s,  uid=%s]", tree.getId(), resultSet.queryName, string));
                    continue;
                }
                String string4 = propertyValue.value.toString();
                if (string3.equalsIgnoreCase("name")) {
                    treeNodeItem.text = string4;
                    continue;
                }
                if (string3.equalsIgnoreCase("primaryIconId")) {
                    treeNodeItem.spriteCssClass = string4;
                    continue;
                }
                if (!string3.equalsIgnoreCase("labelIds")) continue;
                string2 = CommonUtils.getTaggingLabel(propertyValue.value.toString(), map, null, null);
            }
            if (string2 != null) {
                treeNodeItem.text = treeNodeItem.text + string2;
            }
            arrayList.add(treeNodeItem);
        }
        return arrayList;
    }
}

