/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.mvc.tree.TreeManager;
import com.vmware.vise.mvc.tree.TreeNodeSpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeNodeList {
    private static final Log _logger = LogFactory.getLog(TreeNodeList.class);
    private static final Map<String, TreeNodeSpec> _treeNodeListMap = new HashMap<String, TreeNodeSpec>();

    public TreeNodeList() {
        this.buildTreeNodeListMap();
    }

    public TreeNodeSpec getTreeNodeSpec(String string) {
        return _treeNodeListMap.get(string);
    }

    private void buildTreeNodeListMap() {
        Class<?>[] classArray;
        for (Class<?> clazz : classArray = TreeNodeList.class.getDeclaredClasses()) {
            if (!TreeNodeSpec.class.isAssignableFrom(clazz)) continue;
            try {
                TreeNodeSpec treeNodeSpec = (TreeNodeSpec)clazz.newInstance();
                _treeNodeListMap.put(treeNodeSpec.getId(), treeNodeSpec);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                _logger.error((Object)"Cannot intstantiate a tree definition", (Throwable)reflectiveOperationException);
            }
        }
    }

    static class DvsDvpg
    extends TreeNodeSpec {
        DvsDvpg() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"dvs", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP);
            return relationalConstraint;
        }
    }

    static class NetworkFolderDvs
    extends TreeNodeSpec {
        NetworkFolderDvs() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH, TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH};
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"childEntity", (Constraint)objectIdentityConstraint, (Boolean)true, null);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH);
            PropertyConstraint propertyConstraint2 = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{propertyConstraint, propertyConstraint2}, (Conjoiner)Conjoiner.OR);
            CompositeConstraint compositeConstraint2 = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, compositeConstraint}, (Conjoiner)Conjoiner.AND);
            return compositeConstraint2;
        }
    }

    static class NetworkFolderOpaqueNetwork
    extends TreeNodeSpec {
        NetworkFolderOpaqueNetwork() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_OPAQUENETWORK);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_OPAQUENETWORK, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_OPAQUENETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_OPAQUENETWORK;
            return compositeConstraint;
        }
    }

    static class NetworkFolderNetwork
    extends TreeNodeSpec {
        NetworkFolderNetwork() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_NETWORK);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_NETWORK, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_NETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_NETWORK;
            return compositeConstraint;
        }
    }

    static class NetworkFolderNetworkFolder
    extends TreeNodeSpec {
        NetworkFolderNetworkFolder() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_NETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class DcDvs
    extends TreeNodeSpec {
        DcDvs() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH, TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH};
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"networkFolder", (Constraint)objectIdentityConstraint, (Boolean)true, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"childEntity", (Constraint)relationalConstraint, (Boolean)true, null);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH);
            PropertyConstraint propertyConstraint2 = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{propertyConstraint, propertyConstraint2}, (Conjoiner)Conjoiner.OR);
            CompositeConstraint compositeConstraint2 = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, compositeConstraint}, (Conjoiner)Conjoiner.AND);
            return compositeConstraint2;
        }
    }

    static class DcOpaqueNetwork
    extends TreeNodeSpec {
        DcOpaqueNetwork() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"networkFolder", (Constraint)objectIdentityConstraint, (Boolean)true, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_OPAQUENETWORK);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_OPAQUENETWORK, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_OPAQUENETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_OPAQUENETWORK;
            return compositeConstraint;
        }
    }

    static class DcNetwork
    extends TreeNodeSpec {
        DcNetwork() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"networkFolder", (Constraint)objectIdentityConstraint, (Boolean)true, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_NETWORK);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_NETWORK, (String)"@type", (Comparator)Comparator.EQUALS, (Object)TreeManager.TARGET_NETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_NETWORK;
            return compositeConstraint;
        }
    }

    static class DcNetworkFolder
    extends TreeNodeSpec {
        DcNetworkFolder() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"networkFolder", (Constraint)objectIdentityConstraint, (Boolean)true, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_NETWORK);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class StoragepodDatastore
    extends TreeNodeSpec {
        StoragepodDatastore() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_DATASTORE);
            return relationalConstraint;
        }
    }

    static class DatastoreFolderDatastore
    extends TreeNodeSpec {
        DatastoreFolderDatastore() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_DATASTORE);
            return relationalConstraint;
        }
    }

    static class DatastoreFolderStoragepod
    extends TreeNodeSpec {
        DatastoreFolderStoragepod() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_STORAGEPOD);
            return relationalConstraint;
        }
    }

    static class DatastoreFolderDatastoreFolder
    extends TreeNodeSpec {
        DatastoreFolderDatastoreFolder() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_DATASTORE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class DcDatastore
    extends TreeNodeSpec {
        DcDatastore() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_DATASTORE);
            return relationalConstraint2;
        }
    }

    static class DcStoragepod
    extends TreeNodeSpec {
        DcStoragepod() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_STORAGEPOD);
            return relationalConstraint2;
        }
    }

    static class DcDatastoreFolder
    extends TreeNodeSpec {
        DcDatastoreFolder() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_DATASTORE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class VmFolderVmTemplate
    extends TreeNodeSpec {
        VmFolderVmTemplate() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"config.template", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class VmFolderVm
    extends TreeNodeSpec {
        VmFolderVm() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"isNormalVMOrPrimaryFTVM", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class VmFolderVApp
    extends TreeNodeSpec {
        VmFolderVApp() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parentFolder", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_VIRTUALAPP);
            return relationalConstraint;
        }
    }

    static class VmFolderVmFolder
    extends TreeNodeSpec {
        VmFolderVmFolder() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_VIRTUALMACHINE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class DcVmTemplate
    extends TreeNodeSpec {
        DcVmTemplate() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"config.template", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class DcVm
    extends TreeNodeSpec {
        DcVm() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"isNormalVMOrPrimaryFTVM", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class DcVApp
    extends TreeNodeSpec {
        DcVApp() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parentFolder", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_VIRTUALAPP);
            return relationalConstraint2;
        }
    }

    static class DcVmFolder
    extends TreeNodeSpec {
        DcVmFolder() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_VIRTUALMACHINE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class ResPoolVm
    extends TreeNodeSpec {
        ResPoolVm() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"resourcePool", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"isNormalVMOrPrimaryFTVM", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class ResPoolResPool
    extends TreeNodeSpec {
        ResPoolResPool() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_RESOURCEPOOL, TreeManager.TARGET_VIRTUALAPP};
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            return relationalConstraint;
        }
    }

    static class StandaloneHostVm
    extends TreeNodeSpec {
        StandaloneHostVm() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"standalonehost", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"isNormalVMOrPrimaryFTVM", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class StandaloneHostResPool
    extends TreeNodeSpec {
        StandaloneHostResPool() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_RESOURCEPOOL, TreeManager.TARGET_VIRTUALAPP};
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"host", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_COMPUTERESOURCE);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            RelationalConstraint relationalConstraint3 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint2, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            return relationalConstraint3;
        }
    }

    static class ClusterHostSystem
    extends TreeNodeSpec {
        ClusterHostSystem() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_HOSTSYSTEM);
            return relationalConstraint;
        }
    }

    static class ClusterVm
    extends TreeNodeSpec {
        ClusterVm() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"resourcePool", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_VIRTUALMACHINE);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_VIRTUALMACHINE, (String)"isNormalVMOrPrimaryFTVM", (Comparator)Comparator.EQUALS, (Object)true);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_VIRTUALMACHINE;
            return compositeConstraint;
        }
    }

    static class ClusterResPool
    extends TreeNodeSpec {
        ClusterResPool() {
        }

        @Override
        public String[] getResultTypes() {
            return new String[]{TreeManager.TARGET_RESOURCEPOOL, TreeManager.TARGET_VIRTUALAPP};
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_RESOURCEPOOL);
            return relationalConstraint2;
        }
    }

    static class CompResFolderStandaloneHost
    extends TreeNodeSpec {
        CompResFolderStandaloneHost() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_COMPUTERESOURCE);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_COMPUTERESOURCE, (String)"@type", (Comparator)Comparator.NOT_EQUALS, (Object)TreeManager.TARGET_CLUSTERCOMPUTERESOURCE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_COMPUTERESOURCE;
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)compositeConstraint, (Boolean)false, (String)TreeManager.TARGET_HOSTSYSTEM);
            return relationalConstraint2;
        }
    }

    static class CompResFolderCluster
    extends TreeNodeSpec {
        CompResFolderCluster() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_CLUSTERCOMPUTERESOURCE);
            return relationalConstraint;
        }
    }

    static class CompResFolderCompResFolder
    extends TreeNodeSpec {
        CompResFolderCompResFolder() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_COMPUTERESOURCE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class DcStandaloneHost
    extends TreeNodeSpec {
        DcStandaloneHost() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_COMPUTERESOURCE);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_COMPUTERESOURCE, (String)"@type", (Comparator)Comparator.NOT_EQUALS, (Object)TreeManager.TARGET_CLUSTERCOMPUTERESOURCE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            RelationalConstraint relationalConstraint3 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)compositeConstraint, (Boolean)false, (String)TreeManager.TARGET_HOSTSYSTEM);
            return relationalConstraint3;
        }
    }

    static class DcCluster
    extends TreeNodeSpec {
        DcCluster() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_CLUSTERCOMPUTERESOURCE);
            return relationalConstraint2;
        }
    }

    static class DcCompResFolder
    extends TreeNodeSpec {
        DcCompResFolder() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)objectIdentityConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"parent", (Constraint)relationalConstraint, (Boolean)false, (String)TreeManager.TARGET_FOLDER);
            PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)TreeManager.TARGET_FOLDER, (String)"childType", (Comparator)Comparator.CONTAINS, (Object)TreeManager.TARGET_COMPUTERESOURCE);
            CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, propertyConstraint}, (Conjoiner)Conjoiner.AND);
            compositeConstraint.targetType = TreeManager.TARGET_FOLDER;
            return compositeConstraint;
        }
    }

    static class Datacenter
    extends TreeNodeSpec {
        Datacenter() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = object;
            RelationalConstraint relationalConstraint = new RelationalConstraint();
            relationalConstraint.relation = "parent";
            relationalConstraint.targetType = TreeManager.TARGET_DATACENTER;
            relationalConstraint.hasInverseRelation = false;
            relationalConstraint.constraintOnRelatedObject = objectIdentityConstraint;
            return relationalConstraint;
        }
    }

    static class DatacenterFolder
    extends TreeNodeSpec {
        DatacenterFolder() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = object;
            RelationalConstraint relationalConstraint = new RelationalConstraint();
            relationalConstraint.relation = "parent";
            relationalConstraint.targetType = TreeManager.TARGET_FOLDER;
            relationalConstraint.hasInverseRelation = false;
            relationalConstraint.constraintOnRelatedObject = objectIdentityConstraint;
            return relationalConstraint;
        }
    }

    static class RefAsRoot
    extends TreeNodeSpec {
        RefAsRoot() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)object);
            return objectIdentityConstraint;
        }
    }

    static class VcRoot
    extends TreeNodeSpec {
        VcRoot() {
        }

        @Override
        public Constraint getConstraint(Object object) {
            PropertyConstraint propertyConstraint = new PropertyConstraint();
            propertyConstraint.targetType = TreeManager.TARGET_FOLDER;
            propertyConstraint.propertyName = "isRootFolder";
            propertyConstraint.comparator = Comparator.EQUALS;
            propertyConstraint.comparableValue = Boolean.TRUE;
            return propertyConstraint;
        }
    }
}

