/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.mvc.tree.TreeManager;

public abstract class TreeNodeSpec {
    private final String _id = this.getClass().getSimpleName();

    public abstract Constraint getConstraint(Object var1);

    public String getId() {
        return this._id;
    }

    public String[] getProperties() {
        return TreeManager.DEFAULT_PROPERTIES;
    }

    public String[] getResultTypes() {
        return new String[0];
    }

    public QuerySpec getQuerySpec(Object object) {
        Constraint constraint = this.getConstraint(object);
        String[] stringArray = this.getProperties();
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])stringArray);
        querySpec.name = this.getId();
        querySpec.resultSpec = this.getResultSpec();
        return querySpec;
    }

    protected ResultSpec getResultSpec() {
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = -1;
        resultSpec.order = this.getOrderingCriteria();
        return resultSpec;
    }

    protected OrderingCriteria getOrderingCriteria() {
        OrderingPropertySpec orderingPropertySpec = new OrderingPropertySpec();
        orderingPropertySpec.propertyNames = new String[]{"name"};
        orderingPropertySpec.orderingType = SortType.ASCENDING;
        OrderingCriteria orderingCriteria = new OrderingCriteria();
        orderingCriteria.orderingProperties = new OrderingPropertySpec[]{orderingPropertySpec};
        return orderingCriteria;
    }
}

