/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.mvc.tree.InverseTree;
import com.vmware.vise.mvc.tree.NodeRoute;
import com.vmware.vise.mvc.tree.Tree;
import com.vmware.vise.mvc.tree.TreeList;
import com.vmware.vise.mvc.tree.TreeNodeList;
import com.vmware.vise.mvc.tree.TreeNodeSpec;
import com.vmware.vise.mvc.tree.TreePath;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.navigator.NavigatorService;
import com.vmware.vsphere.client.navigator.ObjectChainElement;
import com.vmware.vsphere.client.navigator.PathQueryResultSet;
import com.vmware.vsphere.client.navigator.PathQuerySpec;
import com.vmware.vsphere.client.navigator.QuerySpecChainElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TreePathHelper {
    private static final Log _logger = LogFactory.getLog(TreePathHelper.class);
    private static final String PATH_IN_ALL_TREES = "pathToTheRoot";
    private static final String PATH_IN_PHYSICAL_TREE = "physicalPathToRoot";
    private static final String PATH_IN_VIRTUAL_TREE = "pathToTheRootInVirtualTree";
    private static final String PATH_IN_STORAGE_TREE = "pathToTheRootInStorageTree";
    private static final String PATH_IN_NETWORK_TREE = "pathToTheRoot";
    private static final String SPEC_SUPPORTED_TOKEN = "{objectRef}";
    private final ObjectReferenceService _objRefService;
    private final NavigatorService _navigatorService;
    private final TreeList _treeList;
    private final TreeNodeList _treeNodeList;
    private final QueryService _queryService;
    private final Map<String, InverseTree> _inverseTreeMap = new ConcurrentHashMap<String, InverseTree>();

    @Autowired
    public TreePathHelper(ObjectReferenceService objectReferenceService, NavigatorService navigatorService, TreeList treeList, TreeNodeList treeNodeList, QueryServiceFactory queryServiceFactory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService, navigatorService, treeList, treeNodeList});
        this._objRefService = objectReferenceService;
        this._navigatorService = navigatorService;
        this._treeList = treeList;
        this._treeNodeList = treeNodeList;
        this._queryService = queryServiceFactory.getQueryService();
    }

    public TreePath findPaths(String string, Object object, Object object2, String string2) {
        Object object3;
        boolean bl;
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, object, object2});
        List<Object> list = null;
        boolean bl2 = object2 instanceof ManagedObjectReference;
        boolean bl3 = bl = bl2 && !ManagedObjectUtil.isOfType((ManagedObjectReference)((ManagedObjectReference)object2), Folder.class) && !ManagedObjectUtil.isOfType((ManagedObjectReference)((ManagedObjectReference)object2), VmwareDistributedVirtualSwitch.class);
        if (bl && this._treeList.isNavigationalTree(string) && VcServiceUtil.is65VcOrLaterByServerGuid((String)((ManagedObjectReference)object2).getServerGuid())) {
            object3 = this.getPathToTheRoot((ManagedObjectReference)object2, string);
            list = new ArrayList<Object>();
            list.add(object3);
        } else {
            object3 = this.getInverseTree(string);
            PathQuerySpec[] pathQuerySpecArray = this.buildPathQuerySpecs((InverseTree)object3, object2);
            PathQueryResultSet[] pathQueryResultSetArray = this._navigatorService.queryObjectPath(pathQuerySpecArray);
            list = this.extractPaths(pathQueryResultSetArray, (InverseTree)object3, object, object2);
        }
        object3 = new TreePath();
        ((TreePath)object3).options = string2;
        ((TreePath)object3).paths = list;
        return object3;
    }

    private List<String> getPathToTheRoot(ManagedObjectReference managedObjectReference, String string) {
        String string2 = "pathToTheRoot";
        if (!ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, Datacenter.class)) {
            switch (string) {
                case "vsphere.core.physicalInventorySpec": {
                    string2 = PATH_IN_PHYSICAL_TREE;
                    break;
                }
                case "vsphere.core.virtualInventorySpec": {
                    string2 = PATH_IN_VIRTUAL_TREE;
                    break;
                }
                case "vsphere.core.storageInventorySpec": {
                    string2 = PATH_IN_STORAGE_TREE;
                    break;
                }
                case "vsphere.core.networkingInventorySpec": {
                    string2 = "pathToTheRoot";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid tree Id");
                }
            }
        }
        String string3 = this._queryService.select(new String[]{string2}).from(new String[]{managedObjectReference.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)managedObjectReference).fetch();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string3.getItems().size() != 1) {
            return new ArrayList<String>();
        }
        ResourceItem resourceItem = (ResourceItem)string3.getItems().get(0);
        Object[] objectArray = (Object[])resourceItem.get(0);
        if (objectArray == null) {
            return new ArrayList<String>();
        }
        for (int i = objectArray.length - 1; i >= 0; --i) {
            arrayList.add(this._objRefService.getUid(objectArray[i], true));
        }
        return arrayList;
    }

    private InverseTree getInverseTree(String string) {
        InverseTree inverseTree = this._inverseTreeMap.get(string);
        if (inverseTree == null) {
            inverseTree = this.buildInverseTree(string);
            this._inverseTreeMap.put(string, inverseTree);
        }
        return inverseTree;
    }

    private InverseTree buildInverseTree(String string) {
        Tree tree = this._treeList.getTree(string);
        if (tree == null) {
            throw new IllegalStateException(String.format("No such tree declared for: [treeId=%s]", string));
        }
        InverseTree inverseTree = new InverseTree(tree);
        String string2 = tree.getRoot();
        this.buildInverseTree(inverseTree, string2, new NodeRoute());
        return inverseTree;
    }

    private void buildInverseTree(InverseTree inverseTree, String string, List<String> list) {
        String[] stringArray = inverseTree.getRealTree().getChildren(string);
        if (stringArray == null) {
            return;
        }
        for (String string2 : stringArray) {
            String[] stringArray2;
            TreeNodeSpec treeNodeSpec = this._treeNodeList.getTreeNodeSpec(string2);
            if (treeNodeSpec == null) {
                _logger.error((Object)String.format("No such treeNodeSpec declared for: [treeId=%s, parentNodeId=%s]", inverseTree.getRealTree().getId(), string2));
                continue;
            }
            if (string2.equals(string)) {
                inverseTree.addSelfChaining(string2);
                continue;
            }
            if (list.contains(string2)) {
                _logger.warn((Object)String.format("Deep nested multilevel recursion found: [treeId=%s, nodeId=%s]", inverseTree.getRealTree().getId(), string2));
                continue;
            }
            NodeRoute nodeRoute = new NodeRoute((Collection<? extends String>)list);
            nodeRoute.add(string2);
            for (String string3 : stringArray2 = TreePathHelper.getResultTypes(treeNodeSpec)) {
                inverseTree.addRoute(string3, nodeRoute);
            }
            this.buildInverseTree(inverseTree, string2, nodeRoute);
        }
    }

    private PathQuerySpec[] buildPathQuerySpecs(InverseTree inverseTree, Object object) {
        String string = this._objRefService.getResourceObjectType(object);
        List<NodeRoute> list = inverseTree.getRoutes(string);
        if (list.isEmpty()) {
            _logger.info((Object)String.format("No inverse routes for: [treeId=%s, type=%s]", inverseTree.getRealTree().getId(), string));
            return new PathQuerySpec[0];
        }
        ArrayList<PathQuerySpec> arrayList = new ArrayList<PathQuerySpec>();
        arrayList.ensureCapacity(list.size());
        for (NodeRoute nodeRoute : list) {
            if (nodeRoute.isEmpty()) {
                _logger.warn((Object)String.format("Empty route for: [treeId=%s, type=%s]", inverseTree.getRealTree().getId(), string));
                continue;
            }
            QuerySpecChainElement querySpecChainElement = null;
            QuerySpecChainElement querySpecChainElement2 = null;
            for (String string2 : nodeRoute) {
                querySpecChainElement = new QuerySpecChainElement();
                querySpecChainElement.object = this._treeNodeList.getTreeNodeSpec(string2).getQuerySpec(SPEC_SUPPORTED_TOKEN);
                if (inverseTree.isSelfChaining(string2)) {
                    querySpecChainElement.selfChaining = true;
                }
                if (querySpecChainElement2 != null) {
                    querySpecChainElement.nextObject = querySpecChainElement2;
                }
                querySpecChainElement2 = querySpecChainElement;
            }
            PathQuerySpec pathQuerySpec = new PathQuerySpec();
            pathQuerySpec.object = object;
            pathQuerySpec.querySpecChain = querySpecChainElement;
            arrayList.add(pathQuerySpec);
        }
        return arrayList.toArray(new PathQuerySpec[arrayList.size()]);
    }

    private List<List<String>> extractPaths(PathQueryResultSet[] pathQueryResultSetArray, InverseTree inverseTree, Object object, Object object2) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        if (pathQueryResultSetArray == null) {
            return arrayList;
        }
        for (PathQueryResultSet pathQueryResultSet : pathQueryResultSetArray) {
            if (pathQueryResultSet == null) continue;
            if (pathQueryResultSet.error != null) {
                _logger.error((Object)String.format("Error when retrieving path for: [treeId=%s, type=%s], error is [%s]", inverseTree.getRealTree().getId(), this._objRefService.getResourceObjectType(object2), pathQueryResultSet.error.toString()));
            }
            for (ObjectChainElement objectChainElement : pathQueryResultSet.paths) {
                if (!object.equals(objectChainElement.object)) continue;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ObjectChainElement objectChainElement2 = objectChainElement;
                while (objectChainElement2 != null) {
                    arrayList2.add(this._objRefService.getUid(objectChainElement2.object, true));
                    objectChainElement2 = objectChainElement2.nextObject;
                }
                arrayList.add(arrayList2);
            }
        }
        return arrayList;
    }

    static String[] getResultTypes(TreeNodeSpec treeNodeSpec) {
        String[] stringArray = treeNodeSpec.getResultTypes();
        if (stringArray != null && stringArray.length > 0) {
            return stringArray;
        }
        QuerySpec querySpec = treeNodeSpec.getQuerySpec(null);
        String string = TreePathHelper.extractTargetType(querySpec);
        if (string != null) {
            return new String[]{string};
        }
        return new String[0];
    }

    static String extractTargetType(QuerySpec querySpec) {
        if (querySpec != null && querySpec.resourceSpec != null && querySpec.resourceSpec.constraint != null) {
            return querySpec.resourceSpec.constraint.targetType;
        }
        return null;
    }
}

