/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.util;

import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.mvc.model.data.ParamSpec;
import com.vmware.vise.mvc.util.ObjectConvertUtils;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.service.ClassLoaderService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class ParameterSpecHelper {
    private ParamSpec[] _parameterSpecs;
    private ClassLoaderService _classLoaderService;
    private ObjectMapper _objectMapper;

    public ParameterSpecHelper(ClassLoaderService classLoaderService, ObjectMapper objectMapper, ParamSpec[] paramSpecArray) {
        this._classLoaderService = classLoaderService;
        this._objectMapper = objectMapper;
        this._parameterSpecs = paramSpecArray;
    }

    public Map<String, List<ParameterSpec>> getParameterSpecs() throws ClassNotFoundException, JsonParseException, JsonMappingException, IOException {
        HashMap<String, List<ParameterSpec>> hashMap = new HashMap<String, List<ParameterSpec>>();
        if (this._parameterSpecs == null || this._parameterSpecs.length == 0) {
            return hashMap;
        }
        for (ParamSpec paramSpec : this._parameterSpecs) {
            String string = paramSpec.propertyName;
            if (string == null || string.trim().equals("")) continue;
            ArrayList<ParameterSpec> arrayList = (ArrayList<ParameterSpec>)hashMap.get(string);
            if (ArrayUtil.isNullOrEmpty((List)arrayList)) {
                arrayList = new ArrayList<ParameterSpec>();
                hashMap.put(string, arrayList);
            }
            ParameterSpec parameterSpec = new ParameterSpec();
            parameterSpec.propertyName = string;
            Class clazz = this._classLoaderService.loadClass(paramSpec.parameterType);
            parameterSpec.parameter = ObjectConvertUtils.fromJson(this._objectMapper, clazz, this._objectMapper.writeValueAsString(paramSpec.parameter));
            arrayList.add(parameterSpec);
        }
        return hashMap;
    }
}

