/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.repository.internal;

import com.vmware.platform.tools.virgo.instrumentation.AdditionalLoggingAspect;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.services.internal.KernelServicesLogEvents;
import org.eclipse.virgo.kernel.services.repository.internal.EmptyRepository;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.RepositoryCreationException;
import org.eclipse.virgo.repository.RepositoryFactory;
import org.eclipse.virgo.repository.configuration.PropertiesRepositoryConfigurationReader;
import org.eclipse.virgo.repository.configuration.RepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.RepositoryConfigurationException;
import org.eclipse.virgo.util.math.OrderedPair;
import org.slf4j.Logger;
import org.springframework.beans.factory.FactoryBean;

public final class RepositoryFactoryBean
implements FactoryBean<Repository> {
    private final Properties repositoryProperties;
    private final EventLogger eventLogger;
    private final RepositoryFactory repositoryFactory;
    private volatile Repository repository;
    private final File workDirectory;
    private final Set<ArtifactBridge> artifactBridges;
    private final String mBeanDomain;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public RepositoryFactoryBean(Properties repositoryProperties, EventLogger eventLogger, RepositoryFactory repositoryFactory, File workDirectory, Set<ArtifactBridge> artifactBridges, String mBeanDomain) {
        RepositoryFactoryBean ajc$this;
        Properties properties = repositoryProperties;
        EventLogger eventLogger2 = eventLogger;
        RepositoryFactory repositoryFactory2 = repositoryFactory;
        File file = workDirectory;
        Set<ArtifactBridge> set = artifactBridges;
        String string = mBeanDomain;
        Object[] objectArray = new Object[]{properties, eventLogger2, repositoryFactory2, file, set, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)ajc$this, (Object)ajc$this, (Object[])objectArray);
        RepositoryFactoryBean.init$_aroundBody1$advice(ajc$this, properties, eventLogger2, repositoryFactory2, file, set, string, joinPoint, AdditionalLoggingAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public Repository getObject() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        return (Repository)RepositoryFactoryBean.getObject_aroundBody3$advice(this, joinPoint, AdditionalLoggingAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public Class<? extends Repository> getObjectType() {
        return Repository.class;
    }

    public boolean isSingleton() {
        try {
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            boolean bl = true;
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return bl;
        }
        catch (Throwable throwable) {
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    public void destroy() {
        try {
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            Repository localRepository = this.repository;
            if (localRepository != null) {
                this.repository = null;
                localRepository.stop();
            }
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private Repository createRepository() throws RepositoryConfigurationException, RepositoryCreationException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        return (Repository)RepositoryFactoryBean.createRepository_aroundBody5$advice(this, joinPoint, AdditionalLoggingAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    static {
        RepositoryFactoryBean.ajc$preClinit();
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.services.repository.internal.RepositoryFactoryBean");
    }

    private static final /* synthetic */ void init$_aroundBody0(RepositoryFactoryBean ajc$this, Properties repositoryProperties, EventLogger eventLogger, RepositoryFactory repositoryFactory, File workDirectory, Set artifactBridges, String mBeanDomain, JoinPoint joinPoint) {
        ajc$this.repositoryProperties = repositoryProperties;
        ajc$this.eventLogger = eventLogger;
        ajc$this.repositoryFactory = repositoryFactory;
        ajc$this.workDirectory = workDirectory;
        ajc$this.artifactBridges = artifactBridges;
        ajc$this.mBeanDomain = mBeanDomain;
    }

    private static final /* synthetic */ Object init$_aroundBody1$advice(RepositoryFactoryBean ajc$this, Properties repositoryProperties, EventLogger eventLogger, RepositoryFactory repositoryFactory, File workDirectory, Set artifactBridges, String mBeanDomain, JoinPoint thisJoinPoint, AdditionalLoggingAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint) {
        Logger logger = AdditionalLoggingAspect.ajc$inlineAccessMethod$com_vmware_platform_tools_virgo_instrumentation_AdditionalLoggingAspect$com_vmware_platform_tools_virgo_instrumentation_AdditionalLoggingAspect$getLogger(ajc$aspectInstance, (JoinPoint)joinPoint);
        String signature = joinPoint.getSignature().toShortString();
        try {
            logger.error("~~~ Invoking " + signature);
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RepositoryFactoryBean.init$_aroundBody0(ajc$this, repositoryProperties, eventLogger, repositoryFactory, workDirectory, artifactBridges, mBeanDomain, (JoinPoint)proceedingJoinPoint);
            Object result = null;
            logger.error("~~~ Invocation of " + signature + " complete. Returning " + result);
            return result;
        }
        catch (Throwable t) {
            logger.error("~~~ Invocation of " + signature + " failed", t);
            throw t;
        }
    }

    private static final /* synthetic */ Repository getObject_aroundBody2(RepositoryFactoryBean ajc$this, JoinPoint joinPoint) {
        if (ajc$this.repository == null) {
            ajc$this.repository = ajc$this.createRepository();
        }
        return ajc$this.repository;
    }

    private static final /* synthetic */ Object getObject_aroundBody3$advice(RepositoryFactoryBean ajc$this, JoinPoint thisJoinPoint, AdditionalLoggingAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint) {
        Logger logger = AdditionalLoggingAspect.ajc$inlineAccessMethod$com_vmware_platform_tools_virgo_instrumentation_AdditionalLoggingAspect$com_vmware_platform_tools_virgo_instrumentation_AdditionalLoggingAspect$getLogger(ajc$aspectInstance, (JoinPoint)joinPoint);
        String signature = joinPoint.getSignature().toShortString();
        try {
            logger.error("~~~ Invoking " + signature);
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            Repository result = RepositoryFactoryBean.getObject_aroundBody2(ajc$this, (JoinPoint)proceedingJoinPoint);
            logger.error("~~~ Invocation of " + signature + " complete. Returning " + result);
            return result;
        }
        catch (Throwable t) {
            logger.error("~~~ Invocation of " + signature + " failed", t);
            throw t;
        }
    }

    private static final /* synthetic */ Repository createRepository_aroundBody4(RepositoryFactoryBean ajc$this, JoinPoint joinPoint) {
        try {
            EmptyRepository emptyRepository;
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            PropertiesRepositoryConfigurationReader configurationReader = new PropertiesRepositoryConfigurationReader(ajc$this.workDirectory, ajc$this.artifactBridges, ajc$this.eventLogger, ajc$this.mBeanDomain);
            OrderedPair configurations = configurationReader.readConfiguration(ajc$this.repositoryProperties);
            Map configurationMap = (Map)configurations.getFirst();
            List chainList = (List)configurations.getSecond();
            if (chainList.isEmpty()) {
                ajc$this.eventLogger.log((LogEvent)KernelServicesLogEvents.KERNEL_REPOSITORY_CHAIN_EMPTY, new Object[0]);
                emptyRepository = new EmptyRepository();
            } else {
                ArrayList<RepositoryConfiguration> repositoryConfigurationChain = new ArrayList<RepositoryConfiguration>(chainList.size());
                for (String repositoryName : chainList) {
                    RepositoryConfiguration repositoryConfiguration = (RepositoryConfiguration)configurationMap.get(repositoryName);
                    if (repositoryConfiguration == null) {
                        ajc$this.eventLogger.log((LogEvent)KernelServicesLogEvents.KERNEL_REPOSITORY_CHAIN_ENTRY_NOT_VALID, new Object[]{repositoryName});
                        throw new RepositoryConfigurationException("Cannot resolve repository '" + repositoryName + "' in chain.");
                    }
                    repositoryConfigurationChain.add(repositoryConfiguration);
                }
                emptyRepository = ajc$this.repositoryFactory.createRepository(repositoryConfigurationChain);
            }
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return emptyRepository;
        }
        catch (Throwable throwable) {
            RepositoryFactoryBean.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private static final /* synthetic */ Object createRepository_aroundBody5$advice(RepositoryFactoryBean ajc$this, JoinPoint thisJoinPoint, AdditionalLoggingAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint) {
        Logger logger = AdditionalLoggingAspect.ajc$inlineAccessMethod$com_vmware_platform_tools_virgo_instrumentation_AdditionalLoggingAspect$com_vmware_platform_tools_virgo_instrumentation_AdditionalLoggingAspect$getLogger(ajc$aspectInstance, (JoinPoint)joinPoint);
        String signature = joinPoint.getSignature().toShortString();
        try {
            logger.error("~~~ Invoking " + signature);
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            Repository result = RepositoryFactoryBean.createRepository_aroundBody4(ajc$this, (JoinPoint)proceedingJoinPoint);
            logger.error("~~~ Invocation of " + signature + " complete. Returning " + result);
            return result;
        }
        catch (Throwable t) {
            logger.error("~~~ Invocation of " + signature + " failed", t);
            throw t;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RepositoryFactoryBean.java", RepositoryFactoryBean.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.eclipse.virgo.kernel.services.repository.internal.RepositoryFactoryBean", "java.util.Properties:org.eclipse.virgo.medic.eventlog.EventLogger:org.eclipse.virgo.repository.RepositoryFactory:java.io.File:java.util.Set:java.lang.String", "repositoryProperties:eventLogger:repositoryFactory:workDirectory:artifactBridges:mBeanDomain", ""), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "org.eclipse.virgo.kernel.services.repository.internal.RepositoryFactoryBean", "", "", "java.lang.Exception", "org.eclipse.virgo.repository.Repository"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSingleton", "org.eclipse.virgo.kernel.services.repository.internal.RepositoryFactoryBean", "", "", "", "boolean"), 71);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.eclipse.virgo.kernel.services.repository.internal.RepositoryFactoryBean", "", "", "", "void"), 75);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createRepository", "org.eclipse.virgo.kernel.services.repository.internal.RepositoryFactoryBean", "", "", "org.eclipse.virgo.repository.configuration.RepositoryConfigurationException:org.eclipse.virgo.repository.RepositoryCreationException", "org.eclipse.virgo.repository.Repository"), 83);
    }
}

