/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.help.signpost;

import com.vmware.vise.help.signpost.SignpostData;
import com.vmware.vise.help.signpost.SignpostResourceControler;
import com.vmware.vise.util.XMLUtil;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public enum SignpostManager {
    INSTANCE;

    private static final Log _logger;
    private static final String HELP_DIR = "help";
    private static final String SIGNPOST_DIR = "signpost";
    private static final String SIGNPOSTS_TAG = "signposts";
    private static final String SIGNPOSTS_LANG_ATTR = "lang";
    private static final String ID_ATTR = "id";
    private static final String TOPIC_ATTR = "moreinfo";
    private static final String PRODUCT_ATTR = "componentName";
    private static final String VERSION_ATTR = "componentVersion";
    private Map<Locale, Properties> _localeByProperties = new HashMap<Locale, Properties>();
    private Map<String, String> _keyByTopic = new HashMap<String, String>();
    private SignpostResourceControler _control = new SignpostResourceControler();

    Map<Locale, Properties> getLocaleProperties() {
        return this._localeByProperties;
    }

    Map<String, String> getKeyByTopic() {
        return this._keyByTopic;
    }

    public SignpostData getSignpostData(String string, Locale locale) {
        SignpostData signpostData = new SignpostData();
        signpostData.displayText = this.getSignPostDisplayText(string, locale);
        signpostData.helpContextId = this.getTopic(string);
        return signpostData;
    }

    private String getSignPostDisplayText(String string, Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("SignPost", locale, this._control);
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            _logger.info((Object)("Could not find display text for " + locale + " and key " + string), (Throwable)exception);
            return string;
        }
    }

    private String getTopic(String string) {
        return this._keyByTopic.get(string);
    }

    public void processSignPostsFromPackage(File file, boolean bl) throws Exception {
        if (file == null || !file.exists()) {
            return;
        }
        File file2 = this.getSignPostDir(file);
        if (!file2.exists() || !file2.isDirectory()) {
            return;
        }
        this.processSignPostFromDirectory(file2, bl);
    }

    private void processSignPostFromDirectory(File file, boolean bl) {
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                this.processSignPostFromDirectory(file2, bl);
                continue;
            }
            if (!file2.getName().endsWith(".xml")) continue;
            try {
                this.processSignpostXml(file2, bl);
            }
            catch (Exception exception) {
                _logger.debug((Object)"Error parsing xml", (Throwable)exception);
            }
        }
    }

    private void addSignPostProperties(Locale locale, Properties properties) {
        _logger.debug((Object)("Adding signpost properties for " + locale));
        Properties properties2 = this._localeByProperties.get(locale);
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.putAll((Map<?, ?>)properties);
        this._localeByProperties.put(locale, properties2);
    }

    private void removeSignPostProperties(Locale locale, Properties properties) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        Properties properties2 = this._localeByProperties.get(locale);
        if (properties2 == null || properties2.size() == 0) {
            return;
        }
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            properties2.remove(iterator.next());
        }
    }

    private void processSignpostXml(File file, boolean bl) throws Exception {
        _logger.debug((Object)("Loading signpost xml " + file));
        Document document = XMLUtil.loadXmlFile((URL)file.toURI().toURL());
        NodeList nodeList = document.getElementsByTagName(SIGNPOSTS_TAG);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = this.getAttributeValue(namedNodeMap, SIGNPOSTS_LANG_ATTR);
            String string2 = this.getAttributeValue(namedNodeMap, PRODUCT_ATTR);
            String string3 = this.getAttributeValue(namedNodeMap, VERSION_ATTR);
            Locale locale = StringUtils.parseLocaleString((String)string);
            _logger.debug((Object)("Signposts for locale " + locale));
            NodeList nodeList2 = node.getChildNodes();
            Properties properties = this.getNodeProperties(nodeList2, string2, string3, bl);
            _logger.debug((Object)("Signpost length : " + nodeList2.getLength()));
            if (bl) {
                this.addSignPostProperties(locale, properties);
                continue;
            }
            this.removeSignPostProperties(locale, properties);
        }
    }

    private Properties getNodeProperties(NodeList nodeList, String string, String string2, boolean bl) {
        Properties properties = new Properties();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            _logger.debug((Object)(i + " Signpost " + node.getTextContent()));
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string3 = this.getAttributeValue(namedNodeMap, ID_ATTR);
            String string4 = string + "." + string3 + "." + string2;
            StringBuffer stringBuffer = new StringBuffer();
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                stringBuffer.append(this.getNodetoXml(nodeList2.item(j)));
            }
            String string5 = stringBuffer.toString();
            _logger.debug((Object)(string4 + " Sign post text value " + string5));
            properties.put(string4, string5);
            String string6 = this.getAttributeValue(namedNodeMap, TOPIC_ATTR);
            if (string6 == null) continue;
            _logger.debug((Object)(string4 + "Topic is " + string6));
            if (bl) {
                this._keyByTopic.put(string4, string6);
                continue;
            }
            this._keyByTopic.remove(string4);
        }
        return properties;
    }

    private String getAttributeValue(NamedNodeMap namedNodeMap, String string) {
        if (namedNodeMap == null || string == null) {
            return null;
        }
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return null;
        }
        String string2 = node.getNodeValue();
        return string2;
    }

    private String getNodetoXml(Node node) {
        if (node == null) {
            return "";
        }
        if (node.getNodeType() == 3) {
            return node.getTextContent();
        }
        if (node.getNodeType() == 2) {
            return node.getNodeName() + "=" + node.getNodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (node.getNodeType() == 1) {
            int n;
            Object object;
            stringBuffer.append("<").append(node.getNodeName());
            if (node.hasAttributes()) {
                object = node.getAttributes();
                for (n = 0; n < object.getLength(); ++n) {
                    stringBuffer.append(" ").append(object.item(n));
                }
            }
            if (node.hasChildNodes()) {
                stringBuffer.append(">");
                object = node.getChildNodes();
                for (n = 0; n < object.getLength(); ++n) {
                    stringBuffer.append(this.getNodetoXml(object.item(n)));
                }
                stringBuffer.append("</" + node.getNodeName() + ">");
            } else {
                stringBuffer.append("/>");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private File getSignPostDir(File file) {
        File file2 = new File(file, HELP_DIR);
        file2 = new File(file2, SIGNPOST_DIR);
        return file2;
    }

    static {
        _logger = LogFactory.getLog(SignpostManager.class);
    }
}

