/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.impl;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.util.Constants;
import com.vmware.opsmgmt.client.advperfcharts.util.FaultToleranceInfoCollector;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterCollector;
import com.vmware.opsmgmt.client.advperfcharts.util.builder.TotalFTPerformanceCounter;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceCountersPropertyProvider
implements PropertyProviderBean {
    private static final String GROUP_ID_RESCPU = "rescpu";
    private static final String GROUP_ID_DISK = "disk";
    private static final String[] NOT_USED_KEY_NAMES = new String[]{"used", "provisioned", "unshared"};
    private static final Log _logger = LogFactory.getLog(PerformanceCountersPropertyProvider.class);
    private final DataService _dataService;

    public PerformanceCountersPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="Datacenter,ResourcePool,ClusterComputeResource,HostSystem,VirtualMachine,VirtualApp")
    public PerformanceCounter[] getAvailablePerformanceCounters(ManagedObjectReference managedObjectReference, PerformanceInfoQuerySpec performanceInfoQuerySpec) throws Exception {
        Object object3;
        List<PerformanceCounter> list;
        Object object2;
        ManagedObjectReference managedObjectReference2;
        _logger.info((Object)("Performance counters requested for object " + managedObjectReference));
        PerformanceCounterCollector performanceCounterCollector = new PerformanceCounterCollector(managedObjectReference, this._dataService);
        List<PerformanceCounter> list2 = performanceCounterCollector.getAvailableCountersSorted();
        if (Constants.TYPE_VM.equals(managedObjectReference.getType()) && (managedObjectReference2 = ((FaultToleranceInfoCollector)(object2 = new FaultToleranceInfoCollector(this._dataService, managedObjectReference))).getSecondaryVmRef()) != null && (list = ((PerformanceCounterCollector)(object3 = new PerformanceCounterCollector(managedObjectReference2, this._dataService))).getAvailableCountersSorted()) != null) {
            TotalFTPerformanceCounter totalFTPerformanceCounter = new TotalFTPerformanceCounter();
            List<PerformanceCounter> list3 = totalFTPerformanceCounter.buildTotalCounters(list2, list);
            list2.addAll(list);
            list2.addAll(list3);
        }
        object2 = new ArrayList();
        for (Object object3 : list2) {
            if (!this.isMeaningfulForUser((PerformanceCounter)((Object)object3))) continue;
            object2.add(object3);
        }
        return object2.toArray(new PerformanceCounter[0]);
    }

    private boolean isMeaningfulForUser(PerformanceCounter performanceCounter) {
        if (GROUP_ID_RESCPU.equals(performanceCounter.groupId)) {
            return false;
        }
        return !GROUP_ID_DISK.equals(performanceCounter.groupId) || !Arrays.asList(NOT_USED_KEY_NAMES).contains(performanceCounter.nameKey);
    }
}

