/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.util.Constants;
import com.vmware.opsmgmt.client.advperfcharts.util.FaultToleranceInfoCollector;
import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.FileSystemVolume;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vim.binding.vim.host.VvolVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceMetricIdInfoCollector {
    private static final Log _logger = LogFactory.getLog(PerformanceMetricIdInfoCollector.class);
    private final String GROUP_KEY_SYS = "sys";
    private final String NAME_KEY_UPTIME = "uptime";
    private final String STATS_UNIT_KEY_DAYS = "days";
    private final String GROUP_KEY_DATASTORE = "datastore";
    private final String GROUP_KEY_DISK = "disk";
    private final String GROUP_KEY_STORAGE_PATH = "storagePath";
    private final String HOST_RELATION = "host";
    private final String STORAGE_DEVICE_INFO = "storageDeviceInfo";
    private final String FILE_SYSTEM_MOUNT_INFO = "fileSystemMountInfo";
    private final String NAME_PROPERTY = "name";
    private static final String STORAGE_PATH_FORMAT = "%S:C%S:T%S:L%S";
    private static final String RESOURCE_BUNDLE_NAME = "AdvPerfCharts";
    private static final String STATS_UNIT_NAME_PREFIX = "statsunit.name.";
    private static final String STATS_UNIT_DESC_PREFIX = "statsunit.description.";
    private static final String SECONDARY_NAME_FORMAT = "vm.ft.secondary.format";
    private List<PerformanceCounter> _counters = new ArrayList<PerformanceCounter>();
    private ManagedObjectReference _moRef;
    private DataService _dataService;
    private PerformanceMetricTimeIntervals _interval;
    private boolean _isSecondaryFtVm = false;
    private static StorageDeviceInfo _storageDeviceInfo;
    private static FileSystemMountInfo[] _fileSystemMountInfoArr;
    private static ManagedObjectReference _hostRef;
    private static String _moName;

    public PerformanceMetricIdInfoCollector(ManagedObjectReference managedObjectReference, PerformanceManager performanceManager, DataService dataService, PerformanceManager.MetricId[] metricIdArray, PerformanceMetricTimeIntervals performanceMetricTimeIntervals) {
        this(managedObjectReference, dataService);
        this._interval = performanceMetricTimeIntervals;
        int[] nArray = new int[metricIdArray.length];
        for (int i = 0; i < metricIdArray.length; ++i) {
            nArray[i] = metricIdArray[i].counterId;
        }
        _logger.debug((Object)("Calling PerformanceManager.queryCounter(" + Arrays.toString(nArray) + ")"));
        PerformanceManager.CounterInfo[] counterInfoArray = performanceManager.queryCounter(nArray);
        for (int i = 0; i < counterInfoArray.length; ++i) {
            PerformanceCounter performanceCounter = this.createPerformanceCounter(counterInfoArray[i], metricIdArray[i], this._interval);
            this._counters.add(performanceCounter);
        }
    }

    public PerformanceMetricIdInfoCollector(ManagedObjectReference managedObjectReference, PerformanceManager performanceManager, DataService dataService, int n, ManagedObjectReference managedObjectReference2) {
        String string;
        _logger.debug((Object)("Calling PerformanceManager.queryCounter([" + n + "])"));
        PerformanceManager.CounterInfo[] counterInfoArray = performanceManager.queryCounter(new int[]{n});
        PerformanceManager.CounterInfo counterInfo = counterInfoArray[0];
        PerformanceCounter performanceCounter = this.createPerformanceCounter(counterInfo, null, null);
        try {
            string = (String)QueryUtil.getProperty((DataService)dataService, (Object)managedObjectReference2, (String)"name");
        }
        catch (Exception exception) {
            string = managedObjectReference2.getValue();
        }
        performanceCounter.relatedDeviceId = string;
        performanceCounter.relatedDeviceName = string;
        this._counters.add(performanceCounter);
    }

    private PerformanceMetricIdInfoCollector(ManagedObjectReference managedObjectReference, DataService dataService) {
        this._moRef = managedObjectReference;
        this._dataService = dataService;
        _storageDeviceInfo = null;
        _fileSystemMountInfoArr = null;
        _hostRef = null;
        _moName = null;
        if (Constants.TYPE_VM.equals(managedObjectReference.getType())) {
            FaultToleranceInfoCollector faultToleranceInfoCollector = new FaultToleranceInfoCollector(dataService, managedObjectReference);
            this._isSecondaryFtVm = faultToleranceInfoCollector.isSecondaryVm();
        }
        this._counters = new ArrayList<PerformanceCounter>();
    }

    private ManagedObjectReference getHostRef() throws Exception {
        if (_hostRef != null) {
            return _hostRef;
        }
        if (Constants.TYPE_HOST.equals(this._moRef.getType())) {
            _hostRef = this._moRef;
            return _hostRef;
        }
        if (Constants.TYPE_VM.equals(this._moRef.getType()) && _hostRef == null) {
            _hostRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)this._moRef, (String)"host");
            return _hostRef;
        }
        return null;
    }

    public List<PerformanceCounter> getPerformanceCounters() {
        return this._counters;
    }

    private PerformanceCounter createPerformanceCounter(PerformanceManager.CounterInfo counterInfo, PerformanceManager.MetricId metricId, PerformanceMetricTimeIntervals performanceMetricTimeIntervals) {
        PerformanceCounter performanceCounter = new PerformanceCounter();
        performanceCounter.interval = this._interval;
        performanceCounter.id = counterInfo.getKey();
        this.populateNameAndGroupInfo(performanceCounter, counterInfo);
        this.populateStatsUnitInfo(performanceCounter, counterInfo);
        performanceCounter.rollupType = counterInfo.getRollupType().name();
        performanceCounter.statsType = counterInfo.getStatsType().name();
        performanceCounter.metricId = metricId;
        performanceCounter.isForSecondaryFtVm = this._isSecondaryFtVm;
        if (metricId != null) {
            performanceCounter.relatedDeviceId = metricId.getInstance();
            try {
                performanceCounter.relatedDeviceName = this.getInstanceName(performanceCounter);
            }
            catch (Exception exception) {
                performanceCounter.relatedDeviceName = performanceCounter.relatedDeviceId;
            }
        }
        return performanceCounter;
    }

    private void populateNameAndGroupInfo(PerformanceCounter performanceCounter, PerformanceManager.CounterInfo counterInfo) {
        ElementDescription elementDescription = counterInfo.getNameInfo();
        performanceCounter.name = elementDescription.getLabel();
        performanceCounter.nameKey = elementDescription.getKey();
        performanceCounter.description = elementDescription.getSummary();
        ElementDescription elementDescription2 = counterInfo.getGroupInfo();
        performanceCounter.groupId = elementDescription2.getKey();
        performanceCounter.groupName = elementDescription2.getLabel();
        performanceCounter.groupDescription = elementDescription2.getSummary();
        performanceCounter.isUptime = this.isUptimeCounter(performanceCounter);
    }

    private boolean isUptimeCounter(PerformanceCounter performanceCounter) {
        return "sys".equals(performanceCounter.groupId) && "uptime".equals(performanceCounter.nameKey);
    }

    private void populateStatsUnitInfo(PerformanceCounter performanceCounter, PerformanceManager.CounterInfo counterInfo) {
        ElementDescription elementDescription = counterInfo.getUnitInfo();
        if (performanceCounter.isUptime) {
            performanceCounter.statsUnitKey = "days";
            performanceCounter.statsUnitName = ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)"statsunit.name.days", (ClassLoader)this.getClass().getClassLoader());
            performanceCounter.statsUnitDescription = ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)"statsunit.description.days", (ClassLoader)this.getClass().getClassLoader());
        } else {
            performanceCounter.statsUnitKey = elementDescription.getKey();
            performanceCounter.statsUnitName = elementDescription.getLabel();
            performanceCounter.statsUnitDescription = elementDescription.getSummary();
        }
    }

    private String getInstanceName(PerformanceCounter performanceCounter) throws Exception {
        String string = performanceCounter.relatedDeviceId;
        if ("".equals(performanceCounter.relatedDeviceId)) {
            if (_moName == null) {
                _moName = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)this._moRef, (String)"name");
            }
            string = _moName;
        } else if (Constants.TYPE_HOST.equals(this._moRef.getType()) || Constants.TYPE_VM.equals(this._moRef.getType())) {
            if (performanceCounter.groupId.equals("disk")) {
                string = this.getLUNName(performanceCounter.relatedDeviceId);
            } else if (performanceCounter.groupId.equals("storagePath")) {
                string = this.getStoragePathName(performanceCounter.relatedDeviceId);
            } else if (performanceCounter.groupId.equals("datastore")) {
                string = this.getVolumeName(performanceCounter.relatedDeviceId);
            }
        }
        if (this._isSecondaryFtVm) {
            String string2 = ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)SECONDARY_NAME_FORMAT, (ClassLoader)this.getClass().getClassLoader());
            string = String.format(string2, string);
        }
        return string;
    }

    private String getVolumeName(String string) throws Exception {
        if (_fileSystemMountInfoArr == null) {
            _fileSystemMountInfoArr = (FileSystemMountInfo[])QueryUtil.getProperty((DataService)this._dataService, (Object)this.getHostRef(), (String)"fileSystemMountInfo");
        }
        for (FileSystemMountInfo fileSystemMountInfo : _fileSystemMountInfoArr) {
            String string2;
            int n;
            Object object;
            if (fileSystemMountInfo.volume instanceof VmfsVolume && string.indexOf((object = (VmfsVolume)fileSystemMountInfo.volume).getUuid()) > -1) {
                return object.getName();
            }
            if (fileSystemMountInfo.volume instanceof VvolVolume) {
                object = (VvolVolume)fileSystemMountInfo.volume;
                if (((VvolVolume)object).scId.replace("-", "").indexOf(string.replace("-", "")) > -1) {
                    return ((VvolVolume)object).name;
                }
            }
            if (!(fileSystemMountInfo.volume instanceof FileSystemVolume) || (n = ((String)(object = fileSystemMountInfo.mountInfo.path)).lastIndexOf(47)) <= -1 || string.indexOf(string2 = ((String)object).substring(n + 1)) <= -1) continue;
            return fileSystemMountInfo.volume.name;
        }
        return string;
    }

    private String getStoragePathName(String string) throws Exception {
        if (_storageDeviceInfo == null) {
            _storageDeviceInfo = (StorageDeviceInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)this.getHostRef(), (String)"storageDeviceInfo");
        }
        for (PlugStoreTopology.Path path : PerformanceMetricIdInfoCollector._storageDeviceInfo.plugStoreTopology.path) {
            if (!string.equals(path.name)) continue;
            return String.format(STORAGE_PATH_FORMAT, path.adapter, path.channelNumber, path.targetNumber, path.lunNumber);
        }
        return string;
    }

    private String getLUNName(String string) throws Exception {
        if (_storageDeviceInfo == null) {
            _storageDeviceInfo = (StorageDeviceInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)this.getHostRef(), (String)"storageDeviceInfo");
        }
        for (ScsiLun scsiLun : PerformanceMetricIdInfoCollector._storageDeviceInfo.scsiLun) {
            if (!string.equals(scsiLun.canonicalName)) continue;
            return scsiLun.deviceName;
        }
        return null;
    }

    static {
        _hostRef = null;
        _moName = null;
    }
}

