/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.util.BasePerformanceStats;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceStats
extends BasePerformanceStats {
    private static final Log _logger = LogFactory.getLog(PerformanceStats.class);

    public PerformanceStats(ManagedObjectReference managedObjectReference, DataService dataService, PerformanceInfoQuerySpec performanceInfoQuerySpec) throws Exception {
        super(managedObjectReference, dataService, performanceInfoQuerySpec);
    }

    @Override
    protected PerformanceManager.QuerySpec prepareQuerySpec() {
        PerformanceManager.QuerySpec querySpec = this.initBaseQuerySpec();
        ArrayList<PerformanceManager.MetricId> arrayList = new ArrayList<PerformanceManager.MetricId>();
        if (this.hasMetricIdsItems()) {
            arrayList.addAll(Arrays.asList(this.originalParams.metricIds));
        }
        if (this.hasCoutnerIdsItems() && this.hasRelatedDeviceIdsItems()) {
            List<PerformanceManager.MetricId> list = this.getAvailableMetricIds(this.originalParams.counterIds, this.originalParams.relatedDeviceIds, this.originalParams.interval);
            arrayList.addAll(list);
        }
        querySpec.metricId = arrayList.toArray(new PerformanceManager.MetricId[0]);
        return querySpec;
    }

    @Override
    protected List<PerformanceCounterStats> executeQuery(PerformanceManager.QuerySpec querySpec) {
        ArrayList<PerformanceCounterStats> arrayList = new ArrayList<PerformanceCounterStats>();
        if (querySpec.metricId.length == 0) {
            return arrayList;
        }
        _logger.debug((Object)("Calling PerfomanceManager.queryStats([" + querySpec + "])"));
        PerformanceManager.EntityMetricBase[] entityMetricBaseArray = this.perfManager.queryStats(new PerformanceManager.QuerySpec[]{querySpec});
        if (entityMetricBaseArray == null) {
            return arrayList;
        }
        for (PerformanceManager.EntityMetricBase entityMetricBase : entityMetricBaseArray) {
            PerformanceManager.EntityMetric entityMetric = (PerformanceManager.EntityMetric)entityMetricBase;
            PerformanceManager.SampleInfo[] sampleInfoArray = entityMetric.getSampleInfo();
            if (entityMetric == null || entityMetric.getValue() == null) continue;
            for (PerformanceManager.MetricSeries metricSeries : entityMetric.getValue()) {
                PerformanceCounterStats performanceCounterStats = new PerformanceCounterStats();
                performanceCounterStats.performanceCounter = this.findCounterInfo(metricSeries.getId());
                performanceCounterStats.statistics = this.createPerfMetricStatsValues(sampleInfoArray, (PerformanceManager.IntSeries)metricSeries, performanceCounterStats.performanceCounter.statsUnitKey, performanceCounterStats.performanceCounter.isUptime);
                arrayList.add(performanceCounterStats);
            }
        }
        return arrayList;
    }
}

