/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.ChartTypes;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricStatValue;
import com.vmware.opsmgmt.client.advperfcharts.util.BasePerformanceStats;
import com.vmware.opsmgmt.client.advperfcharts.util.CompositePerformanceStats;
import com.vmware.opsmgmt.client.advperfcharts.util.Constants;
import com.vmware.opsmgmt.client.advperfcharts.util.FaultToleranceInfoCollector;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceStats;
import com.vmware.opsmgmt.client.advperfcharts.util.builder.PerformanceMetricStatValueBuilder;
import com.vmware.opsmgmt.client.advperfcharts.util.builder.TotalFTPerformanceCounter;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PerformanceStatsCollector {
    private BasePerformanceStats _stats;
    private BasePerformanceStats _secondaryVmStats;
    PerformanceInfoQuerySpec _params;

    public PerformanceStatsCollector(ManagedObjectReference managedObjectReference, DataService dataService, PerformanceInfoQuerySpec performanceInfoQuerySpec) throws Exception {
        this._params = performanceInfoQuerySpec;
        if (performanceInfoQuerySpec.chartType == ChartTypes.STACKED_GRAPH_PER_VM) {
            this._stats = new CompositePerformanceStats(managedObjectReference, dataService, performanceInfoQuerySpec);
        } else {
            FaultToleranceInfoCollector faultToleranceInfoCollector;
            ManagedObjectReference managedObjectReference2;
            this._stats = new PerformanceStats(managedObjectReference, dataService, performanceInfoQuerySpec);
            if (Constants.TYPE_VM.equals(managedObjectReference.getType()) && (managedObjectReference2 = (faultToleranceInfoCollector = new FaultToleranceInfoCollector(dataService, managedObjectReference)).getSecondaryVmRef()) != null) {
                PerformanceInfoQuerySpec performanceInfoQuerySpec2 = this.switchDevices(performanceInfoQuerySpec);
                this._secondaryVmStats = new PerformanceStats(managedObjectReference2, dataService, performanceInfoQuerySpec2);
            }
        }
    }

    public List<PerformanceCounterStats> getStats() throws Exception {
        ArrayList<PerformanceCounterStats> arrayList = new ArrayList<PerformanceCounterStats>();
        List<PerformanceCounterStats> list = this._stats.getStats();
        arrayList.addAll(this.filterStats(list, this._params.relatedDeviceIds));
        if (this._secondaryVmStats != null) {
            List<PerformanceCounterStats> list2 = this._secondaryVmStats.getStats();
            arrayList.addAll(this.filterStats(list2, this._params.relatedToSecFtVmDeviceIds));
            if (this._params.relatedDeviceIds.contains("total_device_id")) {
                for (int n : this._params.counterIds) {
                    PerformanceCounterStats performanceCounterStats = this.calculateSummaryStatsForCounterId(n, list, list2);
                    if (performanceCounterStats == null) continue;
                    arrayList.add(performanceCounterStats);
                }
            }
        }
        return arrayList;
    }

    private PerformanceInfoQuerySpec switchDevices(PerformanceInfoQuerySpec performanceInfoQuerySpec) {
        PerformanceInfoQuerySpec performanceInfoQuerySpec2 = new PerformanceInfoQuerySpec();
        performanceInfoQuerySpec2.interval = performanceInfoQuerySpec.interval;
        if (performanceInfoQuerySpec.startDate != null) {
            performanceInfoQuerySpec2.startDate = (Date)performanceInfoQuerySpec.startDate.clone();
        }
        if (performanceInfoQuerySpec.endDate != null) {
            performanceInfoQuerySpec2.endDate = (Date)performanceInfoQuerySpec.endDate.clone();
        }
        performanceInfoQuerySpec2.customPeriodUnits = performanceInfoQuerySpec.customPeriodUnits;
        performanceInfoQuerySpec2.customPeriodUnitsCount = performanceInfoQuerySpec.customPeriodUnitsCount;
        if (performanceInfoQuerySpec.metricIds != null) {
            performanceInfoQuerySpec2.metricIds = (PerformanceManager.MetricId[])performanceInfoQuerySpec.metricIds.clone();
        }
        if (performanceInfoQuerySpec.relatedToSecFtVmDeviceIds != null) {
            performanceInfoQuerySpec2.relatedDeviceIds = new ArrayList<String>();
            performanceInfoQuerySpec2.relatedDeviceIds.addAll(performanceInfoQuerySpec.relatedToSecFtVmDeviceIds);
        }
        if (performanceInfoQuerySpec.relatedDeviceIds != null) {
            performanceInfoQuerySpec2.relatedToSecFtVmDeviceIds = new ArrayList<String>();
            performanceInfoQuerySpec2.relatedToSecFtVmDeviceIds.addAll(performanceInfoQuerySpec.relatedDeviceIds);
            if (performanceInfoQuerySpec.relatedDeviceIds.contains("total_device_id")) {
                performanceInfoQuerySpec2.relatedDeviceIds.add("total_device_id");
            }
        }
        if (performanceInfoQuerySpec.counterIds != null) {
            performanceInfoQuerySpec2.counterIds = new ArrayList<Integer>();
            performanceInfoQuerySpec2.counterIds.addAll(performanceInfoQuerySpec.counterIds);
        }
        performanceInfoQuerySpec2.chartType = performanceInfoQuerySpec.chartType;
        return performanceInfoQuerySpec2;
    }

    private PerformanceCounterStats calculateSummaryStatsForCounterId(int n, List<PerformanceCounterStats> list, List<PerformanceCounterStats> list2) {
        PerformanceCounterStats performanceCounterStats = this.getMOStatsByMetricId(n, list);
        PerformanceCounterStats performanceCounterStats2 = this.getMOStatsByMetricId(n, list2);
        if (performanceCounterStats == null || performanceCounterStats2 == null) {
            return null;
        }
        return this.buildSummaryStats(performanceCounterStats, performanceCounterStats2);
    }

    private PerformanceCounterStats getMOStatsByMetricId(int n, List<PerformanceCounterStats> list) {
        for (PerformanceCounterStats performanceCounterStats : list) {
            if (performanceCounterStats.performanceCounter.id != n || !"".equals(performanceCounterStats.performanceCounter.relatedDeviceId)) continue;
            return performanceCounterStats;
        }
        return null;
    }

    private PerformanceCounterStats buildSummaryStats(PerformanceCounterStats performanceCounterStats, PerformanceCounterStats performanceCounterStats2) {
        PerformanceCounterStats performanceCounterStats3 = new PerformanceCounterStats();
        TotalFTPerformanceCounter totalFTPerformanceCounter = new TotalFTPerformanceCounter();
        performanceCounterStats3.performanceCounter = totalFTPerformanceCounter.build(performanceCounterStats.performanceCounter);
        ArrayList<PerformanceMetricStatValue> arrayList = new ArrayList<PerformanceMetricStatValue>();
        for (int i = 0; i < performanceCounterStats.statistics.length; ++i) {
            boolean bl;
            PerformanceMetricStatValue performanceMetricStatValue = this.getValueByDate(performanceCounterStats.statistics[i].timestamp, performanceCounterStats2.statistics);
            float f = -1.0f;
            boolean bl2 = performanceCounterStats.statistics[i].value != -1.0f;
            boolean bl3 = bl = performanceMetricStatValue.value != -1.0f;
            if (bl2 && bl) {
                f = performanceCounterStats.statistics[i].value + performanceMetricStatValue.value;
            }
            PerformanceMetricStatValueBuilder performanceMetricStatValueBuilder = new PerformanceMetricStatValueBuilder();
            PerformanceMetricStatValue performanceMetricStatValue2 = performanceMetricStatValueBuilder.build(performanceCounterStats.statistics[i].timestamp, f);
            arrayList.add(performanceMetricStatValue2);
        }
        performanceCounterStats3.statistics = arrayList.toArray(new PerformanceMetricStatValue[0]);
        return performanceCounterStats3;
    }

    private PerformanceMetricStatValue getValueByDate(Date date, PerformanceMetricStatValue[] performanceMetricStatValueArray) {
        for (PerformanceMetricStatValue performanceMetricStatValue : performanceMetricStatValueArray) {
            if (!performanceMetricStatValue.timestamp.equals(date)) continue;
            return performanceMetricStatValue;
        }
        PerformanceMetricStatValueBuilder performanceMetricStatValueBuilder = new PerformanceMetricStatValueBuilder();
        return performanceMetricStatValueBuilder.buildEmptyStatValueForDate(date);
    }

    private List<PerformanceCounterStats> filterStats(List<PerformanceCounterStats> list, List<String> list2) {
        ArrayList<PerformanceCounterStats> arrayList = new ArrayList<PerformanceCounterStats>();
        for (PerformanceCounterStats performanceCounterStats : list) {
            if (!list2.contains(performanceCounterStats.performanceCounter.relatedDeviceId) && !list2.contains("*")) continue;
            arrayList.add(performanceCounterStats);
        }
        return arrayList;
    }
}

