/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.flex.core.io.AbstractAmfConversionServiceConfigProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSerializationConfigPostProcessor
implements BeanFactoryPostProcessor {
    private static final Log log = LogFactory.getLog(HibernateSerializationConfigPostProcessor.class);
    private static final String HIBERNATE_CONFIG_PROCESSOR_CLASS = "org.springframework.flex.core.io.HibernateConfigProcessor";
    private static final String JPA_HIBERNATE_CONFIG_PROCESSOR_CLASS = "org.springframework.flex.core.io.JpaHibernateConfigProcessor";
    private static final String MESSAGE_BROKER_FACTORY_BEAN_CLASS_NAME = "org.springframework.flex.core.MessageBrokerFactoryBean";
    private static final String CONFIG_PROCESSORS_PROPERTY = "configProcessors";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.isHibernateDetected(beanFactory.getBeanClassLoader())) {
            BeanDefinition messageBrokerBeanDef = this.findMessageBrokerFactoryBeanDefinition(beanFactory);
            Assert.notNull((Object)"Could not find an appropriate bean definition for MessageBrokerBeanDefinitionFactoryBean.");
            MutablePropertyValues brokerProps = messageBrokerBeanDef.getPropertyValues();
            ManagedSet configProcessors = brokerProps.getPropertyValue(CONFIG_PROCESSORS_PROPERTY) != null ? (ManagedSet)brokerProps.getPropertyValue(CONFIG_PROCESSORS_PROPERTY).getValue() : new ManagedSet();
            if (this.isAmfConversionServiceProcessorConfigured(beanFactory, (ManagedSet<RuntimeBeanReference>)configProcessors)) {
                return;
            }
            if (!ClassUtils.isAssignableValue(BeanDefinitionRegistry.class, (Object)beanFactory) && log.isWarnEnabled()) {
                log.warn((Object)"Hibernate AMF serialization support could not be auto-configured because the current BeanFactory does not implement BeanDefinitionRegistry.  In order for this support to be enabled, you must manually configure an instance of org.springframework.flex.core.io.HibernateConfigProcessor");
            }
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            BeanDefinitionBuilder processorBuilder = this.isJpaDetected(beanFactory.getBeanClassLoader()) ? BeanDefinitionBuilder.rootBeanDefinition((String)JPA_HIBERNATE_CONFIG_PROCESSOR_CLASS) : BeanDefinitionBuilder.rootBeanDefinition((String)HIBERNATE_CONFIG_PROCESSOR_CLASS);
            String processorId = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)processorBuilder.getBeanDefinition(), (BeanDefinitionRegistry)registry);
            configProcessors.add((Object)new RuntimeBeanReference(processorId));
        }
    }

    private boolean isAmfConversionServiceProcessorConfigured(ConfigurableListableBeanFactory beanFactory, ManagedSet<RuntimeBeanReference> configProcessors) {
        for (RuntimeBeanReference configProcessor : configProcessors) {
            BeanDefinition bd = beanFactory.getMergedBeanDefinition(configProcessor.getBeanName());
            if (!(bd instanceof AbstractBeanDefinition)) continue;
            AbstractBeanDefinition abd = (AbstractBeanDefinition)bd;
            if (!abd.hasBeanClass()) {
                try {
                    abd.resolveBeanClass(beanFactory.getBeanClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    throw new CannotLoadBeanClassException(abd.getResourceDescription(), configProcessor.getBeanName(), abd.getBeanClassName(), ex);
                }
            }
            if (!AbstractAmfConversionServiceConfigProcessor.class.isAssignableFrom(abd.getBeanClass())) continue;
            return true;
        }
        return false;
    }

    private BeanDefinition findMessageBrokerFactoryBeanDefinition(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory.containsBeanDefinition("_messageBroker")) {
            return beanFactory.getBeanDefinition("_messageBroker");
        }
        for (String beanDefName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanDefName);
            if (!beanDef.getBeanClassName().equals(MESSAGE_BROKER_FACTORY_BEAN_CLASS_NAME)) continue;
            return beanDef;
        }
        return null;
    }

    private boolean isHibernateDetected(ClassLoader classLoader) {
        return ClassUtils.isPresent((String)"org.hibernate.SessionFactory", (ClassLoader)classLoader);
    }

    private boolean isJpaDetected(ClassLoader classLoader) {
        return ClassUtils.isPresent((String)"javax.persistence.EntityManagerFactory", (ClassLoader)classLoader);
    }
}

