/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core.io;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.flex.core.io.AmfCreator;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyProxyUtils {
    private static final Log log = LogFactory.getLog(PropertyProxyUtils.class);

    private PropertyProxyUtils() {
    }

    public static boolean hasAmfCreator(Class<?> beanType) {
        for (Constructor<?> constructor : beanType.getConstructors()) {
            if (constructor.getAnnotation(AmfCreator.class) == null) continue;
            return true;
        }
        return false;
    }

    public static PropertyAccessor getPropertyAccessor(ConversionService conversionService, boolean useDirectFieldAccess, Object instance) {
        Object accessor = null;
        accessor = useDirectFieldAccess ? PropertyAccessorFactory.forDirectFieldAccess((Object)instance) : PropertyAccessorFactory.forBeanPropertyAccess((Object)instance);
        accessor.setConversionService(conversionService);
        return accessor;
    }

    public static List<String> getFieldNames(Object instance) {
        final ArrayList<String> names = new ArrayList<String>();
        ReflectionUtils.doWithFields(instance.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                names.add(field.getName());
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)("Property names for " + instance + " : " + names));
        }
        return names;
    }

    public static List<String> getBeanPropertyNames(BeanWrapper beanWrapper) {
        ArrayList<String> names = new ArrayList<String>();
        for (PropertyDescriptor pd : beanWrapper.getPropertyDescriptors()) {
            if (pd.getName().equals("class")) continue;
            names.add(pd.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Property names for " + beanWrapper.getWrappedInstance() + " : " + names));
        }
        return names;
    }

    public static List<String> findPropertyNames(ConversionService conversionService, boolean useDirectFieldAccess, Object instance) {
        if (useDirectFieldAccess) {
            return PropertyProxyUtils.getFieldNames(instance);
        }
        return PropertyProxyUtils.getBeanPropertyNames((BeanWrapper)PropertyProxyUtils.getPropertyAccessor(conversionService, useDirectFieldAccess, instance));
    }
}

