/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.messaging;

import flex.messaging.Destination;
import flex.messaging.MessageBroker;
import flex.messaging.MessageDestination;
import flex.messaging.config.ConfigMap;
import flex.messaging.services.MessageService;
import flex.messaging.services.Service;
import org.springframework.flex.core.AbstractDestinationFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MessageDestinationFactory
extends AbstractDestinationFactory {
    private final ConfigMap properties;

    public MessageDestinationFactory() {
        this.properties = new ConfigMap();
    }

    public MessageDestinationFactory(ConfigMap properties) {
        this.properties = properties;
    }

    public ConfigMap getProperties() {
        return this.properties;
    }

    public void setAllowSubtopics(String allow) {
        this.getServerMap().addProperty("allow-subtopics", allow);
    }

    public void setClusterMessageRouting(String routingType) {
        this.getServerMap().addProperty("cluster-message-routing", routingType);
    }

    public void setClusterRef(String clusterRef) {
        this.getClusterMap().addProperty("ref", clusterRef);
    }

    public void setDisallowWildcardSubtopics(String disallow) {
        this.getServerMap().addProperty("disallow-wildcard-subtopics", disallow);
    }

    public void setMessageTimeToLive(String timeToLive) {
        this.getServerMap().addProperty("message-time-to-live", timeToLive);
    }

    public void setSendSecurityConstraint(String constraint) {
        ConfigMap constraintMap = new ConfigMap();
        constraintMap.addProperty("ref", constraint);
        this.getServerMap().addProperty("send-security-constraint", constraintMap);
    }

    public void setSubscribeSecurityConstraint(String constraint) {
        ConfigMap constraintMap = new ConfigMap();
        constraintMap.addProperty("ref", constraint);
        this.getServerMap().addProperty("subscribe-security-constraint", constraintMap);
    }

    public void setSubscriptionTimeoutMinutes(String timeout) {
        this.getNetworkMap().addProperty("subscription-timeout-minutes", timeout);
    }

    public void setSubtopicSeparator(String separator) {
        this.getServerMap().addProperty("subtopic-separator", separator);
    }

    public void setThrottleInboundMaxFrequency(String maxFrequency) {
        this.getThrottleInboundMap().addProperty("max-frequency", maxFrequency);
    }

    public void setThrottleInboundPolicy(String policy) {
        this.getThrottleInboundMap().addProperty("policy", policy);
    }

    public void setThrottleOutboundMaxFrequency(String maxFrequency) {
        this.getThrottleOutboundMap().addProperty("max-frequency", maxFrequency);
    }

    public void setThrottleOutboundPolicy(String policy) {
        this.getThrottleOutboundMap().addProperty("policy", policy);
    }

    protected Destination createDestination(String destinationId, MessageBroker broker) throws Exception {
        MessageService messageService = (MessageService)broker.getServiceByType(MessageService.class.getName());
        Assert.notNull((Object)messageService, (String)"Could not find a proper MessageService in the Flex MessageBroker.");
        MessageDestination destination = (MessageDestination)messageService.createDestination(destinationId);
        return destination;
    }

    protected void destroyDestination(String destinationId, MessageBroker broker) {
        MessageService messageService = (MessageService)broker.getServiceByType(MessageService.class.getName());
        if (messageService == null) {
            return;
        }
        messageService.removeDestination(destinationId);
    }

    protected Service getTargetService(MessageBroker broker) {
        return broker.getServiceByType(MessageService.class.getName());
    }

    protected void initializeDestination(Destination destination) {
        String adapterId;
        String string = adapterId = StringUtils.hasText((String)destination.getAdapter().getId()) ? destination.getAdapter().getId() : this.getDestinationId() + "Adapter";
        if (!this.getServerMap().containsKey((Object)"disallow-wildcard-subtopics")) {
            this.getServerMap().addProperty("disallow-wildcard-subtopics", "true");
        }
        destination.getAdapter().initialize(adapterId, this.getProperties());
        destination.initialize(this.getDestinationId(), this.getProperties());
        destination.start();
    }

    private ConfigMap getNetworkMap() {
        ConfigMap network = this.getProperties().getPropertyAsMap("network", null);
        if (network == null) {
            network = new ConfigMap();
            this.getProperties().addProperty("network", network);
        }
        return network;
    }

    private ConfigMap getServerMap() {
        ConfigMap server = this.getProperties().getPropertyAsMap("server", null);
        if (server == null) {
            server = new ConfigMap();
            this.getProperties().addProperty("server", server);
        }
        return server;
    }

    private ConfigMap getClusterMap() {
        ConfigMap cluster = this.getNetworkMap().getPropertyAsMap("cluster", null);
        if (cluster == null) {
            cluster = new ConfigMap();
            this.getNetworkMap().addProperty("cluster", cluster);
        }
        return cluster;
    }

    private ConfigMap getThrottleInboundMap() {
        ConfigMap throttleInbound = this.getNetworkMap().getPropertyAsMap("throttle-inbound", null);
        if (throttleInbound == null) {
            throttleInbound = new ConfigMap();
            this.getNetworkMap().addProperty("throttle-inbound", throttleInbound);
        }
        return throttleInbound;
    }

    private ConfigMap getThrottleOutboundMap() {
        ConfigMap throttleOutbound = this.getNetworkMap().getPropertyAsMap("throttle-outbound", null);
        if (throttleOutbound == null) {
            throttleOutbound = new ConfigMap();
            this.getNetworkMap().addProperty("throttle-outbound", throttleOutbound);
        }
        return throttleOutbound;
    }
}

