/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security3;

import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.flex.core.ExceptionTranslator;
import org.springframework.flex.security3.FlexAuthenticationEntryPoint;
import org.springframework.flex.security3.FlexSessionAwareSessionAuthenticationStrategy;
import org.springframework.flex.security3.SpringSecurityLoginCommand;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class SecurityConfigurationPostProcessor
implements MergedBeanDefinitionPostProcessor,
InitializingBean,
ApplicationContextAware {
    private SessionAuthenticationStrategy sessionAuthenticationStrategy;
    private RememberMeServices rememberMeServices;
    private FilterChainProxy filterChainProxy;
    private ApplicationContext context;

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class beanType, String beanName) {
        if (SpringSecurityLoginCommand.class.isAssignableFrom(beanType)) {
            boolean rememberMeServicesConfigured;
            MutablePropertyValues pv = beanDefinition.getPropertyValues();
            boolean bl = rememberMeServicesConfigured = pv.getPropertyValue("rememberMeServices") != null;
            if (this.sessionAuthenticationStrategy != null && pv.getPropertyValue("sessionAuthenticationStrategy") == null) {
                pv.add("sessionAuthenticationStrategy", (Object)this.sessionAuthenticationStrategy);
            }
            if (this.rememberMeServices != null && !rememberMeServicesConfigured) {
                pv.add("rememberMeServices", (Object)this.rememberMeServices);
            }
            if (pv.getPropertyValue("logoutHandlers") == null) {
                ManagedList handlers = new ManagedList();
                SecurityContextLogoutHandler contextHandler = new SecurityContextLogoutHandler();
                boolean invalidateHttpSession = (Boolean)beanDefinition.getAttribute("invalidateHttpSession");
                contextHandler.setInvalidateHttpSession(invalidateHttpSession);
                handlers.add((Object)contextHandler);
                if (this.rememberMeServices != null && !rememberMeServicesConfigured && ClassUtils.isAssignableValue(LogoutHandler.class, (Object)this.rememberMeServices)) {
                    handlers.add((Object)this.rememberMeServices);
                }
                pv.add("logoutHandlers", (Object)handlers);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Map exceptionTranslators;
        if (this.sessionAuthenticationStrategy != null) {
            this.sessionAuthenticationStrategy = new FlexSessionAwareSessionAuthenticationStrategy(this.sessionAuthenticationStrategy);
            HashSet allFilters = new HashSet(BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.context, Filter.class, (boolean)false, (boolean)false).values());
            if (this.filterChainProxy != null) {
                allFilters.addAll(new FilterChainAccessor(this.filterChainProxy).getFilters());
            }
            for (Filter filter : allFilters) {
                BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)filter);
                for (PropertyDescriptor pd : bw.getPropertyDescriptors()) {
                    if (!ClassUtils.isAssignableValue(pd.getPropertyType(), (Object)this.sessionAuthenticationStrategy) || !bw.isWritableProperty(pd.getName())) continue;
                    bw.setPropertyValue(pd.getName(), (Object)this.sessionAuthenticationStrategy);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Map)(exceptionTranslators = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.context, ExceptionTranslator.class)))) {
            Map entryPoints = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.context, FlexAuthenticationEntryPoint.class);
            for (FlexAuthenticationEntryPoint entryPoint : entryPoints.values()) {
                if (!CollectionUtils.isEmpty(entryPoint.getExceptionTranslators())) continue;
                entryPoint.setExceptionTranslators(new HashSet<ExceptionTranslator>(exceptionTranslators.values()));
            }
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setFilterChainProxy(FilterChainProxy filterChainProxy) {
        this.filterChainProxy = filterChainProxy;
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public void setSessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        this.sessionAuthenticationStrategy = sessionAuthenticationStrategy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilterChainAccessor {
        private final Set<Filter> filters = new LinkedHashSet<Filter>();

        public FilterChainAccessor(FilterChainProxy proxy) {
            for (List filters : proxy.getFilterChainMap().values()) {
                this.filters.addAll(filters);
            }
        }

        public Set<Filter> getFilters() {
            return this.filters;
        }
    }
}

