/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.certificate;

import com.sun.jna.Pointer;
import com.vmware.certificate.Request;
import com.vmware.certificate.VMCAAdapter;
import com.vmware.certificate.VMCAException;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.codec.binary.Base64;

public class Client
implements Iterable<X509Certificate> {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----\n";
    public static final String END_CERT = "\n-----END CERTIFICATE-----";
    private String ServerName;
    private certFilters enumFilter;

    public Client(String ServerName) {
        this.setServerName(ServerName);
        this.setEnumFilter(certFilters.ACTIVE_CERTIFICATES);
    }

    public static X509Certificate getCertificateFromString(String certificateString) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(certificateString.getBytes());
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509Certificate c = (X509Certificate)cf.generateCertificate(is);
        return c;
    }

    private String encodeX509CertificatesToString(X509Certificate[] certs) throws Exception {
        if (certs == null || certs.length == 0) {
            return null;
        }
        int stringBuilderSize = certs.length * 1024;
        StringBuilder sb = new StringBuilder(stringBuilderSize);
        for (X509Certificate cert : certs) {
            String pem = this.getEncodedStringFromCertificate(cert);
            sb.append(pem);
            sb.append('\n');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String getEncodedStringFromCertificate(X509Certificate certificate) throws Exception {
        if (certificate == null) {
            throw new IllegalStateException("Invalid Certificate, certificate cannot be null");
        }
        String encoded = new String(Base64.encodeBase64((byte[])certificate.getEncoded()));
        StringBuffer pemencode = new StringBuffer();
        for (int x = 0; x < encoded.length(); ++x) {
            if (x > 0 && x % 64 == 0) {
                pemencode.append("\n");
                pemencode.append(encoded.charAt(x));
                continue;
            }
            pemencode.append(encoded.charAt(x));
        }
        return BEGIN_CERT + pemencode.toString() + END_CERT;
    }

    public X509Certificate[] getRootCertificates() throws Exception {
        ArrayList<X509Certificate> trustedRoots = new ArrayList<X509Certificate>();
        trustedRoots.add(Client.getCertificateFromString(VMCAAdapter.GetRootCertificate(this.ServerName)));
        return trustedRoots.toArray(new X509Certificate[trustedRoots.size()]);
    }

    public void addRootCertificate(X509Certificate[] certificateChain, PrivateKey key) throws Exception {
        VMCAAdapter.AddRootCertificate(this.ServerName, this.encodeX509CertificatesToString(certificateChain), this.encodePrivateKeyToString(key));
    }

    public X509Certificate getRootCertificate() throws Exception {
        return Client.getCertificateFromString(VMCAAdapter.GetRootCertificate(this.ServerName));
    }

    public X509Certificate getCertificate(String certificateRequest, Date notBefore, Date notAfter) throws Exception {
        long epochNotBefore = notBefore.getTime();
        long epochNotAfter = notAfter.getTime();
        return Client.getCertificateFromString(VMCAAdapter.VMCAGetSignedCertificateFromCSR(this.ServerName, certificateRequest, epochNotBefore /= 1000L, epochNotAfter /= 1000L));
    }

    private String encodePrivateKeyToString(PrivateKey key) throws UnsupportedEncodingException {
        if (key == null) {
            return null;
        }
        byte[] privBytes = key.getEncoded();
        String encoded = new String(Base64.encodeBase64((byte[])privBytes));
        StringBuffer pemencode = new StringBuffer();
        for (int x = 0; x < encoded.length(); ++x) {
            if (x > 0 && x % 64 == 0) {
                pemencode.append("\n");
                pemencode.append(encoded.charAt(x));
                continue;
            }
            pemencode.append(encoded.charAt(x));
        }
        return "-----BEGIN PRIVATE KEY-----\n" + pemencode.toString() + "\n" + "-----END PRIVATE KEY-----";
    }

    private String getPEMEncodedKey(KeyPair Keys) {
        byte[] privBytes = Keys.getPrivate().getEncoded();
        String encoded = new String(Base64.encodeBase64((byte[])privBytes));
        StringBuffer pemencode = new StringBuffer();
        for (int x = 0; x < encoded.length(); ++x) {
            if (x > 0 && x % 64 == 0) {
                pemencode.append("\n");
                pemencode.append(encoded.charAt(x));
                continue;
            }
            pemencode.append(encoded.charAt(x));
        }
        return "-----BEGIN PRIVATE KEY-----\n" + pemencode.toString() + "\n" + "-----END PRIVATE KEY-----";
    }

    public X509Certificate getCertificate(Request req, KeyPair Keys, Date notBefore, Date notAfter) throws Exception {
        long epochNotBefore = notBefore.getTime();
        long epochNotAfter = notAfter.getTime();
        String certString = VMCAAdapter.VMCAJavaGenCert(this.getServerName(), req.getName(), req.getCountry(), req.getLocality(), req.getState(), req.getOrganization(), req.getOrgunit(), req.getDnsname(), req.getUri(), req.getEmail(), req.getIpaddress(), req.getKeyusage(), 0, this.getPEMEncodedKey(Keys), epochNotBefore /= 1000L, epochNotAfter /= 1000L);
        return Client.getCertificateFromString(certString);
    }

    public void RevokeCertificate(X509Certificate certificate) throws Exception {
        VMCAAdapter.RevokeCertificate(this.ServerName, this.getEncodedStringFromCertificate(certificate));
    }

    public String getServerName() {
        return this.ServerName;
    }

    public String getServerVersion() throws Exception {
        return VMCAAdapter.getServerVersion(this.ServerName);
    }

    public void setServerName(String serverName) {
        this.ServerName = serverName;
    }

    @Override
    public Iterator<X509Certificate> iterator() {
        return new VMCACertIterator(this.ServerName, Client.filterToInteger(this.getEnumFilter()));
    }

    public certFilters getEnumFilter() {
        return this.enumFilter;
    }

    public void setEnumFilter(certFilters enumFilter) {
        this.enumFilter = enumFilter;
    }

    private static int filterToInteger(certFilters filter) {
        switch (filter) {
            case ACTIVE_CERTIFICATES: {
                return 0;
            }
            case REVOKED_CERTIFICATES: {
                return 1;
            }
            case EXPIRED_CERTIFICATES: {
                return 2;
            }
            case ALL_CERTIFICATES: {
                return 4;
            }
        }
        return 0;
    }

    public void getCRL(String existingCRL, String string) throws VMCAException {
        String returnedCRL = VMCAAdapter.VMCAGetCRL(this.getServerName(), existingCRL, string);
    }

    public void PublishRoots() throws VMCAException, Exception {
        VMCAAdapter.VMCAPublishRoots(this.getServerName());
    }

    private class VMCACertIterator
    implements Iterator<X509Certificate> {
        private Pointer ctx;
        private String nextCert;
        private int certFilter;

        public VMCACertIterator(String serverName, int certFilter) {
            try {
                this.certFilter = certFilter;
                this.ctx = VMCAAdapter.VMCAOpenEnumContext(serverName, this.certFilter);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        @Override
        public boolean hasNext() {
            block4: {
                try {
                    if (this.ctx != null) {
                        this.nextCert = VMCAAdapter.VMCAGetNextCertificate(this.ctx);
                        if (this.nextCert != null) {
                            return true;
                        }
                        VMCAAdapter.VMCACloseEnumContext(this.ctx);
                        this.ctx = null;
                    }
                }
                catch (Exception e) {
                    if (this.ctx == null) break block4;
                    VMCAAdapter.VMCACloseEnumContext(this.ctx);
                    this.ctx = null;
                }
            }
            return false;
        }

        @Override
        public X509Certificate next() {
            try {
                return Client.getCertificateFromString(this.nextCert);
            }
            catch (Exception e) {
                throw new NoSuchElementException(e.getMessage());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("To Remove or Revoke a Certificate, Please use Revoke Certificate");
        }
    }

    public static enum certFilters {
        ACTIVE_CERTIFICATES,
        REVOKED_CERTIFICATES,
        EXPIRED_CERTIFICATES,
        ALL_CERTIFICATES;

    }
}

