/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.certificate;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;

public class Request {
    private static final int MIN_KEY_LENGTH = 1024;
    private static final String KEY_ALGORITHM_RSA = "RSA";
    private String name;
    private String country;
    private String locality = "";
    private String state = "";
    private String organization = "";
    private String orgunit = "";
    private String dnsname = "";
    private String uri = "";
    private String email = "";
    private String ipaddress = "";
    private Integer keyusage = 0;

    public KeyPair createKeyPair(Integer KeyLength) throws Exception {
        KeyPairGenerator keyGen = null;
        if (KeyLength < 1024) {
            throw new IllegalStateException(String.format("Minimum key length is %s bits", 1024));
        }
        try {
            keyGen = KeyPairGenerator.getInstance(KEY_ALGORITHM_RSA);
            keyGen.initialize(KeyLength, new SecureRandom());
            KeyPair keypair = keyGen.generateKeyPair();
            return keypair;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public X509Certificate getCertificate(String ServerName, KeyPair keys, Date tmNotBefore, Date tmNotAfter) throws Exception {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrgunit() {
        return this.orgunit;
    }

    public void setOrgunit(String orgunit) {
        this.orgunit = orgunit;
    }

    public String getDnsname() {
        return this.dnsname;
    }

    public void setDnsname(String dnsname) {
        this.dnsname = dnsname;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getIpaddress() {
        return this.ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public Integer getKeyusage() {
        return this.keyusage;
    }

    public void setKeyusage(Integer keyusage) {
        this.keyusage = keyusage;
    }
}

