/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.certificate;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.vmware.certificate.VMCAException;
import java.io.File;
import java.util.Date;

public final class VMCAAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServerVersion(String ServerName) throws VMCAException {
        String string;
        block4: {
            Pointer p = null;
            PointerByReference pServerVersion = new PointerByReference();
            try {
                int error = VMCA.INSTANCE.VMCAGetServerVersionA(ServerName, pServerVersion);
                VMCAAdapter.THROW_IF_NEEDED(error);
                p = pServerVersion.getValue();
                if (p == null) {
                    throw new IllegalStateException("Invalid server version found");
                }
                string = p.getString(0L);
                if (p == null) break block4;
                VMCA.INSTANCE.VMCAFreeVersion(p);
            }
            catch (Throwable throwable) {
                if (p != null) {
                    VMCA.INSTANCE.VMCAFreeVersion(p);
                }
                throw throwable;
            }
        }
        return string;
    }

    public static void AddRootCertificate(String ServerName, String Certificate2, String PrivateKey2) throws VMCAException {
        String PassPhrase = null;
        int error = VMCA.INSTANCE.VMCAAddRootCertificateA(ServerName, Certificate2, PassPhrase, PrivateKey2);
        VMCAAdapter.THROW_IF_NEEDED(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetRootCertificate(String ServerName) throws VMCAException {
        Pointer p = null;
        PointerByReference pCertificate = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCAGetRootCACertificateA(ServerName, pCertificate);
            VMCAAdapter.THROW_IF_NEEDED(error);
            p = pCertificate.getValue();
            if (p == null) {
                throw new IllegalStateException("Unable to get the Root CA Certificate");
            }
            String string = p.getString(0L);
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            throw throwable;
        }
    }

    public static void SetValue(int Oid, PointerByReference data, String Value) throws VMCAException {
        int error = VMCA.INSTANCE.VMCASetCertValueA(Oid, data.getPointer(), Value);
        VMCAAdapter.THROW_IF_NEEDED(error);
    }

    public static PointerByReference getPKCSData() throws VMCAException {
        PointerByReference pData = new PointerByReference();
        int error = VMCA.INSTANCE.VMCAAllocatePKCS10DataA(pData);
        VMCAAdapter.THROW_IF_NEEDED(error);
        return pData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetCSR(Pointer pData, String PrivateKey2) throws VMCAException {
        String string;
        block4: {
            Pointer p = null;
            PointerByReference pCSR = new PointerByReference();
            try {
                int error = VMCA.INSTANCE.VMCACreateSigningRequestA(pData, PrivateKey2, null, pCSR);
                VMCAAdapter.THROW_IF_NEEDED(error);
                p = pCSR.getValue();
                if (p == null) {
                    throw new IllegalStateException("Invalid CSR");
                }
                string = p.getString(0L);
                if (p == null) break block4;
                VMCA.INSTANCE.VMCAFreeCSR(p);
            }
            catch (Throwable throwable) {
                if (p != null) {
                    VMCA.INSTANCE.VMCAFreeCSR(p);
                }
                throw throwable;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetCertificate(String ServerName, Pointer Data, String PrivateKey2, Date notBefore, Date notAfter) throws VMCAException {
        Pointer p = null;
        PointerByReference pCertificate = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCAGetSignedCertificateA(ServerName, Data, PrivateKey2, null, notBefore.getTime(), notAfter.getTime(), pCertificate);
            VMCAAdapter.THROW_IF_NEEDED(error);
            p = pCertificate.getValue();
            if (p == null) {
                throw new IllegalStateException("Expected Certificate not Found");
            }
            String string = p.getString(0L);
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetSelfSignedCertificate(Pointer Data, String PrivateKey2, Date notBefore, Date notAfter) throws VMCAException {
        Pointer p = null;
        PointerByReference pCertificate = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCACreateSelfSignedCertificateA(Data, PrivateKey2, null, notBefore.getTime(), notAfter.getTime(), pCertificate);
            VMCAAdapter.THROW_IF_NEEDED(error);
            p = pCertificate.getValue();
            if (p == null) {
                throw new IllegalStateException("Expected Certificate not Found");
            }
            String string = p.getString(0L);
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            throw throwable;
        }
    }

    public static void RevokeCertificate(String ServerName, String Certificate2) throws VMCAException {
        int error = VMCA.INSTANCE.VMCARevokeCertificateA(ServerName, Certificate2);
        VMCAAdapter.THROW_IF_NEEDED(error);
    }

    public static boolean IsCACert(String Certificate2) {
        int error = VMCA.INSTANCE.VMCAValidateCACertificateA(Certificate2);
        return error == 0;
    }

    public static void FreeData(Pointer p) {
        if (p != null) {
            VMCA.INSTANCE.VMCAFreePKCS10DataA(p);
        }
    }

    private static void THROW_IF_NEEDED(int error) throws VMCAException {
        String err = null;
        if (error != 0) {
            try {
                err = VMCAAdapter.VMCAGetShortError(error);
            }
            catch (VMCAException ex) {
                err = "Unable to get error string from VMCA, Please use error code";
            }
            VMCAException exp = new VMCAException(err);
            exp.setErrorCode(error);
            throw exp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAJavaGenCert(String ServerName, String Name, String Country, String Locality, String State, String Organization, String OrgUnit, String DnsName, String URIName, String Email, String IPAddress, int KeyUsageConstraints, int isSelfSigned, String PrivateKey2, long tmNotBefore, long tmNotAfter) throws VMCAException {
        Pointer p = null;
        PointerByReference pCertificate = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCAJavaGenCertA(ServerName, Name, Country, Locality, State, Organization, OrgUnit, DnsName, URIName, Email, IPAddress, KeyUsageConstraints, isSelfSigned, PrivateKey2, tmNotBefore, tmNotAfter, pCertificate);
            VMCAAdapter.THROW_IF_NEEDED(error);
            p = pCertificate.getValue();
            if (p == null) {
                throw new IllegalStateException("Expected Certificate not Found");
            }
            String string = p.getString(0L);
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAGetSignedCertificateFromCSR(String ServerName, String CSR, long tmNotBefore, long tmNotAfter) throws VMCAException {
        Pointer p = null;
        PointerByReference pCertificate = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCAGetSignedCertificateFromCSRA(ServerName, CSR, tmNotBefore, tmNotAfter, pCertificate);
            VMCAAdapter.THROW_IF_NEEDED(error);
            p = pCertificate.getValue();
            if (p == null) {
                throw new IllegalStateException("Expected Certificate not Found");
            }
            String string = p.getString(0L);
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            throw throwable;
        }
    }

    public static Pointer VMCAOpenEnumContext(String ServerName, int certFilter) throws VMCAException {
        Pointer p = null;
        PointerByReference pContext = new PointerByReference();
        int error = VMCA.INSTANCE.VMCAOpenEnumContextA(ServerName, certFilter, pContext);
        VMCAAdapter.THROW_IF_NEEDED(error);
        p = pContext.getValue();
        if (p == null) {
            throw new IllegalStateException("Expected context not Found");
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAGetNextCertificate(Pointer ctx) throws VMCAException {
        Pointer pCert;
        PointerByReference ppCertificate;
        IntByReference pEnumStatus;
        block10: {
            IntByReference pCurrentIndex = new IntByReference();
            pEnumStatus = new IntByReference();
            ppCertificate = new PointerByReference();
            pCert = null;
            try {
                int error = VMCA.INSTANCE.VMCAGetNextCertificate(ctx, ppCertificate, pCurrentIndex, pEnumStatus);
                VMCAAdapter.THROW_IF_NEEDED(error);
                if (pEnumStatus.getValue() == 2) {
                    throw new RuntimeException("Certificate Enum Returned - VMCA_ENUM_ERROR");
                }
                if (pEnumStatus.getValue() != 1) break block10;
                String string = null;
                if (pCert != null) {
                    VMCA.INSTANCE.VMCAFreeCertificate(pCert);
                }
                return string;
            }
            catch (Throwable throwable) {
                if (pCert != null) {
                    VMCA.INSTANCE.VMCAFreeCertificate(pCert);
                }
                throw throwable;
            }
        }
        if (pEnumStatus.getValue() == 0) {
            String temp;
            pCert = ppCertificate.getValue();
            if (pCert == null) {
                throw new IllegalStateException("Expected Certificate not Found");
            }
            String string = temp = pCert.getString(0L);
            if (pCert != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(pCert);
            }
            return string;
        }
        if (pCert != null) {
            VMCA.INSTANCE.VMCAFreeCertificate(pCert);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAGetShortError(int dwError) throws VMCAException {
        String string;
        block5: {
            PointerByReference ppMsg = new PointerByReference();
            Pointer pMsg = null;
            try {
                int error = VMCA.INSTANCE.VMCAGetShortError(dwError, ppMsg);
                if (error != 0) {
                    VMCAException exp = new VMCAException("Unable to get Error String from VMCA");
                    exp.setErrorCode(error);
                    throw exp;
                }
                pMsg = ppMsg.getValue();
                if (pMsg == null) {
                    throw new IllegalStateException("Expected Error String not Found");
                }
                string = pMsg.getString(0L);
                if (pMsg == null) break block5;
                VMCA.INSTANCE.VMCAFreeVersion(pMsg);
            }
            catch (Throwable throwable) {
                if (pMsg != null) {
                    VMCA.INSTANCE.VMCAFreeVersion(pMsg);
                }
                throw throwable;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAGetErrorString(int dwError) throws VMCAException {
        String string;
        block5: {
            PointerByReference ppMsg = new PointerByReference();
            Pointer pMsg = null;
            try {
                int error = VMCA.INSTANCE.VMCAGetErrorString(dwError, ppMsg);
                if (error != 0) {
                    VMCAException exp = new VMCAException("Unable to get Error String from VMCA");
                    exp.setErrorCode(error);
                    throw exp;
                }
                pMsg = ppMsg.getValue();
                if (pMsg == null) {
                    throw new IllegalStateException("Expected Error String not Found");
                }
                string = pMsg.getString(0L);
                if (pMsg == null) break block5;
                VMCA.INSTANCE.VMCAFreeVersion(pMsg);
            }
            catch (Throwable throwable) {
                if (pMsg != null) {
                    VMCA.INSTANCE.VMCAFreeVersion(pMsg);
                }
                throw throwable;
            }
        }
        return string;
    }

    public static void VMCACloseEnumContext(Pointer ctx) {
        VMCA.INSTANCE.VMCACloseEnumContext(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAGetCRL(String ServerName, String existingCRL, String newCRL) throws VMCAException {
        int error = VMCA.INSTANCE.VMCAGetCRLA(ServerName, existingCRL, newCRL);
        VMCAAdapter.THROW_IF_NEEDED(error);
        return newCRL;
    }

    public static void VMCAPublishRoots(String ServerName) throws VMCAException {
        int error = VMCA.INSTANCE.VMCAPublishRootCertsA(ServerName);
        VMCAAdapter.THROW_IF_NEEDED(error);
    }

    static {
        String InstallPath;
        String[] paths;
        String VMCA_LIB64_PATH = "/usr/lib/vmware-vmca/lib64";
        String LIKEWISE_LIB64_PATH = "/opt/likewise/lib64";
        String LIB_PATH = "/usr/lib";
        String LIB_PATH_64 = "/usr/lib64";
        String DEV_PATH = "/mnt/hgfs/VMsrc/lotus/main/vmca/build/client/.libs";
        String ENCODING = "utf8";
        String propName = "jna.library.path";
        System.setProperty("jna.encoding", "utf8");
        String propValue = System.getProperty("jna.library.path");
        StringBuilder jnalibpath = new StringBuilder(propValue == null ? "" : propValue);
        for (String path : paths = new String[]{"/mnt/hgfs/VMsrc/lotus/main/vmca/build/client/.libs", "/usr/lib64", "/usr/lib", "/opt/likewise/lib64", "/usr/lib/vmware-vmca/lib64"}) {
            File libDir = new File(path);
            if (!libDir.exists() || !libDir.isDirectory()) continue;
            if (jnalibpath.length() > 0) {
                jnalibpath.append(":");
            }
            jnalibpath.append(path);
        }
        if (Platform.isWindows() && (InstallPath = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\VMware, Inc.\\VMware Certificate Services", (String)"InstallPath")).length() > 0) {
            jnalibpath.append(InstallPath);
        }
        if (!(propValue = jnalibpath.substring(0)).isEmpty()) {
            System.setProperty("jna.library.path", propValue);
        }
    }

    public static interface VMCA
    extends Library {
        public static final VMCA INSTANCE = (VMCA)Native.loadLibrary((String)"vmcaclient", VMCA.class);

        public int VMCAGetServerVersionA(String var1, PointerByReference var2);

        public int VMCAFreeVersion(Pointer var1);

        public int VMCAAddRootCertificateA(String var1, String var2, String var3, String var4);

        public int VMCAGetRootCACertificateA(String var1, PointerByReference var2);

        public void VMCAFreeCertificate(Pointer var1);

        public int VMCACreatePrivateKeyA(String var1, Integer var2, PointerByReference var3, PointerByReference var4);

        public void VMCAFreeKey(Pointer var1);

        public int VMCAAllocatePKCS10DataA(PointerByReference var1);

        public int VMCASetCertValueA(Integer var1, Pointer var2, String var3);

        public int VMCASetKeyUsageConstraintsA(Pointer var1, Integer var2);

        public int VMCACreateSigningRequestA(Pointer var1, String var2, String var3, PointerByReference var4);

        public int VMCAFreeCSR(Pointer var1);

        public int VMCAFreePKCS10DataA(Pointer var1);

        public int VMCAGetSignedCertificateA(String var1, Pointer var2, String var3, String var4, long var5, long var7, PointerByReference var9);

        public int VMCACreateSelfSignedCertificateA(Pointer var1, String var2, String var3, long var4, long var6, PointerByReference var8);

        public int VMCARevokeCertificateA(String var1, String var2);

        public int VMCAValidateCACertificateA(String var1);

        public int VMCAJavaGenCertA(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, int var12, int var13, String var14, long var15, long var17, PointerByReference var19);

        public int VMCAGetSignedCertificateFromCSRA(String var1, String var2, long var3, long var5, PointerByReference var7);

        public int VMCAOpenEnumContextA(String var1, int var2, PointerByReference var3);

        public int VMCAGetNextCertificate(Pointer var1, PointerByReference var2, IntByReference var3, IntByReference var4);

        public int VMCACloseEnumContext(Pointer var1);

        public int VMCAGetShortError(int var1, PointerByReference var2);

        public int VMCAGetErrorString(int var1, PointerByReference var2);

        public int VMCAGetCRLA(String var1, String var2, String var3);

        public int VMCAPublishRootCertsA(String var1);
    }

    public static interface VMCA_ENUM_RETRUN_CODE {
        public static final int VMCA_ENUM_SUCCESS = 0;
        public static final int VMCA_ENUM_END = 1;
        public static final int VMCA_ENUM_ERROR = 2;
    }

    public static interface VMCA_OID {
        public static final int VMCA_OID_CN = 1;
        public static final int VMCA_OID_DC = 2;
        public static final int VMCA_OID_COUNTRY = 3;
        public static final int VMCA_OID_LOCALITY = 4;
        public static final int VMCA_OID_STATE = 5;
        public static final int VMCA_OID_ORGANIZATION = 6;
        public static final int VMCA_OID_ORG_UNIT = 7;
        public static final int VMCA_OID_DNS = 8;
        public static final int VMCA_OID_URI = 9;
        public static final int VMCA_OID_EMAIL = 10;
        public static final int VMCA_OID_IPADDRESS = 11;
    }
}

