/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.common.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.ClientFuture;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.common.Request;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.common.Stub;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.client.common.impl.FetchRequestImpl;
import com.vmware.vim.vmomi.client.common.impl.RequestImpl;
import com.vmware.vim.vmomi.client.common.impl.ResponseImpl;
import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.RequestContextProvider;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.client.http.impl.ClientExceptionTranslator;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.ResponseContext;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectFactory;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodInvocationHandlerImpl
implements InvocationHandler,
Stub {
    private static final Log LOG = LogFactory.getLog(MethodInvocationHandlerImpl.class);
    private static final Method SET_REQ_CTX;
    private static final Method GET_REQ_CTX;
    private static final Method GET_RESP_CTX;
    private static final Method SET_REQ_CTX_OLD;
    private static final Method GET_RESP_CTX_OLD;
    private static final Method GET_MO_CLASS;
    private static final Method GET_REF;
    private static final Method TO_STRING;
    private static final Method EQUALS;
    private static final Method HASH_CODE;
    private final ManagedObjectReference _moRef;
    private final ManagedObjectType _moType;
    private final ProtocolBinding _binding;
    private final VmodlVersion _version;
    private RequestContext _requestContext;
    private volatile ThreadLocal<ResponseContext> _responseContext;
    private final ManagedObjectFactory _factory;
    private final ResultInterceptor _resultInterceptor;
    private final ReentrantReadWriteLock _stateLock;
    private final RequestRetryCallback _requestRetryCallback;
    private final RequestContextProvider _requestContextProvider;
    private final VmodlContext _context;

    public MethodInvocationHandlerImpl(ManagedObjectReference moRef, ManagedObjectType moType, VmodlVersion version, ProtocolBinding binding, ManagedObjectFactory factory, ResultInterceptor resultInterceptor, RequestRetryCallback requestRetryCallback, RequestContextProvider requestContextProvider, VmodlContext context) {
        this._moRef = moRef;
        this._moType = moType;
        this._version = version;
        this._binding = binding;
        this._factory = factory;
        this._resultInterceptor = resultInterceptor;
        this._stateLock = new ReentrantReadWriteLock();
        this._requestRetryCallback = requestRetryCallback;
        this._requestContextProvider = requestContextProvider;
        this._context = context;
    }

    public void _setRequestContext(RequestContext context) {
        this._requestContext = context;
    }

    public RequestContext _getRequestContext() {
        return this._requestContext;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this._stateLock.readLock().lock();
        try {
            if (this._moType.getManagedProperty(method) != null) {
                Object object = this.invokeFetch(this._moType.getManagedProperty(method), args);
                return object;
            }
            if (this._moType.getMethod(method) != null) {
                Object object = this.invokeOperation(this._moType.getMethod(method), args);
                return object;
            }
            int[] matchingParams = this._moType.getMatchingParameters(method);
            if (matchingParams != null) {
                ManagedMethod managedMethod = this._moType.getMethod(method.getName());
                int argsLen = managedMethod.getParameters().length;
                if (MethodInvocationHandlerImpl.resolveAsyncMode(args)) {
                    ++argsLen;
                }
                Object[] mainMethodArgs = new Object[argsLen];
                for (int i = 0; i < matchingParams.length; ++i) {
                    mainMethodArgs[matchingParams[i]] = args[i];
                }
                Object i = this.invokeOperation(managedMethod, mainMethodArgs);
                return i;
            }
            if (SET_REQ_CTX.equals(method) || SET_REQ_CTX_OLD.equals(method)) {
                this.upgradeToWriteLock();
                this._setRequestContext((RequestContext)args[0]);
                Object managedMethod = null;
                return managedMethod;
            }
            if (GET_REQ_CTX.equals(method)) {
                RequestContext managedMethod = this._getRequestContext();
                return managedMethod;
            }
            if (GET_RESP_CTX.equals(method) || GET_RESP_CTX_OLD.equals(method)) {
                ResponseContext managedMethod = this._getResponseContext();
                return managedMethod;
            }
            if (GET_MO_CLASS.equals(method)) {
                Class<? extends ManagedObject> managedMethod = this._getManagedObjectClass();
                return managedMethod;
            }
            if (GET_REF.equals(method)) {
                ManagedObjectReference managedMethod = this._moRef;
                return managedMethod;
            }
            if (TO_STRING.equals(method)) {
                String managedMethod = "Stub: moRef = (" + this._moRef + "), " + "binding = " + (this._binding != null ? this._binding.getEndpointUri() : "none");
                return managedMethod;
            }
            if (EQUALS.equals(method)) {
                Boolean managedMethod = proxy == args[0];
                return managedMethod;
            }
            if (HASH_CODE.equals(method)) {
                Integer managedMethod = this.hashCode();
                return managedMethod;
            }
            try {
                throw new IllegalArgumentException(String.format("Cannot invoke method '%1$s' on Managed Object '%2$s'", method.getName(), this._moType));
            }
            catch (Exception e) {
                Class<?>[] declaredExceptions;
                e = ClientExceptionTranslator.translate(e);
                if (RuntimeException.class.isInstance(e)) {
                    throw e;
                }
                for (Class<?> ex : declaredExceptions = method.getExceptionTypes()) {
                    if (!ex.isInstance(e)) continue;
                    throw e;
                }
                throw new InternalException(String.format("Managed Object '%1$s' thrown unexpected exception '%2$s'%3$s when invoking method '%4$s'", this._moType.getTypeName(), e.getClass().getName(), e.getMessage() != null ? " with message '" + e.getMessage() + "'" : "", method.getName()), e);
            }
        }
        finally {
            if (this._stateLock.isWriteLockedByCurrentThread()) {
                this._stateLock.writeLock().unlock();
            } else {
                this._stateLock.readLock().unlock();
            }
        }
    }

    private void upgradeToWriteLock() {
        this._stateLock.readLock().unlock();
        this._stateLock.writeLock().lock();
    }

    private Object invokeOperation(ManagedMethod method, Object[] args) throws Throwable {
        boolean async = MethodInvocationHandlerImpl.resolveAsyncMode(args);
        InvocationContext invContext = this.buildInvocationContext(method, args, async);
        ClientFuture<Object> future = this.resolveFuture(args, async, this._resultInterceptor, invContext);
        RequestImpl request = new RequestImpl(method, this._version, this._moRef, args, this.getRequestContext(invContext), this._context);
        ResponseImpl response = new ResponseImpl(method.getResult(), false, this._version, this._factory, this._resultInterceptor, invContext, future, this._context);
        return this.completeCall(request, response, future, async);
    }

    private Object invokeFetch(ManagedProperty property, Object[] args) throws Throwable {
        boolean async = MethodInvocationHandlerImpl.resolveAsyncMode(args);
        InvocationContext invContext = this.buildInvocationContext(property.getAccessor(), args, async);
        ClientFuture<Object> future = this.resolveFuture(args, async, this._resultInterceptor, invContext);
        FetchRequestImpl request = new FetchRequestImpl(property, this._version, this._moRef, this.getRequestContext(invContext), this._context);
        ResponseImpl response = new ResponseImpl((VmodlField)property, true, this._version, this._factory, this._resultInterceptor, invContext, future, this._context);
        return this.completeCall(request, response, future, async);
    }

    private RequestContext getRequestContext(InvocationContext invContext) {
        if (this._requestContextProvider != null) {
            return this._requestContextProvider.getRequestContext(invContext);
        }
        return this._requestContext;
    }

    private Object completeCall(Request request, Response response, ClientFuture<Object> future, boolean async) throws Throwable {
        CallExecutor executor = new CallExecutor(request, response, future, async);
        return executor.executeCall();
    }

    private static boolean resolveAsyncMode(Object[] args) {
        return args != null && args.length > 0 && args[args.length - 1] instanceof Future;
    }

    private ClientFuture<Object> resolveFuture(Object[] args, boolean async, ResultInterceptor resultInterceptor, InvocationContext invContext) {
        Future userFuture;
        ClientFuture<Object> ret = null;
        ret = async ? ((userFuture = (Future)args[args.length - 1]) instanceof ClientFuture ? (ClientFuture)userFuture : new ClientFutureAdapter((Future<Object>)userFuture)) : new ClientFutureImpl<Object>();
        if (this._requestRetryCallback != null) {
            ret = new RetryingFuture(ret, this._requestRetryCallback, invContext);
        }
        return ret;
    }

    private InvocationContext buildInvocationContext(ManagedMethod method, Object[] args, boolean async) {
        Object[] invocationContextArgs = null;
        if (!async) {
            invocationContextArgs = args;
        } else if (args.length > 1) {
            int len = args.length - 1;
            invocationContextArgs = new Object[len];
            System.arraycopy(args, 0, invocationContextArgs, 0, len);
        }
        return new InvocationContext(this._requestContext, method, this._moRef, this._binding, invocationContextArgs);
    }

    public ResponseContext _getResponseContext() {
        this.initResponseContextProp();
        return this._responseContext.get();
    }

    private void setResponseContext(ResponseContext context) {
        this.initResponseContextProp();
        this._responseContext.set(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initResponseContextProp() {
        if (null == this._responseContext) {
            MethodInvocationHandlerImpl methodInvocationHandlerImpl = this;
            synchronized (methodInvocationHandlerImpl) {
                if (null == this._responseContext) {
                    this._responseContext = new ThreadLocal();
                }
            }
        }
    }

    @Override
    public ResponseContext getResponseContext() {
        throw new IllegalStateException("Unsupported method getResponseContext(). Use _getResponseContext() instead");
    }

    @Override
    public void setRequestContext(RequestContext context) {
        throw new IllegalStateException("Unsupported method setRequestContext(). Use _setRequestContext() instead");
    }

    public Class<? extends ManagedObject> _getManagedObjectClass() {
        return this._moType.getTypeClass();
    }

    static {
        try {
            SET_REQ_CTX = Stub.class.getMethod("_setRequestContext", RequestContext.class);
            SET_REQ_CTX_OLD = Stub.class.getMethod("setRequestContext", RequestContext.class);
            GET_REQ_CTX = Stub.class.getMethod("_getRequestContext", new Class[0]);
            GET_RESP_CTX = Stub.class.getMethod("_getResponseContext", new Class[0]);
            GET_RESP_CTX_OLD = Stub.class.getMethod("getResponseContext", new Class[0]);
            GET_MO_CLASS = Stub.class.getMethod("_getManagedObjectClass", new Class[0]);
            GET_REF = ManagedObject.class.getMethod("_getRef", new Class[0]);
            TO_STRING = Object.class.getMethod("toString", new Class[0]);
            EQUALS = Object.class.getMethod("equals", Object.class);
            HASH_CODE = Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (SecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ClientFutureAdapter
    implements ClientFuture<Object> {
        private final Future<Object> _delegate;

        public ClientFutureAdapter(Future<Object> delegate) {
            this._delegate = delegate;
        }

        @Override
        public ResponseContext getResponseContext() {
            throw new UnsupportedOperationException("Unsupported method getResponseContext(). Use _getResponseContext() instead");
        }

        @Override
        public void setResponseContext(ResponseContext context) {
        }

        public void set(Object ret) {
            this._delegate.set(ret);
        }

        public void set() {
            this._delegate.set();
        }

        public void setException(Exception e) {
            this._delegate.setException(e);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this._delegate.cancel(mayInterruptIfRunning);
        }

        public Object get() throws InterruptedException, ExecutionException {
            return this._delegate.get();
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this._delegate.get(timeout, unit);
        }

        public boolean isCancelled() {
            return this._delegate.isCancelled();
        }

        public boolean isDone() {
            return this._delegate.isDone();
        }
    }

    private class CallExecutor {
        private Request _request;
        private Response _response;
        private ClientFuture<Object> _future;
        private boolean _async;

        public CallExecutor(Request request, Response response, ClientFuture<Object> future, boolean async) {
            this._request = request;
            this._response = response;
            this._future = future;
            this._async = async;
            if (future instanceof RetryingFuture) {
                ((RetryingFuture)future).setCallExecutor(this);
            }
        }

        public Object executeCall() throws Throwable {
            this.sendCall();
            if (this._async) {
                return null;
            }
            try {
                Object ret;
                Object object = ret = this._future.get();
                return object;
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            finally {
                MethodInvocationHandlerImpl.this.setResponseContext(this._future.getResponseContext());
            }
        }

        public void sendCall() {
            MethodInvocationHandlerImpl.this.setResponseContext(null);
            MethodInvocationHandlerImpl.this._binding.send(this._request, this._response, !this._async);
        }
    }

    private static class RetryingFuture
    implements ClientFuture<Object> {
        private final ClientFuture<Object> _future;
        private final RequestRetryCallback _faultInterceptor;
        private final InvocationContext _invocationContext;
        private int _retryCount = 0;
        private CallExecutor _executor;
        private ResponseContext _responseContext;

        public RetryingFuture(ClientFuture<Object> future, RequestRetryCallback faultInterceptor, InvocationContext invocationContext) {
            this._future = future;
            this._faultInterceptor = faultInterceptor;
            this._invocationContext = invocationContext;
        }

        public void setCallExecutor(CallExecutor executor) {
            this._executor = executor;
        }

        @Override
        public ResponseContext getResponseContext() {
            return this._responseContext;
        }

        @Override
        public void setResponseContext(ResponseContext context) {
            this._responseContext = context;
        }

        public void set(Object ret) {
            this._future.set(ret);
        }

        public void set() {
            this._future.set();
        }

        public void setException(Exception e) {
            boolean shouldRetry;
            block4: {
                shouldRetry = false;
                try {
                    shouldRetry = this._faultInterceptor != null && this._faultInterceptor.retry(e, this._invocationContext, this._retryCount);
                }
                catch (Exception x) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)"Exception on RequestRetryCallback.retry(...)", (Throwable)x);
                }
            }
            if (shouldRetry) {
                ++this._retryCount;
                this._executor.sendCall();
            } else {
                this._future.setException(e);
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this._future.cancel(mayInterruptIfRunning);
        }

        public Object get() throws InterruptedException, ExecutionException {
            return this._future.get();
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this._future.get(timeout, unit);
        }

        public boolean isCancelled() {
            return this._future.isCancelled();
        }

        public boolean isDone() {
            return this._future.isDone();
        }
    }
}

